/*
 * Decompiled with CFR 0.152.
 */
package de.jflex.plugin.cup;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.File;
import java.util.ArrayList;
import java_cup.Main;
import org.apache.maven.plugin.logging.Log;

class CliCupInvoker {
    private final Log log;

    CliCupInvoker(Log log) {
        this.log = log;
    }

    void invoke(String javaPackage, File outputDirectory, String parserClassName, String symClassName, boolean symbolInterface, String cupFileName) throws Exception {
        Object[] args = CliCupInvoker.buildArgv(javaPackage, outputDirectory, parserClassName, symClassName, symbolInterface, cupFileName);
        this.log.debug((CharSequence)("cup " + Joiner.on((char)' ').join(args)));
        Main.main((String[])args);
    }

    @VisibleForTesting
    static String[] buildArgv(String javaPackage, File outputDirectory, String parserClassName, String symClassName, boolean symbolInterface, String cupFileName) {
        ArgBuilder args = new ArgBuilder();
        if (!Strings.isNullOrEmpty((String)javaPackage)) {
            args.addOption("package", javaPackage);
        }
        args.addOption("destdir", outputDirectory.getAbsolutePath());
        args.addOption("parser", parserClassName);
        args.addOption("symbols", symClassName);
        if (symbolInterface) {
            args.addOption("interface");
        }
        args.addArg(cupFileName);
        return args.buildArray();
    }

    private static class ArgBuilder {
        private final ArrayList<String> args = new ArrayList();

        private ArgBuilder() {
        }

        ArgBuilder addArg(String argument) {
            this.args.add(argument);
            return this;
        }

        ArgBuilder addOption(String optionName) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)optionName) ? 1 : 0) != 0, (Object)"Option name cannot be empty");
            this.args.add("-" + optionName);
            return this;
        }

        ArgBuilder addOption(String optionName, String optionValue) {
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)optionName) ? 1 : 0) != 0, (Object)"Option name cannot be empty");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)optionValue) ? 1 : 0) != 0, (Object)String.format("Value for option -%s should not be empty", optionName));
            this.args.add("-" + optionName);
            this.args.add(optionValue);
            return this;
        }

        String[] buildArray() {
            return this.args.toArray(new String[this.args.size()]);
        }
    }
}

