/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.xstream;

import com.thoughtworks.xstream.XStream;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.SessionTranscoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.catalina.Manager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class XStreamTranscoder
extends SessionTranscoder
implements SessionAttributesTranscoder {
    private static final Log LOG = LogFactory.getLog(XStreamTranscoder.class);
    private final Manager _manager;
    private final XStream _xstream;

    public XStreamTranscoder(Manager manager) {
        this._manager = manager;
        this._xstream = new XStream();
    }

    public byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        return this.doSerialize(attributes);
    }

    private byte[] doSerialize(Object object) {
        if (object == null) {
            throw new NullPointerException("Can't serialize null");
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this._xstream.toXML(object, (OutputStream)bos);
            byte[] byArray = bos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Non-serializable object", e);
        }
        finally {
            this.closeSilently(bos);
        }
    }

    public Map<String, Object> deserializeAttributes(byte[] in) {
        ByteArrayInputStream bis = new ByteArrayInputStream(in);
        try {
            Map result;
            Map map = result = (Map)this._xstream.fromXML((InputStream)bis);
            return map;
        }
        catch (RuntimeException e) {
            LOG.warn((Object)("Caught Exception decoding " + in.length + " bytes of data"), (Throwable)e);
            throw e;
        }
        finally {
            this.closeSilently(bis);
        }
    }

    protected byte[] serialize(Object o) {
        return this.doSerialize(o);
    }

    protected MemcachedBackupSession deserialize(byte[] in) {
        ByteArrayInputStream bis = new ByteArrayInputStream(in);
        try {
            MemcachedBackupSession session = (MemcachedBackupSession)this._manager.createEmptySession();
            this._xstream.fromXML((InputStream)bis, (Object)session);
            MemcachedBackupSession memcachedBackupSession = session;
            return memcachedBackupSession;
        }
        catch (RuntimeException e) {
            this.getLogger().warn("Caught Exception decoding %d bytes of data", new Object[]{in.length, e});
            throw e;
        }
        finally {
            this.closeSilently(bis);
        }
    }

    private void closeSilently(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

