/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer;

import de.javakaffee.web.msm.JavaSerializationTranscoder;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedBackupSessionManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderService;
import de.javakaffee.web.msm.serializer.TestClasses;
import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import de.javakaffee.web.msm.serializer.javolution.JavolutionTranscoder;
import de.javakaffee.web.msm.serializer.kryo.KryoTranscoder;
import java.util.Calendar;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.catalina.Container;
import org.apache.catalina.Loader;
import org.apache.catalina.core.StandardContext;
import org.apache.catalina.loader.WebappLoader;

public class Benchmark {
    public static void main(String[] args) throws InterruptedException {
        MemcachedBackupSessionManager manager = Benchmark.createManager();
        int warmupCycles = 100;
        Benchmark.warmup(manager, (SessionAttributesTranscoder)new KryoTranscoder(), 100, 100, 3);
        Benchmark.warmup(manager, (SessionAttributesTranscoder)new JavaSerializationTranscoder(), 100, 100, 3);
        Benchmark.warmup(manager, (SessionAttributesTranscoder)new JavolutionTranscoder(Thread.currentThread().getContextClassLoader(), false, new CustomXMLFormat[0]), 100, 100, 3);
        Benchmark.recover();
        Benchmark.benchmark(manager, 10, 500, 4);
        Benchmark.benchmark(manager, 10, 100, 3);
        Benchmark.benchmark(manager, 10, 10, 2);
    }

    private static void benchmark(MemcachedBackupSessionManager manager, int rounds, int countPersons, int nodesPerEdge) throws InterruptedException {
        Stats kryoSerStats = new Stats();
        Stats kryoDeSerStats = new Stats();
        Benchmark.benchmark(manager, (SessionAttributesTranscoder)new KryoTranscoder(), kryoSerStats, kryoDeSerStats, rounds, countPersons, nodesPerEdge);
        Stats javaSerStats = new Stats();
        Stats javaDeSerStats = new Stats();
        Benchmark.benchmark(manager, (SessionAttributesTranscoder)new JavaSerializationTranscoder(), javaSerStats, javaDeSerStats, rounds, countPersons, nodesPerEdge);
        Benchmark.recover();
        Stats javolutionSerStats = new Stats();
        Stats javolutionDeSerStats = new Stats();
        Benchmark.benchmark(manager, (SessionAttributesTranscoder)new JavolutionTranscoder(Thread.currentThread().getContextClassLoader(), false, new CustomXMLFormat[0]), javolutionSerStats, javolutionDeSerStats, rounds, countPersons, nodesPerEdge);
        Benchmark.recover();
        System.out.println("Serialization,Size,Ser-Min,Ser-Avg,Ser-Max,Deser-Min,Deser-Avg,Deser-Max");
        System.out.println(Benchmark.toCSV("Java", javaSerStats, javaDeSerStats));
        System.out.println(Benchmark.toCSV("Javolution", javolutionSerStats, javolutionDeSerStats));
        System.out.println(Benchmark.toCSV("Kryo", kryoSerStats, kryoDeSerStats));
    }

    private static String toCSV(String name, Stats serStats, Stats deSerStats) {
        return name + "," + serStats.size + "," + Benchmark.minAvgMax(serStats) + "," + Benchmark.minAvgMax(deSerStats);
    }

    private static String minAvgMax(Stats stats) {
        return stats.min + "," + stats.avg + "," + stats.max;
    }

    private static void recover() throws InterruptedException {
        Thread.sleep(200L);
        System.gc();
        Thread.sleep(200L);
    }

    private static void benchmark(MemcachedBackupSessionManager manager, SessionAttributesTranscoder transcoder, Stats serializationStats, Stats deserializationStats, int rounds, int countPersons, int nodesPerEdge) throws InterruptedException {
        int i;
        long start;
        int r;
        System.out.println("Running benchmark for " + transcoder.getClass().getSimpleName() + "... (rounds: " + rounds + ", persons: " + countPersons + ", nodes: " + ((int)Math.pow(nodesPerEdge, nodesPerEdge) + nodesPerEdge + 1) + ")");
        TranscoderService transcoderService = new TranscoderService(transcoder);
        MemcachedBackupSession session = Benchmark.createSession(manager, "123456789abcdefghijk987654321", countPersons, nodesPerEdge);
        byte[] data = transcoderService.serialize(session);
        int size = data.length;
        for (r = 0; r < rounds; ++r) {
            start = System.currentTimeMillis();
            for (i = 0; i < 500; ++i) {
                transcoderService.serialize(session);
            }
            serializationStats.registerSince(start);
            serializationStats.setSize(size);
        }
        System.gc();
        Thread.sleep(100L);
        for (r = 0; r < rounds; ++r) {
            start = System.currentTimeMillis();
            for (i = 0; i < 500; ++i) {
                transcoderService.deserialize(data, (MemcachedSessionService.SessionManager)manager);
            }
            deserializationStats.registerSince(start);
            deserializationStats.setSize(size);
        }
    }

    private static void warmup(MemcachedBackupSessionManager manager, SessionAttributesTranscoder transcoder, int loops, int countPersons, int nodesPerEdge) throws InterruptedException {
        TranscoderService transcoderService = new TranscoderService(transcoder);
        MemcachedBackupSession session = Benchmark.createSession(manager, "123456789abcdefghijk987654321", countPersons, nodesPerEdge);
        System.out.print("Performing warmup for serialization using " + transcoder.getClass().getSimpleName() + "...");
        long serWarmupStart = System.currentTimeMillis();
        for (int i = 0; i < loops; ++i) {
            transcoderService.serialize(session);
        }
        System.out.println(" (" + (System.currentTimeMillis() - serWarmupStart) + " ms)");
        System.out.print("Performing warmup for deserialization...");
        byte[] data = transcoderService.serialize(session);
        long deserWarmupStart = System.currentTimeMillis();
        for (int i = 0; i < loops; ++i) {
            transcoderService.deserialize(data, (MemcachedSessionService.SessionManager)manager);
        }
        System.out.println(" (" + (System.currentTimeMillis() - deserWarmupStart) + " ms)");
    }

    private static MemcachedBackupSession createSession(MemcachedBackupSessionManager manager, String id, int countPersons, int countNodesPerEdge) {
        MemcachedBackupSession session = manager.createEmptySession();
        session.setId(id);
        session.setValid(true);
        session.setAttribute("stringbuffer", (Object)new StringBuffer("<string\n&buffer/>"));
        session.setAttribute("stringbuilder", (Object)new StringBuilder("<string\n&buffer/>"));
        session.setAttribute("persons", (Object)Benchmark.createPersons(countPersons));
        session.setAttribute("mycontainer", (Object)new TestClasses.MyContainer());
        session.setAttribute("component", (Object)Benchmark.createComponents(countNodesPerEdge));
        return session;
    }

    private static TestClasses.Component createComponents(int countNodesPerEdge) {
        TestClasses.Component root = new TestClasses.Component("root");
        for (int i = 0; i < countNodesPerEdge; ++i) {
            TestClasses.Component node = new TestClasses.Component("child" + i);
            Benchmark.addChildren(node, countNodesPerEdge);
            root.addChild(node);
        }
        return root;
    }

    private static void addChildren(TestClasses.Component node, int count) {
        for (int i = 0; i < count; ++i) {
            node.addChild(new TestClasses.Component(node.getName() + "-" + i));
        }
    }

    private static TestClasses.Person[] createPersons(int countPersons) {
        TestClasses.Person[] persons = new TestClasses.Person[countPersons];
        for (int i = 0; i < countPersons; ++i) {
            Calendar dateOfBirth = Calendar.getInstance();
            dateOfBirth.set(1, dateOfBirth.get(1) - 42);
            TestClasses.Person person = TestClasses.createPerson("Firstname" + i + " Lastname" + i, i % 2 == 0 ? TestClasses.Person.Gender.FEMALE : TestClasses.Person.Gender.MALE, dateOfBirth, "email" + i + "-1@example.org", "email" + i + "-2@example.org", "email" + i + "-3@example.org");
            person.addAddress(new TestClasses.Address("route66", "123456", "sincity", "sincountry"));
            if (i > 0) {
                person.addFriend(persons[i - 1]);
            }
            persons[i] = person;
        }
        return persons;
    }

    private static MemcachedBackupSessionManager createManager() {
        MemcachedBackupSessionManager manager = new MemcachedBackupSessionManager();
        StandardContext container = new StandardContext();
        manager.setContainer((Container)container);
        WebappLoader webappLoader = new WebappLoader(){

            public ClassLoader getClassLoader() {
                return Thread.currentThread().getContextClassLoader();
            }
        };
        manager.getContainer().setLoader((Loader)webappLoader);
        return manager;
    }

    static class Stats {
        long min;
        long max;
        double avg;
        int size;
        private boolean _first = true;
        private final AtomicInteger _count = new AtomicInteger();

        Stats() {
        }

        public void registerSince(long startInMillis) {
            this.register(System.currentTimeMillis() - startInMillis);
        }

        public void setSize(int size) {
            this.size = size;
        }

        public void register(long value) {
            if (value < this.min || this._first) {
                this.min = value;
            }
            if (value > this.max || this._first) {
                this.max = value;
            }
            this.avg = (this.avg * (double)this._count.get() + (double)value) / (double)this._count.incrementAndGet();
            this._first = false;
        }

        public String[] getInfo() {
            return new String[]{"Count = " + this._count.get(), "Min = " + this.min, "Avg = " + this.avg, "Max = " + this.max};
        }
    }
}

