/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import de.javakaffee.web.msm.serializer.kryo.KryoCustomization;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.userdetails.User;

public class SpringSecurityUserRegistration
implements KryoCustomization {
    @Override
    public void customize(Kryo kryo) {
        kryo.register(User.class, (Serializer)new SpringSecurityUserSerializer(kryo));
    }

    static class SpringSecurityUserSerializer
    extends Serializer<User> {
        private final Kryo _kryo;

        public SpringSecurityUserSerializer(Kryo kryo) {
            this._kryo = kryo;
        }

        public User read(Kryo kryo, Input input, Class<User> type) {
            String password = input.readString();
            String username = input.readString();
            int size = input.readInt(true);
            ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>(size);
            for (int i = 0; i < size; ++i) {
                authorities.add((GrantedAuthority)this._kryo.readClassAndObject(input));
            }
            boolean accountNonExpired = input.readBoolean();
            boolean accountNonLocked = input.readBoolean();
            boolean credentialsNonExpired = input.readBoolean();
            boolean enabled = input.readBoolean();
            return new User(username, password, enabled, accountNonExpired, credentialsNonExpired, accountNonLocked, authorities);
        }

        public void write(Kryo kryo, Output output, User user) {
            output.writeString(user.getPassword());
            output.writeString(user.getUsername());
            Collection authorities = user.getAuthorities();
            output.writeInt(authorities.size(), true);
            for (GrantedAuthority item : authorities) {
                this._kryo.writeClassAndObject(output, (Object)item);
            }
            output.writeBoolean(user.isAccountNonExpired());
            output.writeBoolean(user.isAccountNonLocked());
            output.writeBoolean(user.isCredentialsNonExpired());
            output.writeBoolean(user.isEnabled());
        }
    }
}

