/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javolution.text.CharArray;
import javolution.text.TypeFormat;
import javolution.xml.XMLFormat;
import javolution.xml.sax.Attributes;
import javolution.xml.stream.XMLStreamException;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import sun.reflect.ReflectionFactory;

public class ReflectionFormat<T>
extends XMLFormat<T> {
    private static final Log LOG = LogFactory.getLog(ReflectionFormat.class);
    private static final Map<Class<?>, XMLNumberFormat<?>> NUMBER_FORMATS = new ConcurrentHashMap();
    private static final ReflectionFactory REFLECTION_FACTORY = ReflectionFactory.getReflectionFactory();
    private static final Object[] INITARGS = new Object[0];
    private final Constructor<T> _constructor;
    private final AttributeHandler[] _attributes;
    private final Field[] _elements;
    private final Map<String, Field> _attributesMap;

    public ReflectionFormat(Class<T> clazz, ClassLoader classLoader) {
        super(null);
        try {
            this._constructor = REFLECTION_FACTORY.newConstructorForSerialization(clazz, Object.class.getDeclaredConstructor(new Class[0]));
            this._constructor.setAccessible(true);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        AttributesAndElements fields = this.allFields(clazz);
        this._attributes = fields.attributes.toArray(new AttributeHandler[fields.attributes.size()]);
        this._elements = fields.elements.toArray(new Field[fields.elements.size()]);
        this._attributesMap = new HashMap<String, Field>(this._attributes.length + 1);
        for (AttributeHandler attribute : this._attributes) {
            this._attributesMap.put(attribute._field.getName(), attribute._field);
        }
    }

    private AttributesAndElements allFields(Class<T> cls) {
        AttributesAndElements result = new AttributesAndElements();
        for (Class<T> clazz = cls; clazz != null; clazz = clazz.getSuperclass()) {
            this.addDeclaredFields(clazz, result);
        }
        return result;
    }

    private void addDeclaredFields(Class<? super T> clazz, AttributesAndElements result) {
        Field[] declaredFields;
        for (Field field : declaredFields = clazz.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            field.setAccessible(true);
            result.add(field);
        }
    }

    protected static boolean isAttribute(Field field) {
        return ReflectionFormat.isAttribute(field.getType());
    }

    protected static boolean isAttribute(Class<?> clazz) {
        return clazz.isPrimitive() || clazz.isEnum() || clazz == String.class || clazz == Boolean.class || clazz == Integer.class || clazz == Long.class || clazz == Short.class || clazz == Double.class || clazz == Float.class || clazz == Character.class || clazz == Byte.class || clazz == Currency.class;
    }

    public T newInstance(Class<T> clazz, XMLFormat.InputElement xml) throws XMLStreamException {
        try {
            return this._constructor.newInstance(INITARGS);
        }
        catch (Exception e) {
            throw new XMLStreamException((Throwable)e);
        }
    }

    public void read(XMLFormat.InputElement input, T obj) throws XMLStreamException {
        this.readAttributes(input, obj);
        this.readElements(input, obj);
    }

    private void readAttributes(XMLFormat.InputElement input, T obj) throws XMLStreamException {
        Attributes attributes = input.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            CharArray name = attributes.getLocalName(i);
            if (name.equals("class") || name.equals("__id")) continue;
            Field field = this._attributesMap.get(name.toString());
            if (field != null) {
                this.setFieldFromAttribute(obj, field, input);
                continue;
            }
            LOG.warn((Object)("Did not find field " + name + ", attribute value is " + attributes.getValue(i)));
        }
    }

    private void readElements(XMLFormat.InputElement input, T obj) {
        for (Field field : this._elements) {
            try {
                Object value = input.get(field.getName());
                field.set(obj, value);
            }
            catch (Exception e) {
                LOG.error((Object)("Could not set field value for field " + field), (Throwable)e);
            }
        }
    }

    public void write(T obj, XMLFormat.OutputElement output) throws XMLStreamException {
        this.writeAttributes(obj, output);
        this.writeElements(obj, output);
    }

    private void writeAttributes(T obj, XMLFormat.OutputElement output) {
        for (AttributeHandler handler : this._attributes) {
            try {
                handler.writeAttribute(obj, output);
            }
            catch (Exception e) {
                LOG.error((Object)"Could not set attribute from field value.", (Throwable)e);
            }
        }
    }

    private void writeElements(T obj, XMLFormat.OutputElement output) {
        for (Field field : this._elements) {
            try {
                Object object = field.get(obj);
                if (object == null) continue;
                output.add(object, field.getName());
            }
            catch (Exception e) {
                LOG.error((Object)"Could not write element for field.", (Throwable)e);
            }
        }
    }

    @SuppressWarnings(value={"REC_CATCH_EXCEPTION"})
    private void setFieldFromAttribute(T obj, Field field, XMLFormat.InputElement input) {
        block33: {
            try {
                String fieldName = field.getName();
                Class<Comparable<Boolean>> fieldType = field.getType();
                if (fieldType.isPrimitive()) {
                    if (fieldType == Boolean.TYPE) {
                        field.setBoolean(obj, input.getAttribute(fieldName, false));
                    } else if (fieldType == Integer.TYPE) {
                        field.setInt(obj, input.getAttribute(fieldName, 0));
                    } else if (fieldType == Long.TYPE) {
                        field.setLong(obj, input.getAttribute(fieldName, 0L));
                    } else if (fieldType == Float.TYPE) {
                        field.setFloat(obj, input.getAttribute(fieldName, 0.0f));
                    } else if (fieldType == Double.TYPE) {
                        field.setDouble(obj, input.getAttribute(fieldName, 0.0));
                    } else if (fieldType == Byte.TYPE) {
                        field.setByte(obj, input.getAttribute(fieldName, (byte)0));
                    } else if (fieldType == Character.TYPE) {
                        field.setChar(obj, input.getAttribute(fieldName, '\u0000'));
                    } else if (fieldType == Short.TYPE) {
                        field.setShort(obj, input.getAttribute(fieldName, (short)0));
                    }
                    break block33;
                }
                if (fieldType.isEnum()) {
                    String value = input.getAttribute(fieldName, (String)null);
                    if (value != null) {
                        Enum enumValue = Enum.valueOf(fieldType.asSubclass(Enum.class), value);
                        field.set(obj, enumValue);
                    }
                    break block33;
                }
                CharArray object = input.getAttribute(fieldName);
                if (object == null) break block33;
                if (fieldType == String.class) {
                    field.set(obj, this.getAttribute(input, fieldName, (String)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Boolean.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Boolean)null));
                    field.set(obj, this.getAttribute(input, fieldName, (Boolean)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Integer.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Integer)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Long.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Long)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Short.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Short)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Double.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Double)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Float.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Float)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Byte.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Byte)null));
                    break block33;
                }
                if (fieldType.isAssignableFrom(Character.class)) {
                    field.set(obj, this.getAttribute(input, fieldName, (Character)null));
                    break block33;
                }
                if (Number.class.isAssignableFrom(fieldType)) {
                    XMLNumberFormat<?> format = ReflectionFormat.getNumberFormat(fieldType);
                    field.set(obj, format.newInstanceFromAttribute(input, fieldName));
                    break block33;
                }
                if (fieldType == Currency.class) {
                    field.set(obj, Currency.getInstance(object.toString()));
                    break block33;
                }
                throw new IllegalArgumentException("Not yet supported as attribute: " + fieldType);
            }
            catch (Exception e) {
                try {
                    LOG.error((Object)("Caught exception when trying to set field (" + field + ") from attribute (" + input.getAttribute(field.getName()) + ")."), (Throwable)e);
                }
                catch (XMLStreamException xMLStreamException) {
                    // empty catch block
                }
            }
        }
    }

    private String getAttribute(XMLFormat.InputElement input, String name, String defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? value.toString() : defaultValue;
    }

    private Boolean getAttribute(XMLFormat.InputElement input, String name, Boolean defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Boolean.valueOf(value.toBoolean()) : defaultValue;
    }

    private Integer getAttribute(XMLFormat.InputElement input, String name, Integer defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Integer.valueOf(value.toInt()) : defaultValue;
    }

    private Long getAttribute(XMLFormat.InputElement input, String name, Long defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Long.valueOf(value.toLong()) : defaultValue;
    }

    private Short getAttribute(XMLFormat.InputElement input, String name, Short defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Short.valueOf(TypeFormat.parseShort((CharSequence)value)) : defaultValue;
    }

    private Float getAttribute(XMLFormat.InputElement input, String name, Float defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Float.valueOf(value.toFloat()) : defaultValue;
    }

    private Double getAttribute(XMLFormat.InputElement input, String name, Double defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Double.valueOf(value.toDouble()) : defaultValue;
    }

    private Byte getAttribute(XMLFormat.InputElement input, String name, Byte defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        return value != null ? Byte.valueOf(TypeFormat.parseByte((CharSequence)value)) : defaultValue;
    }

    private Character getAttribute(XMLFormat.InputElement input, String name, Character defaultValue) throws XMLStreamException {
        CharArray value = input.getAttribute(name);
        if (value != null) {
            if (value.length() > 1) {
                throw new XMLStreamException("The attribute '" + name + "' of type Character has illegal value (length > 1): " + value);
            }
            return Character.valueOf(value.charAt(0));
        }
        return defaultValue;
    }

    static boolean isNumberFormat(Class<?> clazz) {
        return Number.class.isAssignableFrom(clazz);
    }

    static XMLNumberFormat<?> getNumberFormat(Class<? extends Number> clazz) {
        XMLNumberFormat<Object> result = NUMBER_FORMATS.get(clazz);
        if (result == null) {
            result = ReflectionFormat.createNumberFormat(clazz);
            NUMBER_FORMATS.put(clazz, result);
        }
        return result;
    }

    static <T extends Number> XMLNumberFormat<T> createNumberFormat(Class<T> clazz) {
        try {
            for (Constructor<?> constructor : clazz.getConstructors()) {
                Class<?>[] parameterTypes = constructor.getParameterTypes();
                if (parameterTypes.length != 1) continue;
                if (parameterTypes[0] == Long.TYPE) {
                    return new XMLNumberLongFormat(constructor);
                }
                if (parameterTypes[0] != Integer.TYPE) continue;
                return new XMLNumberIntFormat(constructor);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        throw new IllegalArgumentException("No suitable constructor found for class " + clazz.getName() + ".\nAvailable constructors: " + Arrays.toString(clazz.getConstructors()));
    }

    static class XMLNumberLongFormat<T extends Number>
    extends XMLNumberFormat<T> {
        public XMLNumberLongFormat(Constructor<T> constructor) {
            super(constructor);
        }

        @Override
        public Object getAttribute(String name, XMLFormat.InputElement xml) throws XMLStreamException {
            return xml.getAttribute(name, 0L);
        }
    }

    static class XMLNumberIntFormat<T extends Number>
    extends XMLNumberFormat<T> {
        public XMLNumberIntFormat(Constructor<T> constructor) {
            super(constructor);
        }

        @Override
        public Object getAttribute(String name, XMLFormat.InputElement xml) throws XMLStreamException {
            return xml.getAttribute(name, 0);
        }
    }

    static abstract class XMLNumberFormat<T extends Number>
    extends XMLFormat<T> {
        private final Constructor<T> _constructor;

        public XMLNumberFormat(Constructor<T> constructor) {
            super(null);
            this._constructor = constructor;
        }

        public T newInstance(Class<T> clazz, XMLFormat.InputElement xml) throws XMLStreamException {
            return this.newInstanceFromAttribute(xml, "value");
        }

        public T newInstanceFromAttribute(XMLFormat.InputElement xml, String name) throws XMLStreamException {
            Object value = this.getAttribute(name, xml);
            try {
                return (T)((Number)this._constructor.newInstance(value));
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        protected abstract Object getAttribute(String var1, XMLFormat.InputElement var2) throws XMLStreamException;

        public void read(XMLFormat.InputElement xml, T obj) throws XMLStreamException {
        }

        public void write(T obj, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute("value", ((Number)obj).longValue());
        }
    }

    static final class EnumAttributeHandler
    extends ObjectAttributeHandler {
        public EnumAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void add(Object object, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute(this._field.getName(), ((Enum)object).name());
        }
    }

    static final class ToStringAttributeHandler
    extends ObjectAttributeHandler {
        public ToStringAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void add(Object object, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute(this._field.getName(), object.toString());
        }
    }

    static abstract class ObjectAttributeHandler
    extends AttributeHandler {
        public ObjectAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            Object object = this._field.get(obj);
            if (object != null) {
                this.add(object, output);
            }
        }

        abstract void add(Object var1, XMLFormat.OutputElement var2) throws XMLStreamException;
    }

    static final class ShortAttributeHandler
    extends AttributeHandler {
        public ShortAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getShort(obj));
        }
    }

    static final class CharAttributeHandler
    extends AttributeHandler {
        public CharAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getChar(obj));
        }
    }

    static final class ByteAttributeHandler
    extends AttributeHandler {
        public ByteAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getByte(obj));
        }
    }

    static final class DoubleAttributeHandler
    extends AttributeHandler {
        public DoubleAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getDouble(obj));
        }
    }

    static final class FloatAttributeHandler
    extends AttributeHandler {
        public FloatAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getFloat(obj));
        }
    }

    static final class LongAttributeHandler
    extends AttributeHandler {
        public LongAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getLong(obj));
        }
    }

    static final class IntAttributeHandler
    extends AttributeHandler {
        public IntAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getInt(obj));
        }
    }

    static final class BooleanAttributeHandler
    extends AttributeHandler {
        public BooleanAttributeHandler(Field field) {
            super(field);
        }

        @Override
        void writeAttribute(Object obj, XMLFormat.OutputElement output) throws IllegalArgumentException, XMLStreamException, IllegalAccessException {
            output.setAttribute(this._field.getName(), this._field.getBoolean(obj));
        }
    }

    static abstract class AttributeHandler {
        protected final Field _field;

        public AttributeHandler(Field field) {
            this._field = field;
        }

        abstract void writeAttribute(Object var1, XMLFormat.OutputElement var2) throws IllegalArgumentException, XMLStreamException, IllegalAccessException;
    }

    static class AttributesAndElements {
        private final Collection<AttributeHandler> attributes = new ArrayList<AttributeHandler>();
        private final Collection<Field> elements = new ArrayList<Field>();

        AttributesAndElements() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void add(Field field) {
            if (ReflectionFormat.isAttribute(field)) {
                Class<?> fieldType = field.getType();
                if (fieldType.isPrimitive()) {
                    if (fieldType == Boolean.TYPE) {
                        this.attributes.add(new BooleanAttributeHandler(field));
                        return;
                    } else if (fieldType == Integer.TYPE) {
                        this.attributes.add(new IntAttributeHandler(field));
                        return;
                    } else if (fieldType == Long.TYPE) {
                        this.attributes.add(new LongAttributeHandler(field));
                        return;
                    } else if (fieldType == Float.TYPE) {
                        this.attributes.add(new FloatAttributeHandler(field));
                        return;
                    } else if (fieldType == Double.TYPE) {
                        this.attributes.add(new DoubleAttributeHandler(field));
                        return;
                    } else if (fieldType == Byte.TYPE) {
                        this.attributes.add(new ByteAttributeHandler(field));
                        return;
                    } else if (fieldType == Character.TYPE) {
                        this.attributes.add(new CharAttributeHandler(field));
                        return;
                    } else {
                        if (fieldType != Short.TYPE) return;
                        this.attributes.add(new ShortAttributeHandler(field));
                    }
                    return;
                } else if (fieldType == String.class || fieldType == Character.class || fieldType == Boolean.class || Number.class.isAssignableFrom(fieldType) || fieldType == Currency.class) {
                    this.attributes.add(new ToStringAttributeHandler(field));
                    return;
                } else {
                    if (!fieldType.isEnum()) throw new IllegalArgumentException("Not yet supported as attribute: " + fieldType);
                    this.attributes.add(new EnumAttributeHandler(field));
                }
                return;
            } else {
                this.elements.add(field);
            }
        }
    }
}

