/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import de.javakaffee.web.msm.serializer.javolution.CustomXMLFormat;
import javolution.text.CharArray;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.chrono.BuddhistChronology;
import org.joda.time.chrono.CopticChronology;
import org.joda.time.chrono.EthiopicChronology;
import org.joda.time.chrono.GJChronology;
import org.joda.time.chrono.GregorianChronology;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.chrono.IslamicChronology;
import org.joda.time.chrono.JulianChronology;

public class JodaDateTimeFormat
extends CustomXMLFormat<DateTime> {
    static final String MILLIS = "millis";
    static final String DATE_TIME = "dt";
    static final String CHRONOLOGY = "ch";
    static final String TIME_ZONE = "tz";

    @Override
    public boolean canConvert(Class<?> cls) {
        return cls == DateTime.class;
    }

    public DateTime newInstance(Class<DateTime> cls, XMLFormat.InputElement input) throws XMLStreamException {
        long millis = input.getAttribute(MILLIS).toLong();
        Chronology chronology = this.readChronology(input);
        DateTimeZone tz = this.readTimeZone(input);
        return new DateTime(millis, chronology.withZone(tz));
    }

    private Chronology readChronology(XMLFormat.InputElement input) throws XMLStreamException {
        CharArray chronologyId = input.getAttribute(CHRONOLOGY);
        return IdentifiableChronology.valueOfId(chronologyId != null ? chronologyId.toString() : null);
    }

    private DateTimeZone readTimeZone(XMLFormat.InputElement input) throws XMLStreamException {
        CharArray tz = input.getAttribute(TIME_ZONE);
        return tz != null ? DateTimeZone.forID((String)tz.toString()) : DateTimeZone.getDefault();
    }

    public void read(XMLFormat.InputElement input, DateTime obj) throws XMLStreamException {
    }

    public void write(DateTime obj, XMLFormat.OutputElement output) throws XMLStreamException {
        output.setAttribute(MILLIS, obj.getMillis());
        String chronologyId = this.getChronologyId(obj.getChronology());
        if (chronologyId != null) {
            output.setAttribute(CHRONOLOGY, chronologyId);
        }
        if (obj.getZone() != null && obj.getZone() != DateTimeZone.getDefault()) {
            output.setAttribute(TIME_ZONE, obj.getZone().getID());
        }
    }

    private String getChronologyId(Chronology chronology) {
        return IdentifiableChronology.getIdByChronology(chronology.getClass());
    }

    static enum IdentifiableChronology {
        ISO(null, (Chronology)ISOChronology.getInstance()),
        COPTIC("COPTIC", (Chronology)CopticChronology.getInstance()),
        ETHIOPIC("ETHIOPIC", (Chronology)EthiopicChronology.getInstance()),
        GREGORIAN("GREGORIAN", (Chronology)GregorianChronology.getInstance()),
        JULIAN("JULIAN", (Chronology)JulianChronology.getInstance()),
        ISLAMIC("ISLAMIC", (Chronology)IslamicChronology.getInstance()),
        BUDDHIST("BUDDHIST", (Chronology)BuddhistChronology.getInstance()),
        GJ("GJ", (Chronology)GJChronology.getInstance());

        private final String _id;
        private final Chronology _chronology;

        private IdentifiableChronology(String id, Chronology chronology) {
            this._id = id;
            this._chronology = chronology;
        }

        public String getId() {
            return this._id;
        }

        public static String getIdByChronology(Class<? extends Chronology> clazz) throws IllegalArgumentException {
            for (IdentifiableChronology item : IdentifiableChronology.values()) {
                if (!clazz.equals(item._chronology.getClass())) continue;
                return item._id;
            }
            throw new IllegalArgumentException("Chronology not supported: " + clazz.getSimpleName());
        }

        public static Chronology valueOfId(String id) throws IllegalArgumentException {
            if (id == null) {
                return IdentifiableChronology.ISO._chronology;
            }
            for (IdentifiableChronology item : IdentifiableChronology.values()) {
                if (!id.equals(item._id)) continue;
                return item._chronology;
            }
            throw new IllegalArgumentException("No chronology found for id " + id);
        }
    }
}

