/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.javolution;

import java.lang.reflect.Array;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class XMLArrayFormats {
    static final XMLFormat<byte[]> BYTE_ARRAY_FORMAT = new XMLFormat<byte[]>(byte[].class){

        public byte[] newInstance(Class<byte[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (byte[])Array.newInstance(Byte.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, byte[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = (Byte)input.getNext();
            }
        }

        public final void write(byte[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (byte item : array) {
                output.add((Object)item);
            }
        }
    };
    static final XMLFormat<char[]> CHAR_ARRAY_FORMAT = new XMLFormat<char[]>(char[].class){

        public char[] newInstance(Class<char[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (char[])Array.newInstance(Character.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, char[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = ((Character)input.getNext()).charValue();
            }
        }

        public final void write(char[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (char item : array) {
                output.add((Object)Character.valueOf(item));
            }
        }
    };
    static final XMLFormat<short[]> SHORT_ARRAY_FORMAT = new XMLFormat<short[]>(short[].class){

        public short[] newInstance(Class<short[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (short[])Array.newInstance(Short.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, short[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = (Short)input.getNext();
            }
        }

        public final void write(short[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (short item : array) {
                output.add((Object)item);
            }
        }
    };
    static final XMLFormat<int[]> INT_ARRAY_FORMAT = new XMLFormat<int[]>(int[].class){

        public int[] newInstance(Class<int[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (int[])Array.newInstance(Integer.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, int[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = (Integer)input.getNext();
            }
        }

        public final void write(int[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (int item : array) {
                output.add((Object)item);
            }
        }
    };
    static final XMLFormat<long[]> LONG_ARRAY_FORMAT = new XMLFormat<long[]>(long[].class){

        public long[] newInstance(Class<long[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (long[])Array.newInstance(Long.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, long[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = (Long)input.getNext();
            }
        }

        public final void write(long[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (long item : array) {
                output.add((Object)item);
            }
        }
    };
    static final XMLFormat<float[]> FLOAT_ARRAY_FORMAT = new XMLFormat<float[]>(float[].class){

        public float[] newInstance(Class<float[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (float[])Array.newInstance(Float.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, float[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = ((Float)input.getNext()).floatValue();
            }
        }

        public final void write(float[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (float item : array) {
                output.add((Object)Float.valueOf(item));
            }
        }
    };
    static final XMLFormat<double[]> DOUBLE_ARRAY_FORMAT = new XMLFormat<double[]>(double[].class){

        public double[] newInstance(Class<double[]> clazz, XMLFormat.InputElement input) throws XMLStreamException {
            try {
                int length = input.getAttribute("length", 0);
                return (double[])Array.newInstance(Double.TYPE, length);
            }
            catch (Exception e) {
                throw new XMLStreamException((Throwable)e);
            }
        }

        public void read(XMLFormat.InputElement input, double[] array) throws XMLStreamException {
            int i = 0;
            while (input.hasNext()) {
                array[i++] = (Double)input.getNext();
            }
        }

        public final void write(double[] array, XMLFormat.OutputElement output) throws XMLStreamException {
            output.setAttribute("length", array.length);
            for (double item : array) {
                output.add((Object)item);
            }
        }
    };
}

