/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.serializer.json;

import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import de.javakaffee.web.msm.TranscoderDeserializationException;
import flexjson.JSONDeserializer;
import flexjson.JSONSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import org.apache.catalina.Manager;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class JSONTranscoder
implements SessionAttributesTranscoder {
    private static final Log LOG = LogFactory.getLog(JSONTranscoder.class);
    private final JSONSerializer serializer = new JSONSerializer();

    public JSONTranscoder(Manager manager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Initialized json serializer");
        }
    }

    public Map<String, Object> deserializeAttributes(byte[] in) {
        InputStreamReader inputStream = new InputStreamReader(new ByteArrayInputStream(in));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"deserialize the stream");
        }
        try {
            Map result = (Map)new JSONDeserializer().deserialize((Reader)inputStream);
            return result;
        }
        catch (RuntimeException e) {
            LOG.warn((Object)("Caught Exception deserializing JSON " + e));
            throw new TranscoderDeserializationException((Throwable)e);
        }
    }

    public byte[] serializeAttributes(MemcachedBackupSession sessions, Map<String, Object> attributes) {
        if (attributes == null) {
            throw new NullPointerException();
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            String serResult = this.serializer.deepSerialize(attributes);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("JSON Serialised object: " + serResult));
            }
            byte[] byArray = serResult.getBytes();
            return byArray;
        }
        catch (Exception e) {
            LOG.warn((Object)("Caught Exception deserializing JSON " + e));
            throw new IllegalArgumentException();
        }
        finally {
            this.close(bos);
        }
    }

    private void close(Closeable stream) {
        if (stream != null) {
            try {
                stream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("JSON Transcoder Failed to close the stream: " + e));
            }
        }
    }
}

