/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;

public class Statistics {
    private final AtomicLong _numRequestsWithoutSession = new AtomicLong();
    private final AtomicLong _numRequestsWithTomcatFailover = new AtomicLong();
    private final AtomicLong _numRequestsWithSession = new AtomicLong();
    private final AtomicLong _numRequestsWithMemcachedFailover = new AtomicLong();
    private final AtomicLong _numRequestsWithBackupFailure = new AtomicLong();
    private final AtomicLong _numRequestsWithoutSessionAccess = new AtomicLong();
    private final AtomicLong _numRequestsWithoutAttributesAccess = new AtomicLong();
    private final AtomicLong _numRequestsWithoutSessionModification = new AtomicLong();
    private final AtomicLong _numNonStickySessionsPingFailed = new AtomicLong();
    private final AtomicLong _numNonStickySessionsReadOnlyRequest = new AtomicLong();
    private final Map<StatsType, MinMaxAvgProbe> _probes = new ConcurrentHashMap<StatsType, MinMaxAvgProbe>();
    private static final Statistics DISABLED_STATS = new Statistics(){

        @Override
        public void registerSince(StatsType statsType, long startInMillis) {
        }

        @Override
        public void register(StatsType statsType, long startInMillis) {
        }

        @Override
        public MinMaxAvgProbe getProbe(@Nonnull StatsType statsType) {
            return new MinMaxAvgProbe();
        }

        @Override
        public void requestWithBackupFailure() {
        }

        @Override
        public void requestWithoutSession() {
        }

        @Override
        public void requestWithoutSessionAccess() {
        }

        @Override
        public void requestWithoutSessionModification() {
        }

        @Override
        public void requestWithSession() {
        }

        @Override
        public void requestWithMemcachedFailover() {
        }

        @Override
        public void requestWithTomcatFailover() {
        }

        @Override
        public void nonStickySessionsPingFailed() {
        }

        @Override
        public void nonStickySessionsReadOnlyRequest() {
        }

        @Override
        public void requestWithoutAttributesAccess() {
        }
    };

    private Statistics() {
        for (StatsType item : StatsType.values()) {
            this._probes.put(item, new MinMaxAvgProbe());
        }
    }

    public static Statistics create() {
        return Statistics.create(true);
    }

    public static Statistics create(boolean enabled) {
        return enabled ? new Statistics() : DISABLED_STATS;
    }

    public void registerSince(@Nonnull StatsType statsType, long startInMillis) {
        this.register(statsType, System.currentTimeMillis() - startInMillis);
    }

    public void register(@Nonnull StatsType statsType, long value) {
        this._probes.get((Object)statsType).register(value);
    }

    @Nonnull
    public MinMaxAvgProbe getProbe(@Nonnull StatsType statsType) {
        return this._probes.get((Object)statsType);
    }

    public void requestWithoutSession() {
        this._numRequestsWithoutSession.incrementAndGet();
    }

    public long getRequestsWithoutSession() {
        return this._numRequestsWithoutSession.get();
    }

    public void requestWithSession() {
        this._numRequestsWithSession.incrementAndGet();
    }

    public long getRequestsWithSession() {
        return this._numRequestsWithSession.get();
    }

    public void requestWithTomcatFailover() {
        this._numRequestsWithTomcatFailover.incrementAndGet();
    }

    public long getRequestsWithTomcatFailover() {
        return this._numRequestsWithTomcatFailover.get();
    }

    public void requestWithMemcachedFailover() {
        this._numRequestsWithMemcachedFailover.incrementAndGet();
    }

    public long getRequestsWithMemcachedFailover() {
        return this._numRequestsWithMemcachedFailover.get();
    }

    public void requestWithBackupFailure() {
        this._numRequestsWithBackupFailure.incrementAndGet();
    }

    public long getRequestsWithBackupFailure() {
        return this._numRequestsWithBackupFailure.get();
    }

    public void requestWithoutSessionAccess() {
        this._numRequestsWithoutSessionAccess.incrementAndGet();
    }

    public long getRequestsWithoutSessionAccess() {
        return this._numRequestsWithoutSessionAccess.get();
    }

    public void requestWithoutAttributesAccess() {
        this._numRequestsWithoutAttributesAccess.incrementAndGet();
    }

    public long getRequestsWithoutAttributesAccess() {
        return this._numRequestsWithoutAttributesAccess.get();
    }

    public void requestWithoutSessionModification() {
        this._numRequestsWithoutSessionModification.incrementAndGet();
    }

    public long getRequestsWithoutSessionModification() {
        return this._numRequestsWithoutSessionModification.get();
    }

    public void nonStickySessionsPingFailed() {
        this._numNonStickySessionsPingFailed.incrementAndGet();
    }

    public long getNonStickySessionsPingFailed() {
        return this._numNonStickySessionsPingFailed.get();
    }

    public void nonStickySessionsReadOnlyRequest() {
        this._numNonStickySessionsReadOnlyRequest.incrementAndGet();
    }

    public long getNonStickySessionsReadOnlyRequest() {
        return this._numNonStickySessionsReadOnlyRequest.get();
    }

    public static class MinMaxAvgProbe {
        private boolean _first = true;
        private final AtomicInteger _count = new AtomicInteger();
        private long _min;
        private long _max;
        private double _avg;

        public void registerSince(long startInMillis) {
            this.register(System.currentTimeMillis() - startInMillis);
        }

        public void register(long value) {
            if (value < this._min || this._first) {
                this._min = value;
            }
            if (value > this._max || this._first) {
                this._max = value;
            }
            this._avg = (this._avg * (double)this._count.get() + (double)value) / (double)this._count.incrementAndGet();
            this._first = false;
        }

        int getCount() {
            return this._count.get();
        }

        long getMin() {
            return this._min;
        }

        long getMax() {
            return this._max;
        }

        double getAvg() {
            return this._avg;
        }

        public String[] getInfo() {
            return new String[]{"Count = " + this._count.get(), "Min = " + this._min, "Avg = " + this._avg, "Max = " + this._max};
        }
    }

    public static enum StatsType {
        EFFECTIVE_BACKUP,
        BACKUP,
        ATTRIBUTES_SERIALIZATION,
        SESSION_DESERIALIZATION,
        MEMCACHED_UPDATE,
        LOAD_FROM_MEMCACHED,
        DELETE_FROM_MEMCACHED,
        CACHED_DATA_SIZE,
        ACQUIRE_LOCK,
        ACQUIRE_LOCK_FAILURE,
        RELEASE_LOCK,
        NON_STICKY_ON_BACKUP_WITHOUT_LOADED_SESSION,
        NON_STICKY_AFTER_BACKUP,
        NON_STICKY_AFTER_LOAD_FROM_MEMCACHED,
        NON_STICKY_AFTER_DELETE_FROM_MEMCACHED;

    }
}

