/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupResultStatus;
import de.javakaffee.web.msm.BackupSessionService;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.CurrentRequest;
import de.javakaffee.web.msm.LRUCache;
import de.javakaffee.web.msm.LockingStrategyAll;
import de.javakaffee.web.msm.LockingStrategyAuto;
import de.javakaffee.web.msm.LockingStrategyNone;
import de.javakaffee.web.msm.LockingStrategyUriPattern;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.MemcachedUtil;
import de.javakaffee.web.msm.NamedThreadFactory;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.SessionValidityInfo;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.StorageKeyFormat;
import de.javakaffee.web.msm.storage.StorageClient;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public abstract class LockingStrategy {
    protected static final byte[] LOCK_VALUE = new byte[]{108, 111, 99, 107, 101, 100};
    protected static final byte[] BYTE_1 = new byte[]{1};
    protected static final int LOCK_RETRY_INTERVAL = 10;
    protected static final int LOCK_MAX_RETRY_INTERVAL = 500;
    protected final Log _log = LogFactory.getLog(this.getClass());
    protected MemcachedSessionService _manager;
    protected final StorageClient _storage;
    protected LRUCache<String, Boolean> _missingSessionsCache;
    protected final SessionIdFormat _sessionIdFormat;
    private final ExecutorService _executor;
    private final boolean _storeSecondaryBackup;
    protected final Statistics _stats;
    protected final CurrentRequest _currentRequest;
    protected final StorageKeyFormat _storageKeyFormat;

    protected LockingStrategy(@Nonnull MemcachedSessionService manager, @Nonnull MemcachedNodesManager memcachedNodesManager, @Nonnull StorageClient storage, @Nonnull LRUCache<String, Boolean> missingSessionsCache, boolean storeSecondaryBackup, @Nonnull Statistics stats, @Nonnull CurrentRequest currentRequest) {
        this._manager = manager;
        this._storage = storage;
        this._missingSessionsCache = missingSessionsCache;
        this._sessionIdFormat = memcachedNodesManager.getSessionIdFormat();
        this._storeSecondaryBackup = storeSecondaryBackup;
        this._stats = stats;
        this._currentRequest = currentRequest;
        this._storageKeyFormat = memcachedNodesManager.getStorageKeyFormat();
        this._executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors(), new NamedThreadFactory("msm-2ndary-backup"));
    }

    @CheckForNull
    public static LockingStrategy create(@Nullable LockingMode lockingMode, @Nullable Pattern uriPattern, @Nonnull StorageClient storage, @Nonnull MemcachedSessionService manager, @Nonnull MemcachedNodesManager memcachedNodesManager, @Nonnull LRUCache<String, Boolean> missingSessionsCache, boolean storeSecondaryBackup, @Nonnull Statistics stats, @Nonnull CurrentRequest currentRequest) {
        if (lockingMode == null) {
            return null;
        }
        switch (lockingMode) {
            case ALL: {
                return new LockingStrategyAll(manager, memcachedNodesManager, storage, missingSessionsCache, storeSecondaryBackup, stats, currentRequest);
            }
            case AUTO: {
                return new LockingStrategyAuto(manager, memcachedNodesManager, storage, missingSessionsCache, storeSecondaryBackup, stats, currentRequest);
            }
            case URI_PATTERN: {
                return new LockingStrategyUriPattern(manager, memcachedNodesManager, uriPattern, storage, missingSessionsCache, storeSecondaryBackup, stats, currentRequest);
            }
            case NONE: {
                return new LockingStrategyNone(manager, memcachedNodesManager, storage, missingSessionsCache, storeSecondaryBackup, stats, currentRequest);
            }
        }
        throw new IllegalArgumentException("LockingMode not yet supported: " + (Object)((Object)lockingMode));
    }

    public void shutdown() {
        this._executor.shutdown();
    }

    protected MemcachedSessionService.LockStatus lock(String sessionId) {
        return this.lock(sessionId, this._manager.getOperationTimeout(), TimeUnit.MILLISECONDS);
    }

    protected MemcachedSessionService.LockStatus lock(String sessionId, long timeout, TimeUnit timeUnit) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Locking session " + sessionId));
        }
        long start = System.currentTimeMillis();
        try {
            this.acquireLock(sessionId, 10L, 500L, timeUnit.toMillis(timeout), System.currentTimeMillis());
            this._stats.registerSince(Statistics.StatsType.ACQUIRE_LOCK, start);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Locked session " + sessionId));
            }
            return MemcachedSessionService.LockStatus.LOCKED;
        }
        catch (TimeoutException e) {
            this._log.warn((Object)("Reached timeout when trying to aquire lock for session " + sessionId + ". Will use this session without this lock."));
            this._stats.registerSince(Statistics.StatsType.ACQUIRE_LOCK_FAILURE, start);
            return MemcachedSessionService.LockStatus.COULD_NOT_AQUIRE_LOCK;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Got interrupted while trying to lock session.", e);
        }
        catch (ExecutionException e) {
            this._log.warn((Object)("An exception occurred when trying to aquire lock for session " + sessionId));
            this._stats.registerSince(Statistics.StatsType.ACQUIRE_LOCK_FAILURE, start);
            return MemcachedSessionService.LockStatus.COULD_NOT_AQUIRE_LOCK;
        }
    }

    protected void acquireLock(@Nonnull String sessionId, long retryInterval, long maxRetryInterval, long timeout, long start) throws InterruptedException, ExecutionException, TimeoutException {
        Future<Boolean> result = this._storage.add(this._sessionIdFormat.createLockName(sessionId), 5, LOCK_VALUE);
        if (result.get().booleanValue()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Locked session " + sessionId));
            }
            return;
        }
        this.checkTimeoutAndWait(sessionId, retryInterval, timeout, start);
        this.acquireLock(sessionId, Math.min(retryInterval * 2L, maxRetryInterval), maxRetryInterval, timeout, start);
    }

    protected void checkTimeoutAndWait(@Nonnull String sessionId, long timeToWait, long timeout, long start) throws TimeoutException, InterruptedException {
        if (System.currentTimeMillis() >= start + timeout) {
            throw new TimeoutException("Reached timeout when trying to aquire lock for session " + sessionId);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Could not aquire lock for session " + sessionId + ", waiting " + timeToWait + " millis now..."));
        }
        Thread.sleep(timeToWait);
    }

    protected void releaseLock(@Nonnull String sessionId) {
        try {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Releasing lock for session " + sessionId));
            }
            long start = System.currentTimeMillis();
            this._storage.delete(this._sessionIdFormat.createLockName(sessionId)).get();
            this._stats.registerSince(Statistics.StatsType.RELEASE_LOCK, start);
        }
        catch (Exception e) {
            this._log.warn((Object)("Caught exception when trying to release lock for session " + sessionId), (Throwable)e);
        }
    }

    public void registerReadonlyRequest(String requestId) {
    }

    protected void onBackupWithoutLoadedSession(@Nonnull String sessionId, @Nonnull String requestId, @Nonnull BackupSessionService backupSessionService) {
        if (!this._sessionIdFormat.isValid(sessionId)) {
            return;
        }
        try {
            long start = System.currentTimeMillis();
            String validityKey = this._sessionIdFormat.createValidityInfoKeyName(sessionId);
            SessionValidityInfo validityInfo = this.loadSessionValidityInfoForValidityKey(validityKey);
            if (validityInfo == null) {
                this._log.warn((Object)("Found no validity info for session id " + sessionId));
                return;
            }
            int maxInactiveInterval = validityInfo.getMaxInactiveInterval();
            byte[] validityData = SessionValidityInfo.encode(maxInactiveInterval, System.currentTimeMillis(), System.currentTimeMillis());
            int expiration = maxInactiveInterval <= 0 ? 0 : maxInactiveInterval;
            Future<Boolean> validityResult = this._storage.set(validityKey, MemcachedUtil.toMemcachedExpiration(expiration), validityData);
            if (!this._manager.isSessionBackupAsync()) {
                validityResult.get(this._manager.getSessionBackupTimeout(), TimeUnit.MILLISECONDS);
            }
            OnBackupWithoutLoadedSessionTask backupSessionTask = new OnBackupWithoutLoadedSessionTask(sessionId, this._storeSecondaryBackup, validityKey, validityData, maxInactiveInterval);
            this._executor.submit(backupSessionTask);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Stored session validity info for session " + sessionId));
            }
            this._stats.registerSince(Statistics.StatsType.NON_STICKY_ON_BACKUP_WITHOUT_LOADED_SESSION, start);
        }
        catch (Throwable e) {
            this._log.warn((Object)"An error when trying to load/update validity info.", e);
        }
    }

    protected void onAfterBackupSession(@Nonnull MemcachedBackupSession session, boolean backupWasForced, @Nonnull Future<BackupSessionTask.BackupResult> result, @Nonnull String requestId, @Nonnull BackupSessionService backupSessionService) {
        if (!this._sessionIdFormat.isValid(session.getIdInternal())) {
            return;
        }
        try {
            boolean performAsyncTasks;
            long start = System.currentTimeMillis();
            int maxInactiveInterval = session.getMaxInactiveInterval();
            byte[] validityData = SessionValidityInfo.encode(maxInactiveInterval, session.getLastAccessedTimeInternal(), session.getThisAccessedTimeInternal());
            String validityKey = this._sessionIdFormat.createValidityInfoKeyName(session.getIdInternal());
            int expiration = maxInactiveInterval <= 0 ? 0 : maxInactiveInterval;
            Future<Boolean> validityResult = this._storage.set(validityKey, MemcachedUtil.toMemcachedExpiration(expiration), validityData);
            if (!this._manager.isSessionBackupAsync()) {
                validityResult.get(this._manager.getSessionBackupTimeout(), TimeUnit.MILLISECONDS);
            }
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Stored session validity info for session " + session.getIdInternal()));
            }
            boolean pingSessionIfBackupWasSkipped = !backupWasForced;
            boolean bl = performAsyncTasks = pingSessionIfBackupWasSkipped || this._storeSecondaryBackup;
            if (performAsyncTasks) {
                OnAfterBackupSessionTask backupSessionTask = new OnAfterBackupSessionTask(session, result, pingSessionIfBackupWasSkipped, backupSessionService, this._storeSecondaryBackup, validityKey, validityData);
                this._executor.submit(backupSessionTask);
            }
            this._stats.registerSince(Statistics.StatsType.NON_STICKY_AFTER_BACKUP, start);
        }
        catch (Throwable e) {
            this._log.warn((Object)"An error occurred during onAfterBackupSession.", e);
        }
    }

    @CheckForNull
    protected SessionValidityInfo loadSessionValidityInfo(@Nonnull String sessionId) {
        return this.loadSessionValidityInfoForValidityKey(this._sessionIdFormat.createValidityInfoKeyName(sessionId));
    }

    @CheckForNull
    protected SessionValidityInfo loadSessionValidityInfoForValidityKey(@Nonnull String validityInfoKey) {
        byte[] validityInfo = this._storage.get(validityInfoKey);
        return validityInfo != null ? SessionValidityInfo.decode(validityInfo) : null;
    }

    @CheckForNull
    protected SessionValidityInfo loadBackupSessionValidityInfo(@Nonnull String sessionId) {
        String key = this._sessionIdFormat.createValidityInfoKeyName(sessionId);
        String backupKey = this._sessionIdFormat.createBackupKey(key);
        return this.loadSessionValidityInfoForValidityKey(backupKey);
    }

    @CheckForNull
    protected abstract MemcachedSessionService.LockStatus onBeforeLoadFromMemcached(@Nonnull String var1) throws InterruptedException, ExecutionException;

    protected void onAfterLoadFromMemcached(@Nonnull MemcachedBackupSession session, @Nullable MemcachedSessionService.LockStatus lockStatus) {
        session.setLockStatus(lockStatus);
        long start = System.currentTimeMillis();
        SessionValidityInfo info = this.loadSessionValidityInfo(session.getIdInternal());
        if (info != null) {
            this._stats.registerSince(Statistics.StatsType.NON_STICKY_AFTER_LOAD_FROM_MEMCACHED, start);
            session.setLastAccessedTimeInternal(info.getLastAccessedTime());
            session.setThisAccessedTimeInternal(info.getThisAccessedTime());
        } else {
            this._log.warn((Object)("No validity info available for session " + session.getIdInternal()));
        }
    }

    protected void onAfterDeleteFromMemcached(@Nonnull String sessionId) {
        long start = System.currentTimeMillis();
        String validityInfoKey = this._sessionIdFormat.createValidityInfoKeyName(sessionId);
        this._storage.delete(validityInfoKey);
        if (this._storeSecondaryBackup) {
            this._storage.delete(this._sessionIdFormat.createBackupKey(sessionId));
            this._storage.delete(this._sessionIdFormat.createBackupKey(validityInfoKey));
        }
        this._stats.registerSince(Statistics.StatsType.NON_STICKY_AFTER_DELETE_FROM_MEMCACHED, start);
    }

    private boolean pingSession(@Nonnull String sessionId) throws InterruptedException {
        Future<Boolean> touchResult = this._storage.add(this._storageKeyFormat.format(sessionId), 1, BYTE_1);
        try {
            if (touchResult.get().booleanValue()) {
                this._stats.nonStickySessionsPingFailed();
                this._log.warn((Object)("The session " + sessionId + " should be touched in memcached, but it does not exist therein."));
                return false;
            }
            this._log.debug((Object)"The session was ping'ed successfully.");
            return true;
        }
        catch (ExecutionException e) {
            this._log.warn((Object)("An exception occurred when trying to ping session " + sessionId), (Throwable)e);
            return false;
        }
    }

    private void pingSession(@Nonnull MemcachedBackupSession session, @Nonnull BackupSessionService backupSessionService) throws InterruptedException {
        Future<Boolean> touchResult = this._storage.add(this._storageKeyFormat.format(session.getIdInternal()), 5, BYTE_1);
        try {
            if (touchResult.get().booleanValue()) {
                this._stats.nonStickySessionsPingFailed();
                this._log.warn((Object)("The session " + session.getIdInternal() + " should be touched in memcached, but it does not exist therein. Will store in memcached again."));
                this.updateSession(session, backupSessionService);
            } else {
                this._log.debug((Object)"The session was ping'ed successfully.");
            }
        }
        catch (ExecutionException e) {
            this._log.warn((Object)("An exception occurred when trying to ping session " + session.getIdInternal()), (Throwable)e);
        }
    }

    private void updateSession(@Nonnull MemcachedBackupSession session, @Nonnull BackupSessionService backupSessionService) throws InterruptedException {
        Future<BackupSessionTask.BackupResult> result = backupSessionService.backupSession(session, true);
        try {
            if (result.get().getStatus() != BackupResultStatus.SUCCESS) {
                this._log.warn((Object)("Update for session (after unsuccessful ping) did not return SUCCESS, but " + result.get()));
            }
        }
        catch (ExecutionException e) {
            this._log.warn((Object)("An exception occurred when trying to update session " + session.getIdInternal()), (Throwable)e);
        }
    }

    @Nonnull
    ExecutorService getExecutorService() {
        return this._executor;
    }

    private final class OnBackupWithoutLoadedSessionTask
    implements Callable<Void> {
        private final String _sessionId;
        private final boolean _storeSecondaryBackup;
        private final String _validityKey;
        private final byte[] _validityData;
        private final int _maxInactiveInterval;

        private OnBackupWithoutLoadedSessionTask(String sessionId, @Nonnull boolean storeSecondaryBackup, @Nonnull String validityKey, byte[] validityData, int maxInactiveInterval) {
            this._sessionId = sessionId;
            this._storeSecondaryBackup = storeSecondaryBackup;
            this._validityKey = validityKey;
            this._validityData = validityData;
            this._maxInactiveInterval = maxInactiveInterval;
        }

        @Override
        public Void call() throws Exception {
            LockingStrategy.this.pingSession(this._sessionId);
            if (this._storeSecondaryBackup) {
                try {
                    this.pingSessionBackup(this._sessionId);
                    String backupValidityKey = LockingStrategy.this._sessionIdFormat.createBackupKey(this._validityKey);
                    int expiration = this._maxInactiveInterval <= 0 ? 0 : this._maxInactiveInterval;
                    LockingStrategy.this._storage.set(backupValidityKey, MemcachedUtil.toMemcachedExpiration(expiration), this._validityData);
                }
                catch (RuntimeException e) {
                    LockingStrategy.this._log.info((Object)("Could not store secondary backup of session " + this._sessionId), (Throwable)e);
                }
            }
            return null;
        }

        private boolean pingSessionBackup(@Nonnull String sessionId) throws InterruptedException {
            String key = LockingStrategy.this._sessionIdFormat.createBackupKey(sessionId);
            Future<Boolean> touchResultFuture = LockingStrategy.this._storage.add(key, 1, BYTE_1);
            try {
                boolean touchResult = touchResultFuture.get(200L, TimeUnit.MILLISECONDS);
                if (touchResult) {
                    LockingStrategy.this._log.warn((Object)("The secondary backup for session " + sessionId + " should be touched in memcached, but it seemed to be not existing."));
                    return false;
                }
                LockingStrategy.this._log.debug((Object)"The secondary session backup was ping'ed successfully.");
                return true;
            }
            catch (TimeoutException e) {
                LockingStrategy.this._log.warn((Object)("The secondary backup for session " + sessionId + " could not be completed within 200 millis, was cancelled now."));
                return false;
            }
            catch (ExecutionException e) {
                LockingStrategy.this._log.warn((Object)("An exception occurred when trying to ping session " + sessionId), (Throwable)e);
                return false;
            }
        }
    }

    private final class OnAfterBackupSessionTask
    implements Callable<Void> {
        private final MemcachedBackupSession _session;
        private final Future<BackupSessionTask.BackupResult> _result;
        private final boolean _pingSessionIfBackupWasSkipped;
        private final boolean _storeSecondaryBackup;
        private final BackupSessionService _backupSessionService;
        private final String _validityKey;
        private final byte[] _validityData;

        private OnAfterBackupSessionTask(@Nonnull MemcachedBackupSession session, Future<BackupSessionTask.BackupResult> result, @Nonnull boolean pingSessionIfBackupWasSkipped, BackupSessionService backupSessionService, @Nonnull boolean storeSecondaryBackup, @Nonnull String validityKey, byte[] validityData) {
            this._session = session;
            this._result = result;
            this._pingSessionIfBackupWasSkipped = pingSessionIfBackupWasSkipped;
            this._storeSecondaryBackup = storeSecondaryBackup;
            this._validityKey = validityKey;
            this._validityData = validityData;
            this._backupSessionService = backupSessionService;
        }

        @Override
        public Void call() throws Exception {
            BackupSessionTask.BackupResult backupResult = this._result.get();
            if (this._pingSessionIfBackupWasSkipped && backupResult.getStatus() == BackupResultStatus.SKIPPED) {
                LockingStrategy.this.pingSession(this._session, this._backupSessionService);
            }
            if (this._storeSecondaryBackup) {
                try {
                    if (LockingStrategy.this._log.isDebugEnabled()) {
                        LockingStrategy.this._log.debug((Object)("Storing backup in secondary memcached for non-sticky session " + this._session.getId()));
                    }
                    if (backupResult.getStatus() == BackupResultStatus.SKIPPED) {
                        this.pingSessionBackup(this._session);
                    } else {
                        this.saveSessionBackupFromResult(backupResult);
                    }
                    this.saveValidityBackup();
                }
                catch (RuntimeException e) {
                    LockingStrategy.this._log.info((Object)("Could not store secondary backup of session " + this._session.getIdInternal()), (Throwable)e);
                }
            }
            return null;
        }

        public void saveSessionBackupFromResult(BackupSessionTask.BackupResult backupResult) {
            byte[] data = backupResult.getData();
            if (data != null) {
                String key = LockingStrategy.this._sessionIdFormat.createBackupKey(this._session.getId());
                LockingStrategy.this._storage.set(key, MemcachedUtil.toMemcachedExpiration(this._session.getMemcachedExpirationTimeToSet()), data);
            } else {
                LockingStrategy.this._log.warn((Object)("No data set for backupResultStatus " + (Object)((Object)backupResult.getStatus()) + " for sessionId " + this._session.getIdInternal() + ", skipping backup of non-sticky session in secondary memcached."));
            }
        }

        public void saveValidityBackup() {
            String backupValidityKey = LockingStrategy.this._sessionIdFormat.createBackupKey(this._validityKey);
            int maxInactiveInterval = this._session.getMaxInactiveInterval();
            int expiration = maxInactiveInterval <= 0 ? 0 : maxInactiveInterval;
            LockingStrategy.this._storage.set(backupValidityKey, MemcachedUtil.toMemcachedExpiration(expiration), this._validityData);
        }

        private void pingSessionBackup(@Nonnull MemcachedBackupSession session) throws InterruptedException {
            String key = LockingStrategy.this._sessionIdFormat.createBackupKey(session.getId());
            Future<Boolean> touchResultFuture = LockingStrategy.this._storage.add(key, 5, BYTE_1);
            try {
                boolean touchResult = touchResultFuture.get(LockingStrategy.this._manager.getOperationTimeout(), TimeUnit.MILLISECONDS);
                if (touchResult) {
                    LockingStrategy.this._log.warn((Object)("The secondary backup for session " + session.getIdInternal() + " should be touched in memcached, but it seemed to be not existing. Will store in memcached again."));
                    this.saveSessionBackup(session, key);
                } else {
                    LockingStrategy.this._log.debug((Object)"The secondary session backup was ping'ed successfully.");
                }
            }
            catch (TimeoutException e) {
                LockingStrategy.this._log.warn((Object)("The secondary backup for session " + session.getIdInternal() + " could not be completed within " + LockingStrategy.this._manager.getOperationTimeout() + " millis, was cancelled now."));
            }
            catch (ExecutionException e) {
                LockingStrategy.this._log.warn((Object)("An exception occurred when trying to ping session " + session.getIdInternal()), (Throwable)e);
            }
        }

        public void saveSessionBackup(@Nonnull MemcachedBackupSession session, @Nonnull String key) throws InterruptedException {
            try {
                byte[] data = LockingStrategy.this._manager.serialize(session);
                Future<Boolean> backupResult = LockingStrategy.this._storage.set(key, MemcachedUtil.toMemcachedExpiration(session.getMemcachedExpirationTimeToSet()), data);
                if (!backupResult.get().booleanValue()) {
                    LockingStrategy.this._log.warn((Object)("Update for secondary backup of session " + session.getIdInternal() + " (after unsuccessful ping) did not return sucess."));
                }
            }
            catch (ExecutionException e) {
                LockingStrategy.this._log.warn((Object)("An exception occurred when trying to update secondary session backup for " + session.getIdInternal()), (Throwable)e);
            }
        }
    }

    public static enum LockingMode {
        NONE,
        ALL,
        AUTO,
        APP,
        URI_PATTERN;

    }
}

