/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.Configurations;
import de.javakaffee.web.msm.NodeAvailabilityCache;
import de.javakaffee.web.msm.NodeIdList;
import de.javakaffee.web.msm.NodeIdService;
import de.javakaffee.web.msm.Pair;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.StorageKeyFormat;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MemcachedNodesManager {
    private static final Log LOG = LogFactory.getLog(MemcachedNodesManager.class);
    private static final String NODE_REGEX = "([\\w]+):([^:]+):([\\d]+)";
    private static final Pattern NODE_PATTERN = Pattern.compile("([\\w]+):([^:]+):([\\d]+)");
    private static final String NODES_REGEX = "([\\w]+):([^:]+):([\\d]+)(?:(?:\\s+|,)([\\w]+):([^:]+):([\\d]+))*";
    private static final Pattern NODES_PATTERN = Pattern.compile("([\\w]+):([^:]+):([\\d]+)(?:(?:\\s+|,)([\\w]+):([^:]+):([\\d]+))*");
    private static final String SINGLE_NODE_REGEX = "([^:]+):([\\d]+)";
    private static final Pattern SINGLE_NODE_PATTERN = Pattern.compile("([^:]+):([\\d]+)");
    private static final String COUCHBASE_BUCKET_NODE_REGEX = "http://([^:]+):([\\d]+)/[\\w]+";
    private static final Pattern COUCHBASE_BUCKET_NODE_PATTERN = Pattern.compile("http://([^:]+):([\\d]+)/[\\w]+");
    private static final String COUCHBASE_BUCKET_NODES_REGEX = "http://([^:]+):([\\d]+)/[\\w]+(?:(?:\\s+|,)http://([^:]+):([\\d]+)/[\\w]+)*";
    private static final Pattern COUCHBASE_BUCKET_NODES_PATTERN = Pattern.compile("http://([^:]+):([\\d]+)/[\\w]+(?:(?:\\s+|,)http://([^:]+):([\\d]+)/[\\w]+)*");
    private static final int NODE_AVAILABILITY_CACHE_TTL = Configurations.getSystemProperty("msm.nodeAvailabilityCacheTTL", 1000);
    private final String _memcachedNodes;
    private final NodeIdList _primaryNodeIds;
    private final List<String> _failoverNodeIds;
    private final LinkedHashMap<InetSocketAddress, String> _address2Ids;
    private final boolean _encodeNodeIdInSessionId;
    private final StorageKeyFormat _storageKeyFormat;
    @Nullable
    private NodeIdService _nodeIdService;
    private SessionIdFormat _sessionIdFormat;

    public MemcachedNodesManager(String memcachedNodes, @Nonnull NodeIdList primaryNodeIds, @Nonnull List<String> failoverNodeIds, @Nonnull LinkedHashMap<InetSocketAddress, String> address2Ids, @Nullable StorageKeyFormat storageKeyFormat, @Nullable MemcachedClientCallback memcachedClientCallback) {
        this._memcachedNodes = memcachedNodes;
        this._primaryNodeIds = primaryNodeIds;
        this._failoverNodeIds = failoverNodeIds;
        this._address2Ids = address2Ids;
        this._storageKeyFormat = storageKeyFormat;
        boolean bl = this._encodeNodeIdInSessionId = this.getCountNodes() > 1 && !this.isCouchbaseConfig(memcachedNodes) || !this._primaryNodeIds.isEmpty();
        if (this._encodeNodeIdInSessionId) {
            if (memcachedClientCallback == null) {
                throw new IllegalArgumentException("The MemcachedClientCallback must not be null.");
            }
            this._sessionIdFormat = new SessionIdFormat(storageKeyFormat);
            this._nodeIdService = new NodeIdService(this.createNodeAvailabilityCache(this.getCountNodes(), NODE_AVAILABILITY_CACHE_TTL, memcachedClientCallback), primaryNodeIds, failoverNodeIds);
        } else {
            this._sessionIdFormat = new SessionIdFormat(storageKeyFormat){

                @Override
                public boolean isValid(String sessionId) {
                    return sessionId != null;
                }

                @Override
                public String createBackupKey(String origKey) {
                    throw new UnsupportedOperationException("Not supported for single node configuration without node id.");
                }

                @Override
                public String createSessionId(String sessionId, String memcachedId) {
                    return sessionId;
                }

                @Override
                public String extractMemcachedId(String sessionId) {
                    throw new UnsupportedOperationException("Not supported for single node configuration without node id.");
                }
            };
            this._nodeIdService = null;
        }
    }

    private boolean isCouchbaseConfig(String memcachedNodes) {
        return memcachedNodes.startsWith("http://");
    }

    protected NodeAvailabilityCache<String> createNodeAvailabilityCache(int size, long ttlInMillis, final @Nonnull MemcachedClientCallback memcachedClientCallback) {
        return new NodeAvailabilityCache<String>(size, ttlInMillis, new NodeAvailabilityCache.CacheLoader<String>(){

            @Override
            public boolean isNodeAvailable(String key) {
                try {
                    memcachedClientCallback.get(MemcachedNodesManager.this._sessionIdFormat.createSessionId("ping", key));
                    return true;
                }
                catch (Exception e) {
                    return false;
                }
            }
        });
    }

    @Nonnull
    public static MemcachedNodesManager createFor(String memcachedNodes, String failoverNodes, StorageKeyFormat storageKeyFormat, MemcachedClientCallback memcachedClientCallback) {
        Matcher matcher;
        if (memcachedNodes == null || memcachedNodes.trim().isEmpty()) {
            throw new IllegalArgumentException("null or empty memcachedNodes not allowed.");
        }
        if (!(NODES_PATTERN.matcher(memcachedNodes).matches() || SINGLE_NODE_PATTERN.matcher(memcachedNodes).matches() || COUCHBASE_BUCKET_NODES_PATTERN.matcher(memcachedNodes).matches())) {
            throw new IllegalArgumentException("Configured memcachedNodes attribute has wrong format, must match ([\\w]+):([^:]+):([\\d]+)(?:(?:\\s+|,)([\\w]+):([^:]+):([\\d]+))*");
        }
        Matcher singleNodeMatcher = SINGLE_NODE_PATTERN.matcher(memcachedNodes);
        LinkedHashMap<InetSocketAddress, String> address2Ids = new LinkedHashMap<InetSocketAddress, String>(1);
        if (singleNodeMatcher.matches()) {
            address2Ids.put(MemcachedNodesManager.getSingleShortNodeDefinition(singleNodeMatcher), null);
        } else if (COUCHBASE_BUCKET_NODES_PATTERN.matcher(memcachedNodes).matches()) {
            matcher = COUCHBASE_BUCKET_NODE_PATTERN.matcher(memcachedNodes);
            while (matcher.find()) {
                String hostname = matcher.group(1);
                int port = Integer.parseInt(matcher.group(2));
                address2Ids.put(new InetSocketAddress(hostname, port), null);
            }
            if (address2Ids.isEmpty()) {
                throw new IllegalArgumentException("All nodes are also configured as failover nodes, this is a configuration failure. In this case, you probably want to leave out the failoverNodes.");
            }
        } else {
            matcher = NODE_PATTERN.matcher(memcachedNodes);
            while (matcher.find()) {
                Pair<String, InetSocketAddress> nodeInfo = MemcachedNodesManager.getRegularNodeDefinition(matcher);
                address2Ids.put(nodeInfo.getSecond(), nodeInfo.getFirst());
            }
            if (address2Ids.isEmpty()) {
                throw new IllegalArgumentException("All nodes are also configured as failover nodes, this is a configuration failure. In this case, you probably want to leave out the failoverNodes.");
            }
        }
        List<String> failoverNodeIds = MemcachedNodesManager.initFailoverNodes(failoverNodes, address2Ids.values());
        if (address2Ids.size() == 1 && failoverNodeIds.size() >= 1) {
            throw new IllegalArgumentException("For a single memcached node there should/must no failoverNodes be specified.");
        }
        NodeIdList primaryNodeIds = new NodeIdList(new String[0]);
        for (Map.Entry address2Id : address2Ids.entrySet()) {
            String nodeId = (String)address2Id.getValue();
            if (nodeId == null || failoverNodeIds.contains(nodeId)) continue;
            primaryNodeIds.add(nodeId);
        }
        return new MemcachedNodesManager(memcachedNodes, primaryNodeIds, failoverNodeIds, address2Ids, storageKeyFormat, memcachedClientCallback);
    }

    private static InetSocketAddress getSingleShortNodeDefinition(Matcher singleNodeMatcher) {
        String hostname = singleNodeMatcher.group(1);
        int port = Integer.parseInt(singleNodeMatcher.group(2));
        return new InetSocketAddress(hostname, port);
    }

    private static Pair<String, InetSocketAddress> getRegularNodeDefinition(Matcher matcher) {
        String nodeId = matcher.group(1);
        String hostname = matcher.group(2);
        int port = Integer.parseInt(matcher.group(3));
        InetSocketAddress address = new InetSocketAddress(hostname, port);
        return Pair.of(nodeId, address);
    }

    private static List<String> initFailoverNodes(String failoverNodes, Collection<String> allNodeIds) {
        ArrayList<String> failoverNodeIds = new ArrayList<String>();
        if (failoverNodes != null && failoverNodes.trim().length() != 0) {
            String[] failoverNodesArray;
            for (String failoverNodeId : failoverNodesArray = failoverNodes.split(" |,")) {
                String failoverNodeIdTrimmed = failoverNodeId.trim();
                if (!allNodeIds.contains(failoverNodeIdTrimmed)) {
                    throw new IllegalArgumentException("Invalid failover node id " + failoverNodeIdTrimmed + ": not existing in memcachedNodes '" + allNodeIds + "'.");
                }
                failoverNodeIds.add(failoverNodeIdTrimmed);
            }
        }
        return failoverNodeIds;
    }

    public String getMemcachedNodes() {
        return this._memcachedNodes;
    }

    public int getCountNodes() {
        return this._address2Ids.size();
    }

    @Nonnull
    public NodeIdList getPrimaryNodeIds() {
        return this._primaryNodeIds;
    }

    @Nonnull
    public List<String> getFailoverNodeIds() {
        return this._failoverNodeIds;
    }

    public boolean isEncodeNodeIdInSessionId() {
        return this._encodeNodeIdInSessionId;
    }

    @Nonnull
    public String getNodeId(InetSocketAddress socketAddress) throws IllegalArgumentException {
        if (socketAddress == null) {
            throw new IllegalArgumentException("SocketAddress must not be null.");
        }
        String result = this._address2Ids.get(socketAddress);
        if (result == null) {
            throw new IllegalArgumentException("SocketAddress " + socketAddress + " not known (registered addresses: " + this._address2Ids.keySet() + ").");
        }
        return result;
    }

    @CheckForNull
    public String getNextPrimaryNodeId(String nodeId) {
        return this._primaryNodeIds.getNextNodeId(nodeId);
    }

    public String getNextAvailableNodeId(String nodeId) {
        String result = nodeId;
        do {
            if ((result = this._primaryNodeIds.getNextNodeId(result)) == null || !result.equals(nodeId)) continue;
            result = null;
        } while (result != null && !this.isNodeAvailable(result));
        return result;
    }

    @Nonnull
    public SessionIdFormat getSessionIdFormat() {
        return this._sessionIdFormat;
    }

    @Nonnull
    public StorageKeyFormat getStorageKeyFormat() {
        return this._storageKeyFormat;
    }

    @Nonnull
    public List<InetSocketAddress> getAllMemcachedAddresses() {
        return new ArrayList<InetSocketAddress>(this._address2Ids.keySet());
    }

    @Nonnull
    public String createSessionId(@Nonnull String sessionId) {
        return this.isEncodeNodeIdInSessionId() ? this._sessionIdFormat.createSessionId(sessionId, this._nodeIdService.getMemcachedNodeId()) : sessionId;
    }

    public void setNodeAvailable(@Nullable String nodeId, boolean available) {
        if (this._nodeIdService != null) {
            this._nodeIdService.setNodeAvailable(nodeId, available);
        }
    }

    public boolean isNodeAvailable(String nodeId) {
        return this._nodeIdService.isNodeAvailable(nodeId);
    }

    public boolean isValidForMemcached(String sessionId) {
        String nodeId;
        if (this.isEncodeNodeIdInSessionId() && (nodeId = this._sessionIdFormat.extractMemcachedId(sessionId)) == null) {
            LOG.debug((Object)"The sessionId does not contain a nodeId so that the memcached node could not be identified.");
            return false;
        }
        return true;
    }

    public boolean canHitMemcached(String sessionId) {
        if (this.isEncodeNodeIdInSessionId()) {
            String nodeId = this._sessionIdFormat.extractMemcachedId(sessionId);
            if (nodeId == null) {
                LOG.debug((Object)"The sessionId does not contain a nodeId so that the memcached node could not be identified.");
                return false;
            }
            if (!this._nodeIdService.isNodeAvailable(nodeId)) {
                LOG.debug((Object)("The node " + nodeId + " is not available, therefore " + sessionId + " cannot be loaded from this memcached."));
                return false;
            }
        }
        return true;
    }

    public void onLoadFromMemcachedSuccess(String sessionId) {
        this.setNodeAvailableForSessionId(sessionId, true);
    }

    public void onLoadFromMemcachedFailure(String sessionId) {
        this.setNodeAvailableForSessionId(sessionId, false);
    }

    public String setNodeAvailableForSessionId(String sessionId, boolean available) {
        if (this._nodeIdService != null && this.isEncodeNodeIdInSessionId()) {
            String nodeId = this._sessionIdFormat.extractMemcachedId(sessionId);
            if (nodeId != null) {
                this._nodeIdService.setNodeAvailable(nodeId, available);
                return nodeId;
            }
            LOG.warn((Object)("Got sessionId without nodeId: " + sessionId));
        }
        return null;
    }

    public String getNewSessionIdIfNodeFromSessionIdUnavailable(@Nonnull String sessionId) {
        String nodeId;
        String newNodeId;
        if (this.isEncodeNodeIdInSessionId() && (newNodeId = this._nodeIdService.getNewNodeIdIfUnavailable(nodeId = this._sessionIdFormat.extractMemcachedId(sessionId))) != null) {
            return this._sessionIdFormat.createNewSessionId(sessionId, newNodeId);
        }
        return null;
    }

    public String changeSessionIdForTomcatFailover(@Nonnull String sessionId, String jvmRoute) {
        String newSessionId;
        String string = newSessionId = jvmRoute != null && !jvmRoute.trim().isEmpty() ? this._sessionIdFormat.changeJvmRoute(sessionId, jvmRoute) : this._sessionIdFormat.stripJvmRoute(sessionId);
        if (this.isEncodeNodeIdInSessionId()) {
            String newNodeId;
            String nodeId = this._sessionIdFormat.extractMemcachedId(newSessionId);
            if (this._failoverNodeIds != null && this._failoverNodeIds.contains(nodeId) && (newNodeId = this._nodeIdService.getAvailableNodeId(nodeId)) != null) {
                return this._sessionIdFormat.createNewSessionId(newSessionId, newNodeId);
            }
        }
        return newSessionId;
    }

    public boolean isCouchbaseBucketConfig() {
        return COUCHBASE_BUCKET_NODES_PATTERN.matcher(this._memcachedNodes).matches();
    }

    public List<URI> getCouchbaseBucketURIs() {
        if (!this.isCouchbaseBucketConfig()) {
            throw new IllegalStateException("This is not a couchbase bucket configuration.");
        }
        ArrayList<URI> result = new ArrayList<URI>(this._address2Ids.size());
        Matcher matcher = COUCHBASE_BUCKET_NODE_PATTERN.matcher(this._memcachedNodes);
        while (matcher.find()) {
            try {
                result.add(new URI(matcher.group()));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static interface MemcachedClientCallback {
        @Nullable
        public Object get(@Nonnull String var1);
    }
}

