/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.SessionIdFormat;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.ops.Operation;

class SuffixBasedNodeLocator
implements NodeLocator {
    private final List<MemcachedNode> _nodes;
    private final MemcachedNodesManager _memcachedNodesManager;
    private final Map<String, MemcachedNode> _nodesMap;
    private final SessionIdFormat _sessionIdFormat;

    public SuffixBasedNodeLocator(List<MemcachedNode> nodes, MemcachedNodesManager memcachedNodesManager, SessionIdFormat sessionIdFormat) {
        this._nodes = nodes;
        this._memcachedNodesManager = memcachedNodesManager;
        HashMap<String, MemcachedNode> map = new HashMap<String, MemcachedNode>(nodes.size(), 1.0f);
        for (int i = 0; i < nodes.size(); ++i) {
            MemcachedNode memcachedNode = nodes.get(i);
            String nodeId = memcachedNodesManager.getNodeId((InetSocketAddress)memcachedNode.getSocketAddress());
            map.put(nodeId, memcachedNode);
        }
        this._nodesMap = map;
        this._sessionIdFormat = sessionIdFormat;
    }

    public void updateLocator(List<MemcachedNode> nodes) {
        throw new UnsupportedOperationException("Not yet supported.");
    }

    public Collection<MemcachedNode> getAll() {
        return this._nodesMap.values();
    }

    public MemcachedNode getPrimary(String key) {
        String nodeId = this.getNodeId(key);
        MemcachedNode result = this._nodesMap.get(nodeId);
        if (result == null) {
            throw new IllegalArgumentException("No node found for key " + key + " (nodeId: " + nodeId + ", known nodeIds: " + this._nodesMap.keySet() + ")");
        }
        return result;
    }

    private String getNodeId(String key) {
        String nodeId = this._sessionIdFormat.extractMemcachedId(key);
        if (!this._sessionIdFormat.isBackupKey(key)) {
            return nodeId;
        }
        return this._memcachedNodesManager.getNextAvailableNodeId(nodeId);
    }

    public Iterator<MemcachedNode> getSequence(String key) {
        throw new UnsupportedOperationException("This should not be called as we specified FailureMode.Cancel.");
    }

    public NodeLocator getReadonlyCopy() {
        ArrayList<MemcachedNode> nodes = new ArrayList<MemcachedNode>();
        for (MemcachedNode node : this._nodes) {
            nodes.add(new MyMemcachedNodeROImpl(node));
        }
        return new SuffixBasedNodeLocator(nodes, this._memcachedNodesManager, this._sessionIdFormat);
    }

    static class MyMemcachedNodeROImpl
    implements MemcachedNode {
        private final MemcachedNode root;

        public MyMemcachedNodeROImpl(MemcachedNode node) {
            this.root = node;
        }

        public String toString() {
            return this.root.toString();
        }

        public void addOp(Operation op) {
            throw new UnsupportedOperationException();
        }

        public void insertOp(Operation op) {
            throw new UnsupportedOperationException();
        }

        public void connected() {
            throw new UnsupportedOperationException();
        }

        public void copyInputQueue() {
            throw new UnsupportedOperationException();
        }

        public void fillWriteBuffer(boolean optimizeGets) {
            throw new UnsupportedOperationException();
        }

        public void fixupOps() {
            throw new UnsupportedOperationException();
        }

        public int getBytesRemainingToWrite() {
            return this.root.getBytesRemainingToWrite();
        }

        public SocketChannel getChannel() {
            throw new UnsupportedOperationException();
        }

        public Operation getCurrentReadOp() {
            throw new UnsupportedOperationException();
        }

        public Operation getCurrentWriteOp() {
            throw new UnsupportedOperationException();
        }

        public ByteBuffer getRbuf() {
            throw new UnsupportedOperationException();
        }

        public int getReconnectCount() {
            return this.root.getReconnectCount();
        }

        public int getSelectionOps() {
            return this.root.getSelectionOps();
        }

        public SelectionKey getSk() {
            throw new UnsupportedOperationException();
        }

        public SocketAddress getSocketAddress() {
            return this.root.getSocketAddress();
        }

        public ByteBuffer getWbuf() {
            throw new UnsupportedOperationException();
        }

        public boolean hasReadOp() {
            return this.root.hasReadOp();
        }

        public boolean hasWriteOp() {
            return this.root.hasReadOp();
        }

        public boolean isActive() {
            return this.root.isActive();
        }

        public void reconnecting() {
            throw new UnsupportedOperationException();
        }

        public void registerChannel(SocketChannel ch, SelectionKey selectionKey) {
            throw new UnsupportedOperationException();
        }

        public Operation removeCurrentReadOp() {
            throw new UnsupportedOperationException();
        }

        public Operation removeCurrentWriteOp() {
            throw new UnsupportedOperationException();
        }

        public void setChannel(SocketChannel to) {
            throw new UnsupportedOperationException();
        }

        public void setSk(SelectionKey to) {
            throw new UnsupportedOperationException();
        }

        public void setupResend() {
            throw new UnsupportedOperationException();
        }

        public void transitionWriteItem() {
            throw new UnsupportedOperationException();
        }

        public int writeSome() throws IOException {
            throw new UnsupportedOperationException();
        }

        public Collection<Operation> destroyInputQueue() {
            throw new UnsupportedOperationException();
        }

        public void authComplete() {
            throw new UnsupportedOperationException();
        }

        public void setupForAuth() {
            throw new UnsupportedOperationException();
        }

        public int getContinuousTimeout() {
            throw new UnsupportedOperationException();
        }

        public void setContinuousTimeout(boolean isIncrease) {
            throw new UnsupportedOperationException();
        }

        public boolean isAuthenticated() {
            throw new UnsupportedOperationException();
        }

        public long lastReadDelta() {
            throw new UnsupportedOperationException();
        }

        public void completedRead() {
            throw new UnsupportedOperationException();
        }
    }
}

