/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupSessionService;
import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.Configurations;
import de.javakaffee.web.msm.CurrentRequest;
import de.javakaffee.web.msm.JavaSerializationTranscoderFactory;
import de.javakaffee.web.msm.LRUCache;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedClientFactory;
import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.RequestTrackingContextValve;
import de.javakaffee.web.msm.RequestTrackingHostValve;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.SessionValidityInfo;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.TranscoderFactory;
import de.javakaffee.web.msm.TranscoderService;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.security.Principal;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.spy.memcached.MemcachedClient;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.Valve;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.session.StandardSession;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MemcachedSessionService {
    public static final String PROTOCOL_TEXT = "text";
    public static final String PROTOCOL_BINARY = "binary";
    protected static final String NODE_FAILURE = "node.failure";
    protected static final String NEW_SESSION_ID = "msm.session.id";
    protected final Log _log = LogFactory.getLog(this.getClass());
    private String _memcachedNodes;
    private String _failoverNodes;
    private String _requestUriIgnorePattern;
    private String _sessionAttributeFilter = null;
    private Pattern _sessionAttributePattern = null;
    private boolean _sessionBackupAsync = true;
    private int _sessionBackupTimeout = 100;
    private String _transcoderFactoryClassName = JavaSerializationTranscoderFactory.class.getName();
    private boolean _copyCollectionsForSerialization = false;
    private String _customConverterClassNames;
    private boolean _enableStatistics = true;
    private int _backupThreadCount = Runtime.getRuntime().availableProcessors();
    private String _memcachedProtocol = "text";
    private String _username;
    private String _password;
    private final AtomicBoolean _enabled = new AtomicBoolean(true);
    protected Statistics _statistics;
    private MemcachedClient _memcached;
    private LRUCache<String, Boolean> _missingSessionsCache;
    private MemcachedNodesManager _memcachedNodesManager;
    protected TranscoderService _transcoderService;
    private TranscoderFactory _transcoderFactory;
    private BackupSessionService _backupSessionService;
    private boolean _sticky = true;
    private String _lockingMode;
    private LockingStrategy _lockingStrategy;
    private long _operationTimeout = 1000L;
    private CurrentRequest _currentRequest;
    private RequestTrackingHostValve _trackingHostValve;
    private RequestTrackingContextValve _trackingContextValve;
    private Boolean _contextHasFormBasedSecurityConstraint;
    private final SessionManager _manager;
    private final MemcachedNodesManager.MemcachedClientCallback _memcachedClientCallback = this.createMemcachedClientCallback();
    private final LRUCache<String, Object> _removedSessions = new LRUCache(2000, 5000L);

    public MemcachedSessionService(SessionManager manager) {
        this._manager = manager;
    }

    @Nonnull
    public SessionManager getManager() {
        return this._manager;
    }

    public void shutdown() {
        this._log.info((Object)"Stopping services.");
        this._manager.getContainer().getParent().getPipeline().removeValve((Valve)this._trackingHostValve);
        this._manager.getContainer().getPipeline().removeValve((Valve)this._trackingContextValve);
        this._backupSessionService.shutdown();
        if (this._lockingStrategy != null) {
            this._lockingStrategy.shutdown();
        }
        if (this._memcached != null) {
            this._memcached.shutdown();
            this._memcached = null;
        }
        this._transcoderFactory = null;
    }

    void startInternal(MemcachedClient memcachedClient) throws LifecycleException {
        this._memcached = memcachedClient;
        this.startInternal();
    }

    void startInternal() throws LifecycleException {
        this._log.info((Object)(this.getClass().getSimpleName() + " starts initialization... (configured" + " nodes definition " + this._memcachedNodes + ", failover nodes " + this._failoverNodes + ")"));
        this._statistics = Statistics.create(this._enableStatistics);
        this._memcachedNodesManager = this.createMemcachedNodesManager(this._memcachedNodes, this._failoverNodes);
        if (this._memcached == null) {
            this._memcached = this.createMemcachedClient(this._memcachedNodesManager, this._statistics);
        }
        this._missingSessionsCache = new LRUCache(200, 500L);
        String sessionCookieName = this._manager.getSessionCookieName();
        this._currentRequest = new CurrentRequest();
        this._trackingHostValve = this.createRequestTrackingHostValve(sessionCookieName, this._currentRequest);
        this._manager.getContainer().getParent().getPipeline().addValve((Valve)this._trackingHostValve);
        this._trackingContextValve = this.createRequestTrackingContextValve(sessionCookieName);
        this._manager.getContainer().getPipeline().addValve((Valve)this._trackingContextValve);
        this.initNonStickyLockingMode(this._memcachedNodesManager);
        this._transcoderService = this.createTranscoderService(this._statistics);
        this._backupSessionService = new BackupSessionService(this._transcoderService, this._sessionBackupAsync, this._sessionBackupTimeout, this._backupThreadCount, this._memcached, this._memcachedNodesManager, this._statistics);
        this._log.info((Object)(this.getClass().getSimpleName() + " finished initialization, sticky " + this._sticky + ", operation timeout " + this._operationTimeout + ", with node ids " + this._memcachedNodesManager.getPrimaryNodeIds() + " and failover node ids " + this._memcachedNodesManager.getFailoverNodeIds()));
    }

    protected RequestTrackingContextValve createRequestTrackingContextValve(String sessionCookieName) {
        return new RequestTrackingContextValve(sessionCookieName, this);
    }

    protected RequestTrackingHostValve createRequestTrackingHostValve(String sessionCookieName, CurrentRequest currentRequest) {
        return new RequestTrackingHostValve(this._requestUriIgnorePattern, sessionCookieName, this, this._statistics, this._enabled, currentRequest){

            @Override
            protected String[] getSetCookieHeaders(Response response) {
                return MemcachedSessionService.this._manager.getSetCookieHeaders(response);
            }
        };
    }

    protected MemcachedNodesManager.MemcachedClientCallback createMemcachedClientCallback() {
        return new MemcachedNodesManager.MemcachedClientCallback(){

            @Override
            public Object get(String key) {
                return MemcachedSessionService.this._memcached.get(key);
            }
        };
    }

    protected MemcachedNodesManager createMemcachedNodesManager(String memcachedNodes, String failoverNodes) {
        return MemcachedNodesManager.createFor(memcachedNodes, failoverNodes, this._memcachedClientCallback);
    }

    private TranscoderService createTranscoderService(Statistics statistics) {
        return new TranscoderService(this.getTranscoderFactory().createTranscoder(this._manager));
    }

    protected TranscoderFactory getTranscoderFactory() {
        if (this._transcoderFactory == null) {
            try {
                this._transcoderFactory = this.createTranscoderFactory();
            }
            catch (Exception e) {
                throw new RuntimeException("Could not create transcoder factory.", e);
            }
        }
        return this._transcoderFactory;
    }

    protected MemcachedClient createMemcachedClient(MemcachedNodesManager memcachedNodesManager, Statistics statistics) {
        if (!this._enabled.get()) {
            return null;
        }
        long maxReconnectDelay = Configurations.getSystemProperty("msm.maxReconnectDelay", 30L);
        return new MemcachedClientFactory().createMemcachedClient(memcachedNodesManager, this._memcachedProtocol, this._username, this._password, this._operationTimeout, maxReconnectDelay, statistics);
    }

    private TranscoderFactory createTranscoderFactory() throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        this._log.info((Object)("Creating transcoder factory " + this._transcoderFactoryClassName));
        Class<? extends TranscoderFactory> transcoderFactoryClass = this.loadTranscoderFactoryClass();
        TranscoderFactory transcoderFactory = transcoderFactoryClass.newInstance();
        transcoderFactory.setCopyCollectionsForSerialization(this._copyCollectionsForSerialization);
        if (this._customConverterClassNames != null) {
            this._log.info((Object)("Found configured custom converter classes, setting on transcoder factory: " + this._customConverterClassNames));
            transcoderFactory.setCustomConverterClassNames(this._customConverterClassNames.split(",\\s*"));
        }
        return transcoderFactory;
    }

    private Class<? extends TranscoderFactory> loadTranscoderFactoryClass() throws ClassNotFoundException {
        Class<TranscoderFactory> transcoderFactoryClass;
        ClassLoader classLoader = this._manager.getContainer().getLoader().getClassLoader();
        try {
            this._log.debug((Object)("Loading transcoder factory class " + this._transcoderFactoryClassName + " using classloader " + classLoader));
            transcoderFactoryClass = Class.forName(this._transcoderFactoryClassName, false, classLoader).asSubclass(TranscoderFactory.class);
        }
        catch (ClassNotFoundException e) {
            this._log.info((Object)("Could not load transcoderfactory class with classloader " + classLoader + ", trying " + this.getClass().getClassLoader()));
            transcoderFactoryClass = Class.forName(this._transcoderFactoryClassName, false, this.getClass().getClassLoader()).asSubclass(TranscoderFactory.class);
        }
        return transcoderFactoryClass;
    }

    public String newSessionId(@Nonnull String sessionId) {
        return this._memcachedNodesManager.createSessionId(sessionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemcachedBackupSession findSession(String id) throws IOException {
        MemcachedBackupSession result = this._manager.getSessionInternal(id);
        if (result != null) {
            if (!(this._sticky || this._trackingHostValve.isIgnoredRequest() || this.isContainerSessionLookup())) {
                result.registerReference();
            }
        } else if (this.canHitMemcached(id) && this._missingSessionsCache.get(id) == null) {
            if (!this._sticky && this.isContainerSessionLookup() && !this.contextHasFormBasedSecurityConstraint()) {
                return null;
            }
            if (!this._sticky && this._currentRequest.get() == null) {
                return null;
            }
            result = this.loadFromMemcached(id);
            if (result != null && result.isValid()) {
                if (!this._sticky) {
                    Map<String, Session> map = this._manager.getSessionsInternal();
                    synchronized (map) {
                        if (this._manager.getSessionInternal(id) != null) {
                            result = this._manager.getSessionInternal(id);
                        } else {
                            this.addValidLoadedSession(result);
                        }
                        result.registerReference();
                    }
                } else {
                    this.addValidLoadedSession(result);
                }
            }
        }
        return result;
    }

    private boolean isContainerSessionLookup() {
        return !this._trackingContextValve.wasInvokedWith(this._currentRequest.get());
    }

    private void addValidLoadedSession(MemcachedBackupSession result) {
        String jvmRoute;
        boolean sessionIdWillBeChanged = this._sticky && (jvmRoute = this._manager.getJvmRoute()) != null && !jvmRoute.equals(this.getSessionIdFormat().extractJvmRoute(result.getId()));
        boolean activate = !sessionIdWillBeChanged;
        this.addValidLoadedSession(result, activate);
    }

    private boolean contextHasFormBasedSecurityConstraint() {
        if (this._contextHasFormBasedSecurityConstraint != null) {
            return this._contextHasFormBasedSecurityConstraint;
        }
        Context context = (Context)this._manager.getContainer();
        SecurityConstraint[] constraints = context.findConstraints();
        LoginConfig loginConfig = context.getLoginConfig();
        this._contextHasFormBasedSecurityConstraint = constraints != null && constraints.length > 0 && loginConfig != null && "FORM".equals(loginConfig.getAuthMethod());
        return this._contextHasFormBasedSecurityConstraint;
    }

    private void addValidLoadedSession(StandardSession session, boolean activate) {
        if (session.isNew()) {
            session.tellNew();
        }
        this._manager.add((Session)session);
        if (activate) {
            session.activate();
        }
        session.access();
        session.endAccess();
    }

    public MemcachedBackupSession createSession(String sessionId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("createSession invoked: " + sessionId));
        }
        this.checkMaxActiveSessions();
        MemcachedBackupSession session = this.createEmptySession();
        session.setNew(true);
        session.setValid(true);
        session.setCreationTime(System.currentTimeMillis());
        session.setMaxInactiveInterval(this._manager.getMaxInactiveInterval());
        if (sessionId == null || !this._memcachedNodesManager.canHitMemcached(sessionId)) {
            sessionId = this._manager.generateSessionId();
        }
        session.setId(sessionId);
        Request request = this._currentRequest.get();
        if (request != null) {
            request.setNote(NEW_SESSION_ID, (Object)sessionId);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Created new session with id " + session.getId()));
        }
        this._manager.incrementSessionCounter();
        return session;
    }

    public void sessionRemoved(MemcachedBackupSession session) {
        if (!this._sticky) {
            if (session.isLocked()) {
                this._lockingStrategy.releaseLock(session.getIdInternal());
                session.releaseLock();
            }
            this._removedSessions.put(session.getIdInternal(), "unused");
        }
    }

    private void checkMaxActiveSessions() {
        if (this._manager.getMaxActiveSessions() >= 0 && this._manager.getSessionsInternal().size() >= this._manager.getMaxActiveSessions()) {
            this._manager.incrementRejectedSessions();
            throw new IllegalStateException(this._manager.getString("standardManager.createSession.ise"));
        }
    }

    public MemcachedBackupSession createEmptySession() {
        MemcachedBackupSession result = this._manager.newMemcachedBackupSession();
        result.setSticky(this._sticky);
        return result;
    }

    public String changeSessionIdOnTomcatFailover(String requestedSessionId) {
        if (!this._sticky) {
            return null;
        }
        String localJvmRoute = this._manager.getJvmRoute();
        if (localJvmRoute != null && !localJvmRoute.equals(this.getSessionIdFormat().extractJvmRoute(requestedSessionId))) {
            MemcachedBackupSession session = this._manager.getSessionInternal(requestedSessionId);
            if (session == null) {
                session = this.loadFromMemcachedWithCheck(requestedSessionId);
            }
            if (session != null && session.isValid()) {
                return this.handleSessionTakeOver(session);
            }
        }
        return null;
    }

    @Nonnull
    private SessionIdFormat getSessionIdFormat() {
        return this._memcachedNodesManager.getSessionIdFormat();
    }

    private String handleSessionTakeOver(MemcachedBackupSession session) {
        this.checkMaxActiveSessions();
        String origSessionId = session.getIdInternal();
        String newSessionId = this.getSessionIdFormat().changeJvmRoute(session.getIdInternal(), this._manager.getJvmRoute());
        if (this._manager.getSessionsInternal().containsKey(origSessionId)) {
            this._manager.getSessionsInternal().remove(origSessionId);
        }
        session.setIdInternal(newSessionId);
        this.addValidLoadedSession(session, true);
        this.deleteFromMemcached(origSessionId);
        this._statistics.requestWithTomcatFailover();
        return newSessionId;
    }

    protected void deleteFromMemcached(String sessionId) {
        if (this._enabled.get() && this._memcachedNodesManager.isValidForMemcached(sessionId)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Deleting session from memcached: " + sessionId));
            }
            try {
                long start = System.currentTimeMillis();
                this._memcached.delete(sessionId).get();
                this._statistics.registerSince(Statistics.StatsType.DELETE_FROM_MEMCACHED, start);
                if (!this._sticky) {
                    this._lockingStrategy.onAfterDeleteFromMemcached(sessionId);
                }
            }
            catch (Throwable e) {
                this._log.info((Object)"Could not delete session from memcached.", e);
            }
        }
    }

    public String changeSessionIdOnMemcachedFailover(String requestedSessionId) {
        if (!this._memcachedNodesManager.isEncodeNodeIdInSessionId()) {
            return null;
        }
        try {
            if (this._sticky) {
                String newSessionId;
                MemcachedBackupSession session = this._manager.getSessionInternal(requestedSessionId);
                if (session != null && session.isValid() && (newSessionId = this._memcachedNodesManager.getNewSessionIdIfNodeFromSessionIdUnavailable(session.getId())) != null) {
                    this._log.debug((Object)"Session needs to be relocated, setting new id on session...");
                    session.setIdForRelocate(newSessionId);
                    this._statistics.requestWithMemcachedFailover();
                    return newSessionId;
                }
            } else {
                String nodeId = this.getSessionIdFormat().extractMemcachedId(requestedSessionId);
                if (nodeId == null || this._memcachedNodesManager.isNodeAvailable(nodeId)) {
                    return null;
                }
                this._log.info((Object)("Session needs to be relocated as node " + nodeId + " is not available, loading backup session for " + requestedSessionId));
                MemcachedBackupSession backupSession = this.loadBackupSession(requestedSessionId);
                if (backupSession != null) {
                    this._log.debug((Object)("Loaded backup session for " + requestedSessionId + ", adding locally with " + backupSession.getIdInternal() + "."));
                    this.addValidLoadedSession(backupSession, true);
                    this._statistics.requestWithMemcachedFailover();
                    return backupSession.getId();
                }
            }
        }
        catch (RuntimeException e) {
            this._log.warn((Object)"Could not find session in local session map.", (Throwable)e);
        }
        return null;
    }

    @CheckForNull
    private MemcachedBackupSession loadBackupSession(@Nonnull String requestedSessionId) {
        String nodeId = this.getSessionIdFormat().extractMemcachedId(requestedSessionId);
        if (nodeId == null) {
            this._log.info((Object)("Cannot load backupSession for sessionId without nodeId: " + requestedSessionId));
            return null;
        }
        String newNodeId = this._memcachedNodesManager.getNextAvailableNodeId(nodeId);
        if (newNodeId == null) {
            this._log.info((Object)("No next available node found for nodeId " + nodeId));
            return null;
        }
        MemcachedBackupSession result = this.loadBackupSession(requestedSessionId, newNodeId);
        String nextNodeId = nodeId;
        while (result == null && (nextNodeId = this._memcachedNodesManager.getNextAvailableNodeId(nextNodeId)) != null && !nextNodeId.equals(nodeId)) {
            String newSessionId = this.getSessionIdFormat().createNewSessionId(requestedSessionId, nextNodeId);
            result = this.loadBackupSession(newSessionId, newNodeId);
        }
        if (result == null) {
            this._log.info((Object)("No backup found for sessionId " + requestedSessionId));
            return null;
        }
        return result;
    }

    private MemcachedBackupSession loadBackupSession(String requestedSessionId, String newNodeId) {
        try {
            SessionValidityInfo validityInfo = this._lockingStrategy.loadBackupSessionValidityInfo(requestedSessionId);
            if (validityInfo == null || !validityInfo.isValid()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("No validity info (or no valid one) found for sessionId " + requestedSessionId));
                }
                return null;
            }
            Object obj = this._memcached.get(this.getSessionIdFormat().createBackupKey(requestedSessionId));
            if (obj == null) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("No backup found for sessionId " + requestedSessionId));
                }
                return null;
            }
            MemcachedBackupSession session = this._transcoderService.deserialize((byte[])obj, this._manager);
            session.setSticky(this._sticky);
            session.setLastAccessedTimeInternal(validityInfo.getLastAccessedTime());
            session.setThisAccessedTimeInternal(validityInfo.getThisAccessedTime());
            String newSessionId = this.getSessionIdFormat().createNewSessionId(requestedSessionId, newNodeId);
            this._log.info((Object)("Session backup loaded from secondary memcached for " + requestedSessionId + " (will be relocated)," + " setting new id " + newSessionId + " on session..."));
            session.setIdInternal(newSessionId);
            return session;
        }
        catch (Exception e) {
            this._log.error((Object)("Could not get backup validityInfo or backup session for sessionId " + requestedSessionId), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestFinished(String sessionId, String requestId) {
        if (!this._sticky) {
            MemcachedBackupSession msmSession = this._manager.getSessionInternal(sessionId);
            if (msmSession == null) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("No session found in session map for " + sessionId));
                }
                return;
            }
            if (!msmSession.isValidInternal()) {
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Non valid session found in session map for " + sessionId));
                }
                return;
            }
            Map<String, Session> map = this._manager.getSessionsInternal();
            synchronized (map) {
                if (msmSession.releaseReference() > 0) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Session " + sessionId + " is still used by another request, skipping backup and (optional) lock handling/release."));
                    }
                    return;
                }
                msmSession.passivate();
                this._manager.removeInternal((Session)msmSession, false);
            }
            if (msmSession.isLocked()) {
                this._lockingStrategy.releaseLock(sessionId);
                msmSession.releaseLock();
                this._lockingStrategy.registerReadonlyRequest(requestId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Future<BackupSessionTask.BackupResult> backupSession(String sessionId, boolean sessionIdChanged, String requestId) {
        if (!this._enabled.get()) {
            return new BackupSessionService.SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
        }
        MemcachedBackupSession msmSession = this._manager.getSessionInternal(sessionId);
        if (msmSession == null) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("No session found in session map for " + sessionId));
            }
            if (!this._sticky && this._removedSessions.remove(sessionId) == null) {
                this._lockingStrategy.onBackupWithoutLoadedSession(sessionId, requestId, this._backupSessionService);
            }
            return new BackupSessionService.SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
        }
        if (!msmSession.isValidInternal()) {
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Non valid session found in session map for " + sessionId));
            }
            return new BackupSessionService.SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
        }
        if (!this._sticky) {
            Map<String, Session> map = this._manager.getSessionsInternal();
            synchronized (map) {
                if (msmSession.releaseReference() > 0) {
                    if (this._log.isDebugEnabled()) {
                        this._log.debug((Object)("Session " + sessionId + " is still used by another request, skipping backup and (optional) lock handling/release."));
                    }
                    return new BackupSessionService.SimpleFuture<BackupSessionTask.BackupResult>(BackupSessionTask.BackupResult.SKIPPED);
                }
                msmSession.passivate();
                this._manager.removeInternal((Session)msmSession, false);
            }
        }
        boolean force = sessionIdChanged || msmSession.isSessionIdChanged() || !this._sticky && msmSession.getSecondsSinceLastBackup() >= msmSession.getMaxInactiveInterval();
        Future<BackupSessionTask.BackupResult> result = this._backupSessionService.backupSession(msmSession, force);
        if (!this._sticky) {
            this._lockingStrategy.onAfterBackupSession(msmSession, force, result, requestId, this._backupSessionService);
        }
        return result;
    }

    @Nonnull
    byte[] serialize(@Nonnull MemcachedBackupSession session) {
        return this._transcoderService.serialize(session);
    }

    protected MemcachedBackupSession loadFromMemcachedWithCheck(String sessionId) {
        if (!this.canHitMemcached(sessionId) || this._missingSessionsCache.get(sessionId) != null) {
            return null;
        }
        return this.loadFromMemcached(sessionId);
    }

    private boolean canHitMemcached(@Nonnull String sessionId) {
        return this._enabled.get() && this._memcachedNodesManager.canHitMemcached(sessionId);
    }

    private MemcachedBackupSession loadFromMemcached(String sessionId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("Loading session from memcached: " + sessionId));
        }
        LockStatus lockStatus = null;
        try {
            if (!this._sticky) {
                lockStatus = this._lockingStrategy.onBeforeLoadFromMemcached(sessionId);
            }
            long start = System.currentTimeMillis();
            Object object = this._memcached.get(sessionId);
            this._memcachedNodesManager.onLoadFromMemcachedSuccess(sessionId);
            if (object != null) {
                if (!(object instanceof byte[])) {
                    throw new RuntimeException("The loaded object for sessionId " + sessionId + " is not of required type byte[], but " + object.getClass().getName());
                }
                long startDeserialization = System.currentTimeMillis();
                MemcachedBackupSession result = this._transcoderService.deserialize((byte[])object, this._manager);
                this._statistics.registerSince(Statistics.StatsType.SESSION_DESERIALIZATION, startDeserialization);
                this._statistics.registerSince(Statistics.StatsType.LOAD_FROM_MEMCACHED, start);
                result.setSticky(this._sticky);
                if (!this._sticky) {
                    this._lockingStrategy.onAfterLoadFromMemcached(result, lockStatus);
                }
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Found session with id " + sessionId));
                }
                return result;
            }
            if (lockStatus == LockStatus.LOCKED) {
                this._lockingStrategy.releaseLock(sessionId);
            }
            this._missingSessionsCache.put(sessionId, Boolean.TRUE);
            if (this._log.isDebugEnabled()) {
                this._log.debug((Object)("Session " + sessionId + " not found in memcached."));
            }
            return null;
        }
        catch (Exception e) {
            this._log.warn((Object)("Could not load session with id " + sessionId + " from memcached."), (Throwable)e);
            if (lockStatus == LockStatus.LOCKED) {
                this._lockingStrategy.releaseLock(sessionId);
            }
            return null;
        }
    }

    public void setMemcachedNodes(String memcachedNodes) {
        if (this._manager.isInitialized()) {
            MemcachedNodesManager config = this.reloadMemcachedConfig(memcachedNodes, this._failoverNodes);
            this._log.info((Object)("Loaded new memcached node configuration.\n- Former config: " + this._memcachedNodes + "\n- New config: " + memcachedNodes + "\n- New node ids: " + config.getPrimaryNodeIds() + "\n- New failover node ids: " + config.getFailoverNodeIds()));
        }
        this._memcachedNodes = memcachedNodes;
    }

    public String getMemcachedNodes() {
        return this._memcachedNodes;
    }

    private MemcachedNodesManager reloadMemcachedConfig(String memcachedNodes, String failoverNodes) {
        MemcachedNodesManager memcachedNodesManager = this.createMemcachedNodesManager(memcachedNodes, failoverNodes);
        MemcachedClient memcachedClient = this.createMemcachedClient(memcachedNodesManager, this._statistics);
        BackupSessionService backupSessionService = new BackupSessionService(this._transcoderService, this._sessionBackupAsync, this._sessionBackupTimeout, this._backupThreadCount, memcachedClient, memcachedNodesManager, this._statistics);
        if (this._memcached != null) {
            this._memcached.shutdown();
        }
        this._memcached = memcachedClient;
        this._memcachedNodesManager = memcachedNodesManager;
        this._backupSessionService = backupSessionService;
        this.initNonStickyLockingMode(memcachedNodesManager);
        return memcachedNodesManager;
    }

    public void setFailoverNodes(String failoverNodes) {
        if (this._manager.isInitialized()) {
            MemcachedNodesManager config = this.reloadMemcachedConfig(this._memcachedNodes, failoverNodes);
            this._log.info((Object)("Loaded new memcached failover node configuration.\n- Former failover config: " + this._failoverNodes + "\n- New failover config: " + failoverNodes + "\n- New node ids: " + config.getPrimaryNodeIds() + "\n- New failover node ids: " + config.getFailoverNodeIds()));
        }
        this._failoverNodes = failoverNodes;
    }

    public String getFailoverNodes() {
        return this._failoverNodes;
    }

    public void setRequestUriIgnorePattern(String requestUriIgnorePattern) {
        this._requestUriIgnorePattern = requestUriIgnorePattern;
    }

    @CheckForNull
    Pattern getSessionAttributePattern() {
        return this._sessionAttributePattern;
    }

    @CheckForNull
    public String getSessionAttributeFilter() {
        return this._sessionAttributeFilter;
    }

    public void setSessionAttributeFilter(@Nullable String sessionAttributeFilter) {
        if (sessionAttributeFilter == null || sessionAttributeFilter.trim().equals("")) {
            this._sessionAttributeFilter = null;
            this._sessionAttributePattern = null;
        } else {
            this._sessionAttributeFilter = sessionAttributeFilter;
            this._sessionAttributePattern = Pattern.compile(sessionAttributeFilter);
        }
    }

    public void setTranscoderFactoryClass(String transcoderFactoryClassName) {
        this._transcoderFactoryClassName = transcoderFactoryClassName;
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._copyCollectionsForSerialization = copyCollectionsForSerialization;
    }

    public void setCustomConverter(String customConverterClassNames) {
        this._customConverterClassNames = customConverterClassNames;
    }

    public void setEnableStatistics(boolean enableStatistics) {
        boolean oldEnableStatistics = this._enableStatistics;
        this._enableStatistics = enableStatistics;
        if (oldEnableStatistics != enableStatistics && this._manager.isInitialized()) {
            this._log.info((Object)("Changed enableStatistics from " + oldEnableStatistics + " to " + enableStatistics + "." + " Reloading configuration..."));
            this.reloadMemcachedConfig(this._memcachedNodes, this._failoverNodes);
        }
    }

    public void setBackupThreadCount(int backupThreadCount) {
        int oldBackupThreadCount = this._backupThreadCount;
        this._backupThreadCount = backupThreadCount;
        if (this._manager.isInitialized()) {
            this._log.info((Object)("Changed backupThreadCount from " + oldBackupThreadCount + " to " + this._backupThreadCount + "." + " Reloading configuration..."));
            this.reloadMemcachedConfig(this._memcachedNodes, this._failoverNodes);
            this._log.info((Object)"Finished reloading configuration.");
        }
    }

    public int getBackupThreadCount() {
        return this._backupThreadCount;
    }

    public void setMemcachedProtocol(String memcachedProtocol) {
        if (!PROTOCOL_TEXT.equals(memcachedProtocol) && !PROTOCOL_BINARY.equals(memcachedProtocol)) {
            this._log.warn((Object)("Illegal memcachedProtocol " + memcachedProtocol + ", using default (" + this._memcachedProtocol + ")."));
            return;
        }
        this._memcachedProtocol = memcachedProtocol;
    }

    public void setEnabled(boolean enabled) throws IllegalStateException {
        if (!enabled && !this._sticky) {
            throw new IllegalStateException("Disabling this session manager is not allowed in non-sticky mode. You must switch to sticky operation mode before.");
        }
        boolean changed = this._enabled.compareAndSet(!enabled, enabled);
        if (changed && this._manager.isInitialized()) {
            this.reloadMemcachedConfig(this._memcachedNodes, this._failoverNodes);
            this._log.info((Object)("Changed enabled status to " + enabled + "."));
        }
    }

    public boolean isEnabled() {
        return this._enabled.get();
    }

    public void setSticky(boolean sticky) {
        if (sticky == this._sticky) {
            return;
        }
        if (!sticky && this._manager.getJvmRoute() != null) {
            this._log.warn((Object)("Setting sticky to false while there's still a jvmRoute configured (" + this._manager.getJvmRoute() + "), this might cause trouble." + " You should remve the jvmRoute configuration for non-sticky mode."));
        }
        this._sticky = sticky;
        if (this._manager.isInitialized()) {
            this._log.info((Object)("Changed sticky to " + this._sticky + ". Reloading configuration..."));
            this.reloadMemcachedConfig(this._memcachedNodes, this._failoverNodes);
            this._log.info((Object)"Finished reloading configuration.");
        }
    }

    protected void setStickyInternal(boolean sticky) {
        this._sticky = sticky;
    }

    public boolean isSticky() {
        return this._sticky;
    }

    public void setLockingMode(@Nullable String lockingMode) {
        if (lockingMode == null && this._lockingMode == null || lockingMode != null && lockingMode.equals(this._lockingMode)) {
            return;
        }
        this._lockingMode = lockingMode;
        if (this._manager.isInitialized()) {
            this.initNonStickyLockingMode(this.createMemcachedNodesManager(this._memcachedNodes, this._failoverNodes));
        }
    }

    private void initNonStickyLockingMode(@Nonnull MemcachedNodesManager config) {
        if (this._sticky) {
            this.setLockingMode(null, null, false);
            return;
        }
        if (this._sessionAttributeFilter != null) {
            this._log.warn((Object)("There's a sessionAttributesFilter configured ('" + this._sessionAttributeFilter + "')," + " all other session attributes will be lost after the request due to non-sticky configuration!"));
        }
        Pattern uriPattern = null;
        LockingStrategy.LockingMode lockingMode = null;
        if (this._lockingMode != null) {
            if (this._lockingMode.startsWith("uriPattern:")) {
                lockingMode = LockingStrategy.LockingMode.URI_PATTERN;
                uriPattern = Pattern.compile(this._lockingMode.substring("uriPattern:".length()));
            } else {
                lockingMode = LockingStrategy.LockingMode.valueOf(this._lockingMode.toUpperCase());
            }
        }
        if (lockingMode == null) {
            lockingMode = LockingStrategy.LockingMode.NONE;
        }
        boolean storeSecondaryBackup = config.getCountNodes() > 1 && !config.isCouchbaseBucketConfig();
        this.setLockingMode(lockingMode, uriPattern, storeSecondaryBackup);
    }

    public void setLockingMode(@Nullable LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern, boolean storeSecondaryBackup) {
        this._log.info((Object)("Setting lockingMode to " + (Object)((Object)lockingMode) + (uriPattern != null ? " with pattern " + uriPattern.pattern() : "")));
        this._lockingStrategy = LockingStrategy.create(lockingMode, uriPattern, this._memcached, this, this._memcachedNodesManager, this._missingSessionsCache, storeSecondaryBackup, this._statistics, this._currentRequest);
    }

    protected void updateExpirationInMemcached() {
        if (this._enabled.get() && this._sticky) {
            Session[] sessions = this._manager.findSessions();
            int delay = this._manager.getContainer().getBackgroundProcessorDelay();
            for (Session s : sessions) {
                MemcachedBackupSession session = (MemcachedBackupSession)s;
                if (this._log.isDebugEnabled()) {
                    this._log.debug((Object)("Checking session " + session.getId() + ": " + "\n- isValid: " + session.isValidInternal() + "\n- isExpiring: " + session.isExpiring() + "\n- isBackupRunning: " + session.isBackupRunning() + "\n- isExpirationUpdateRunning: " + session.isExpirationUpdateRunning() + "\n- wasAccessedSinceLastBackup: " + session.wasAccessedSinceLastBackup() + "\n- memcachedExpirationTime: " + session.getMemcachedExpirationTime()));
                }
                if (!session.isValidInternal() || session.isExpiring() || session.isBackupRunning() || session.isExpirationUpdateRunning() || !session.wasAccessedSinceLastBackup() || session.getMaxInactiveInterval() <= 0 || session.getMemcachedExpirationTime() > 2 * delay) continue;
                try {
                    this._backupSessionService.updateExpiration(session);
                }
                catch (Throwable e) {
                    this._log.info((Object)("Could not update expiration in memcached for session " + session.getId()), e);
                }
            }
        }
    }

    public void setSessionBackupAsync(boolean sessionBackupAsync) {
        boolean oldSessionBackupAsync = this._sessionBackupAsync;
        this._sessionBackupAsync = sessionBackupAsync;
        if (oldSessionBackupAsync != sessionBackupAsync && this._manager.isInitialized()) {
            this._log.info((Object)("SessionBackupAsync was changed to " + sessionBackupAsync + ", creating new BackupSessionService with new configuration."));
            this._backupSessionService = new BackupSessionService(this._transcoderService, this._sessionBackupAsync, this._sessionBackupTimeout, this._backupThreadCount, this._memcached, this._memcachedNodesManager, this._statistics);
        }
    }

    public boolean isSessionBackupAsync() {
        return this._sessionBackupAsync;
    }

    public void setSessionBackupTimeout(int sessionBackupTimeout) {
        this._sessionBackupTimeout = sessionBackupTimeout;
    }

    public long getSessionBackupTimeout() {
        return this._sessionBackupTimeout;
    }

    public Statistics getStatistics() {
        return this._statistics;
    }

    public long getOperationTimeout() {
        return this._operationTimeout;
    }

    public void setOperationTimeout(long operationTimeout) {
        this._operationTimeout = operationTimeout;
    }

    void setTranscoderService(TranscoderService transcoderService) {
        this._transcoderService = transcoderService;
        this._backupSessionService = new BackupSessionService(transcoderService, this._sessionBackupAsync, this._sessionBackupTimeout, this._backupThreadCount, this._memcached, this._memcachedNodesManager, this._statistics);
    }

    @Nonnull
    MemcachedNodesManager getMemcachedNodesManager() {
        return this._memcachedNodesManager;
    }

    List<String> getNodeIds() {
        return this._memcachedNodesManager.getPrimaryNodeIds();
    }

    List<String> getFailoverNodeIds() {
        return this._memcachedNodesManager.getFailoverNodeIds();
    }

    public MemcachedClient getMemcached() {
        return this._memcached;
    }

    void setMemcachedClient(MemcachedClient memcachedClient) {
        this._memcached = memcachedClient;
    }

    RequestTrackingHostValve getTrackingHostValve() {
        return this._trackingHostValve;
    }

    @Nullable
    LockingStrategy getLockingStrategy() {
        return this._lockingStrategy;
    }

    public void setUsername(String username) {
        this._username = username;
    }

    public String getUsername() {
        return this._username;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public String getPassword() {
        return this._password;
    }

    public static interface SessionManager
    extends Manager {
        @Nonnull
        public String getSessionCookieName();

        public String[] getSetCookieHeaders(Response var1);

        public String generateSessionId();

        public void expireSession(String var1);

        public MemcachedBackupSession getSessionInternal(String var1);

        public Map<String, Session> getSessionsInternal();

        public String getJvmRoute();

        public String getString(String var1);

        public String getString(String var1, Object ... var2);

        public int getMaxActiveSessions();

        public void incrementSessionCounter();

        public void incrementRejectedSessions();

        public void removeInternal(Session var1, boolean var2);

        public boolean isInitialized();

        @Nonnull
        public MemcachedSessionService getMemcachedSessionService();

        @Nonnull
        public Container getContainer();

        @Nonnull
        public Principal readPrincipal(@Nonnull ObjectInputStream var1) throws ClassNotFoundException, IOException;

        public void setSticky(boolean var1);

        public void setEnabled(boolean var1);

        public void setOperationTimeout(long var1);

        public void setProcessExpiresFrequency(int var1);

        public void setMemcachedNodes(@Nonnull String var1);

        public void setFailoverNodes(String var1);

        public void setLockingMode(@Nullable String var1);

        public void setLockingMode(@Nullable LockingStrategy.LockingMode var1, @Nullable Pattern var2, boolean var3);

        public void setUsername(String var1);

        public void setPassword(String var1);

        @Nonnull
        public MemcachedBackupSession newMemcachedBackupSession();
    }

    static enum LockStatus {
        LOCK_NOT_REQUIRED,
        LOCKED,
        COULD_NOT_AQUIRE_LOCK;

    }
}

