/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.InvalidVersionException;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.SessionAttributesTranscoder;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Arrays;
import java.util.Map;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class TranscoderService {
    private static final Log LOG = LogFactory.getLog(TranscoderService.class);
    private static final short CURRENT_VERSION = 1;
    static final int NUM_BYTES = 38;
    private final SessionAttributesTranscoder _attributesTranscoder;

    public TranscoderService(SessionAttributesTranscoder attributesTranscoder) {
        this._attributesTranscoder = attributesTranscoder;
    }

    public byte[] serialize(MemcachedBackupSession session) {
        byte[] attributesData = this.serializeAttributes(session, session.getAttributesInternal());
        return this.serialize(session, attributesData);
    }

    public MemcachedBackupSession deserialize(byte[] data, MemcachedSessionService.SessionManager manager) {
        if (data == null) {
            return null;
        }
        try {
            DeserializationResult deserializationResult = TranscoderService.deserializeSessionFields(data, manager);
            byte[] attributesData = deserializationResult.getAttributesData();
            Map<String, Object> attributes = this.deserializeAttributes(attributesData);
            MemcachedBackupSession session = deserializationResult.getSession();
            session.setAttributesInternal(attributes);
            session.setDataHashCode(Arrays.hashCode(attributesData));
            session.setManager(manager);
            session.doAfterDeserialization();
            return session;
        }
        catch (InvalidVersionException e) {
            LOG.info((Object)("Got session data from memcached with an unsupported version: " + e.getVersion()));
            return null;
        }
    }

    public byte[] serializeAttributes(MemcachedBackupSession session, Map<String, Object> attributes) {
        return this._attributesTranscoder.serializeAttributes(session, attributes);
    }

    public Map<String, Object> deserializeAttributes(byte[] data) {
        return this._attributesTranscoder.deserializeAttributes(data);
    }

    public byte[] serialize(MemcachedBackupSession session, byte[] attributesData) {
        byte[] sessionData = TranscoderService.serializeSessionFields(session);
        byte[] result = new byte[sessionData.length + attributesData.length];
        System.arraycopy(sessionData, 0, result, 0, sessionData.length);
        System.arraycopy(attributesData, 0, result, sessionData.length, attributesData.length);
        return result;
    }

    static byte[] serializeSessionFields(MemcachedBackupSession session) {
        byte[] idData = TranscoderService.serializeId(session.getIdInternal());
        byte[] principalData = session.getPrincipal() != null ? TranscoderService.serializePrincipal(session.getPrincipal()) : null;
        int principalDataLength = principalData != null ? principalData.length : 0;
        int sessionFieldsDataLength = 44 + idData.length + 2 + 2 + principalDataLength;
        byte[] data = new byte[sessionFieldsDataLength];
        int idx = 0;
        idx = TranscoderService.encodeNum(1L, data, idx, 2);
        idx = TranscoderService.encodeNum(sessionFieldsDataLength, data, idx, 2);
        idx = TranscoderService.encodeNum(session.getCreationTimeInternal(), data, idx, 8);
        idx = TranscoderService.encodeNum(session.getLastAccessedTimeInternal(), data, idx, 8);
        idx = TranscoderService.encodeNum(session.getMaxInactiveInterval(), data, idx, 4);
        idx = TranscoderService.encodeBoolean(session.isNewInternal(), data, idx);
        idx = TranscoderService.encodeBoolean(session.isValidInternal(), data, idx);
        idx = TranscoderService.encodeNum(session.getThisAccessedTimeInternal(), data, idx, 8);
        idx = TranscoderService.encodeNum(session.getLastBackupTime(), data, idx, 8);
        idx = TranscoderService.encodeNum(idData.length, data, idx, 2);
        idx = TranscoderService.copy(idData, data, idx);
        idx = TranscoderService.encodeNum(AuthType.valueOfValue(session.getAuthType()).getId(), data, idx, 2);
        idx = TranscoderService.encodeNum(principalDataLength, data, idx, 2);
        TranscoderService.copy(principalData, data, idx);
        return data;
    }

    static DeserializationResult deserializeSessionFields(byte[] data, MemcachedSessionService.SessionManager manager) throws InvalidVersionException {
        MemcachedBackupSession result = manager.newMemcachedBackupSession();
        short version = (short)TranscoderService.decodeNum(data, 0, 2);
        if (version != 1) {
            throw new InvalidVersionException("The version " + version + " does not match the current version " + 1, version);
        }
        short sessionFieldsDataLength = (short)TranscoderService.decodeNum(data, 2, 2);
        result.setCreationTimeInternal(TranscoderService.decodeNum(data, 4, 8));
        result.setLastAccessedTimeInternal(TranscoderService.decodeNum(data, 12, 8));
        result.setMaxInactiveInterval((int)TranscoderService.decodeNum(data, 20, 4));
        result.setIsNewInternal(TranscoderService.decodeBoolean(data, 24));
        result.setIsValidInternal(TranscoderService.decodeBoolean(data, 25));
        result.setThisAccessedTimeInternal(TranscoderService.decodeNum(data, 26, 8));
        result.setLastBackupTime(TranscoderService.decodeNum(data, 34, 8));
        short idLength = (short)TranscoderService.decodeNum(data, 42, 2);
        result.setIdInternal(TranscoderService.decodeString(data, 44, idLength));
        short authTypeId = (short)TranscoderService.decodeNum(data, 44 + idLength, 2);
        result.setAuthTypeInternal(AuthType.valueOfId(authTypeId).getValue());
        int currentIdx = 44 + idLength + 2;
        short principalDataLength = (short)TranscoderService.decodeNum(data, currentIdx, 2);
        if (principalDataLength > 0) {
            byte[] principalData = new byte[principalDataLength];
            System.arraycopy(data, currentIdx + 2, principalData, 0, principalDataLength);
            result.setPrincipalInternal(TranscoderService.deserializePrincipal(principalData, manager));
        }
        byte[] attributesData = new byte[data.length - sessionFieldsDataLength];
        System.arraycopy(data, sessionFieldsDataLength, attributesData, 0, data.length - sessionFieldsDataLength);
        return new DeserializationResult(result, attributesData);
    }

    private static byte[] serializeId(String id) {
        try {
            return id.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] serializePrincipal(Principal principal) {
        byte[] byArray;
        ByteArrayOutputStream bos = null;
        ObjectOutputStream oos = null;
        try {
            bos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream(bos);
            SerializablePrincipal.writePrincipal((GenericPrincipal)((GenericPrincipal)principal), (ObjectOutput)oos);
            oos.flush();
            byArray = bos.toByteArray();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Non-serializable object", e);
            }
            catch (Throwable throwable) {
                TranscoderService.closeSilently(bos);
                TranscoderService.closeSilently(oos);
                throw throwable;
            }
        }
        TranscoderService.closeSilently(bos);
        TranscoderService.closeSilently(oos);
        return byArray;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Principal deserializePrincipal(byte[] data, MemcachedSessionService.SessionManager manager) {
        Principal principal;
        ByteArrayInputStream bis = null;
        ObjectInputStream ois = null;
        try {
            bis = new ByteArrayInputStream(data);
            ois = new ObjectInputStream(bis);
            principal = manager.readPrincipal(ois);
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("Could not deserialize principal", e);
                catch (ClassNotFoundException e2) {
                    throw new IllegalArgumentException("Could not deserialize principal", e2);
                }
            }
            catch (Throwable throwable) {
                TranscoderService.closeSilently(bis);
                TranscoderService.closeSilently(ois);
                throw throwable;
            }
        }
        TranscoderService.closeSilently(bis);
        TranscoderService.closeSilently(ois);
        return principal;
    }

    public static int encodeNum(long num, byte[] data, int beginIndex, int maxBytes) {
        for (int i = 0; i < maxBytes; ++i) {
            int pos = maxBytes - i - 1;
            int idx = beginIndex + pos;
            data[idx] = (byte)(num >> 8 * i & 0xFFL);
        }
        return beginIndex + maxBytes;
    }

    public static long decodeNum(byte[] data, int beginIndex, int numBytes) {
        long result = 0L;
        for (int i = 0; i < numBytes; ++i) {
            int b = data[beginIndex + i];
            result = result << 8 | (long)(b < 0 ? 256 + b : b);
        }
        return result;
    }

    private static int encodeBoolean(boolean b, byte[] data, int index) {
        data[index] = (byte)(b ? 49 : 48);
        return index + 1;
    }

    private static boolean decodeBoolean(byte[] in, int index) {
        return in[index] == 49;
    }

    private static String decodeString(byte[] data, int beginIndex, int length) {
        try {
            byte[] idData = new byte[length];
            System.arraycopy(data, beginIndex, idData, 0, length);
            return new String(idData, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    protected static int copy(byte[] src, byte[] dest, int destBeginIndex) {
        if (src == null) {
            return destBeginIndex;
        }
        System.arraycopy(src, 0, dest, destBeginIndex, src.length);
        return destBeginIndex + src.length;
    }

    private static void closeSilently(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static void closeSilently(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static enum AuthType {
        NONE(0, null),
        BASIC(1, "BASIC"),
        CLIENT_CERT(2, "CLIENT_CERT"),
        DIGEST(3, "DIGEST"),
        FORM(4, "FORM");

        private final short _id;
        private final String _value;

        private AuthType(short id, String value) {
            this._id = id;
            this._value = value;
        }

        static AuthType valueOfId(short id) {
            for (AuthType authType : AuthType.values()) {
                if (id != authType._id) continue;
                return authType;
            }
            throw new IllegalArgumentException("No AuthType found for id " + id);
        }

        static AuthType valueOfValue(String value) {
            for (AuthType authType : AuthType.values()) {
                if ((value != null || authType._value != null) && (value == null || !value.equals(authType._value))) continue;
                return authType;
            }
            throw new IllegalArgumentException("No AuthType found for value " + value);
        }

        short getId() {
            return this._id;
        }

        String getValue() {
            return this._value;
        }
    }

    static class DeserializationResult {
        private final MemcachedBackupSession _session;
        private final byte[] _attributesData;

        DeserializationResult(MemcachedBackupSession session, byte[] attributesData) {
            this._session = session;
            this._attributesData = attributesData;
        }

        MemcachedBackupSession getSession() {
            return this._session;
        }

        byte[] getAttributesData() {
            return this._attributesData;
        }
    }
}

