/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.BackupSessionTask;
import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.Statistics;
import java.io.IOException;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import org.apache.catalina.Context;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

abstract class SessionTrackerValve
extends ValveBase {
    static final String RELOCATE = "session.relocate";
    protected static final Log _log = LogFactory.getLog(SessionTrackerValve.class);
    private final Pattern _ignorePattern;
    private final SessionBackupService _sessionBackupService;
    private final Statistics _statistics;
    private final AtomicBoolean _enabled;
    protected final String _sessionCookieName;
    @CheckForNull
    private LockingStrategy _lockingStrategy;

    public SessionTrackerValve(@Nullable String ignorePattern, @Nonnull Context context, @Nonnull SessionBackupService sessionBackupService, @Nonnull Statistics statistics, @Nonnull AtomicBoolean enabled) {
        if (ignorePattern != null) {
            _log.info((Object)("Setting ignorePattern to " + ignorePattern));
            this._ignorePattern = Pattern.compile(ignorePattern);
        } else {
            this._ignorePattern = null;
        }
        this._sessionBackupService = sessionBackupService;
        this._statistics = statistics;
        this._enabled = enabled;
        this._sessionCookieName = this.getSessionCookieName(context);
    }

    @Nonnull
    protected abstract String getSessionCookieName(Context var1);

    protected String getSessionCookieName() {
        return this._sessionCookieName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invoke(Request request, Response response) throws IOException, ServletException {
        if (!this._enabled.get() || this._ignorePattern != null && this._ignorePattern.matcher(request.getRequestURI()).matches()) {
            this.getNext().invoke(request, response);
        } else {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(">>>>>> Request starting: " + SessionTrackerValve.getURIWithQueryString(request) + " =================="));
            }
            boolean sessionIdChanged = false;
            try {
                this.storeRequestThreadLocal(request);
                sessionIdChanged = this.changeRequestedSessionId(request, response);
                this.getNext().invoke(request, response);
            }
            finally {
                this.backupSession(request, response, sessionIdChanged);
                this.resetRequestThreadLocal();
            }
            if (_log.isDebugEnabled()) {
                this.logDebugRequestSessionCookie(request);
                this.logDebugResponseCookie(response);
                _log.debug((Object)("<<<<<< Request finished: " + SessionTrackerValve.getURIWithQueryString(request) + " =================="));
            }
        }
    }

    protected void logDebugRequestSessionCookie(Request request) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (!cookie.getName().equals(this._sessionCookieName)) continue;
            _log.debug((Object)("Have request session cookie: domain=" + cookie.getDomain() + ", maxAge=" + cookie.getMaxAge() + ", path=" + cookie.getPath() + ", value=" + cookie.getValue() + ", version=" + cookie.getVersion() + ", secure=" + cookie.getSecure()));
        }
    }

    @Nonnull
    protected static String getURIWithQueryString(@Nonnull Request request) {
        String uri = request.getRequestURI();
        String qs = SessionTrackerValve.isPostMethod(request) ? null : request.getQueryString();
        return qs != null ? uri + "?" + qs : uri;
    }

    protected static boolean isPostMethod(Request request) {
        String method = request.getMethod();
        if (method == null && _log.isDebugEnabled()) {
            _log.debug((Object)("No method set for request " + request.getRequestURI() + (request.getQueryString() != null ? "?" + request.getQueryString() : "")));
        }
        return method != null ? method.toLowerCase().equals("post") : false;
    }

    private void resetRequestThreadLocal() {
        if (this._lockingStrategy != null) {
            this._lockingStrategy.onRequestFinished();
        }
    }

    private void storeRequestThreadLocal(@Nonnull Request request) {
        if (this._lockingStrategy != null) {
            this._lockingStrategy.onRequestStart(request);
        }
    }

    private boolean changeRequestedSessionId(Request request, Response response) {
        if (request.getRequestedSessionId() != null) {
            String newSessionId = this._sessionBackupService.changeSessionIdOnTomcatFailover(request.getRequestedSessionId());
            if (newSessionId == null) {
                newSessionId = this._sessionBackupService.changeSessionIdOnMemcachedFailover(request.getRequestedSessionId());
            }
            if (newSessionId != null) {
                request.changeSessionId(newSessionId);
                return true;
            }
        }
        return false;
    }

    private void backupSession(Request request, Response response, boolean sessionIdChanged) {
        String sessionId = this.getSessionIdFromResponseSessionCookie(response);
        if (sessionId == null) {
            sessionId = request.getRequestedSessionId();
        }
        if (sessionId != null) {
            this._statistics.requestWithSession();
            this._sessionBackupService.backupSession(sessionId, sessionIdChanged, SessionTrackerValve.getURIWithQueryString(request));
        } else {
            this._statistics.requestWithoutSession();
        }
    }

    private String getSessionIdFromResponseSessionCookie(Response response) {
        String header = response.getHeader("Set-Cookie");
        if (header != null && header.contains(this._sessionCookieName)) {
            String sessionIdPrefix = this._sessionCookieName + "=";
            int idxNameStart = header.indexOf(sessionIdPrefix);
            int idxValueStart = idxNameStart + sessionIdPrefix.length();
            int idxValueEnd = header.indexOf(59, idxNameStart);
            if (idxValueEnd == -1) {
                idxValueEnd = header.indexOf(32, idxValueStart);
            }
            if (idxValueEnd == -1) {
                idxValueEnd = header.length();
            }
            return header.substring(idxValueStart, idxValueEnd);
        }
        return null;
    }

    private void logDebugResponseCookie(Response response) {
        String header = response.getHeader("Set-Cookie");
        if (header != null && header.contains(this._sessionCookieName)) {
            _log.debug((Object)("Request finished, with Set-Cookie header: " + header));
        }
    }

    public void setLockingStrategy(@Nullable LockingStrategy lockingStrategy) {
        this._lockingStrategy = lockingStrategy;
    }

    public static interface SessionBackupService {
        public String changeSessionIdOnTomcatFailover(String var1);

        public String changeSessionIdOnMemcachedFailover(String var1);

        public Future<BackupSessionTask.BackupResult> backupSession(@Nonnull String var1, boolean var2, String var3);

        public static enum BackupResultStatus {
            SUCCESS,
            FAILURE,
            SKIPPED;

        }
    }
}

