/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.NodeIdList;
import de.javakaffee.web.msm.NodeIdResolver;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixBasedNodeLocator;
import de.javakaffee.web.msm.TranscoderWrapperStatisticsSupport;
import java.net.SocketAddress;
import java.nio.channels.SocketChannel;
import java.util.List;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.OperationFactory;
import net.spy.memcached.protocol.binary.BinaryMemcachedNodeImpl;
import net.spy.memcached.protocol.binary.BinaryOperationFactory;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

public final class SuffixLocatorBinaryConnectionFactory
extends DefaultConnectionFactory {
    private final NodeIdList _nodeIds;
    private final SessionIdFormat _sessionIdFormat;
    private final NodeIdResolver _resolver;
    private final Statistics _statistics;

    public SuffixLocatorBinaryConnectionFactory(NodeIdList nodeIds, NodeIdResolver resolver, SessionIdFormat sessionIdFormat, Statistics statistics) {
        this._nodeIds = nodeIds;
        this._resolver = resolver;
        this._sessionIdFormat = sessionIdFormat;
        this._statistics = statistics;
    }

    public FailureMode getFailureMode() {
        return FailureMode.Cancel;
    }

    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new SuffixBasedNodeLocator(nodes, this._nodeIds, this._resolver, this._sessionIdFormat);
    }

    public Transcoder<Object> getDefaultTranscoder() {
        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(16384);
        return new TranscoderWrapperStatisticsSupport(this._statistics, (Transcoder<Object>)transcoder);
    }

    public MemcachedNode createMemcachedNode(SocketAddress sa, SocketChannel c, int bufSize) {
        boolean doAuth = false;
        return new BinaryMemcachedNodeImpl(sa, c, bufSize, this.createReadOperationQueue(), this.createWriteOperationQueue(), this.createOperationQueue(), Long.valueOf(this.getOpQueueMaxBlockTime()), false);
    }

    public OperationFactory getOperationFactory() {
        return new BinaryOperationFactory();
    }
}

