/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedSessionService;
import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.apache.catalina.Manager;
import org.apache.catalina.Session;
import org.apache.catalina.session.StandardSession;

public class MemcachedBackupSession
extends StandardSession {
    private static final long serialVersionUID = 1L;
    private transient int _dataHashCode;
    private transient long _thisAccessedTimeFromLastBackupCheck;
    protected long _lastBackupTime;
    private transient long _previousLastBackupTime;
    private transient int _lastMemcachedExpirationTime;
    private volatile transient boolean _expirationUpdateRunning;
    private volatile transient boolean _backupRunning;
    private transient boolean _authenticationChanged;
    @SuppressWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private transient boolean _attributesAccessed;
    private transient boolean _sessionIdChanged;
    protected transient boolean _sticky;
    private volatile transient MemcachedSessionService.LockStatus _lockStatus;

    public MemcachedBackupSession() {
        super(null);
    }

    public MemcachedBackupSession(MemcachedSessionService.SessionManager manager) {
        super((Manager)manager);
    }

    public Object getAttribute(String name) {
        if (this.filterAttribute(name)) {
            this._attributesAccessed = true;
        }
        return super.getAttribute(name);
    }

    public void setAttribute(String name, Object value) {
        if (this.filterAttribute(name)) {
            this._attributesAccessed = true;
        }
        super.setAttribute(name, value);
    }

    public void setAttribute(String name, Object value, boolean notify) {
        if (this.filterAttribute(name)) {
            this._attributesAccessed = true;
        }
        super.setAttribute(name, value, notify);
    }

    public void recycle() {
        super.recycle();
        this._dataHashCode = 0;
        this._expirationUpdateRunning = false;
        this._backupRunning = false;
        this._lockStatus = null;
    }

    private boolean filterAttribute(String name) {
        if (this.manager == null) {
            throw new IllegalStateException("There's no manager set.");
        }
        Pattern pattern = ((MemcachedSessionService.SessionManager)this.manager).getMemcachedSessionService().getSessionAttributePattern();
        if (pattern == null) {
            return true;
        }
        return pattern.matcher(name).matches();
    }

    int getMemcachedExpirationTimeToSet() {
        if (this.maxInactiveInterval <= 0) {
            return 0;
        }
        if (!this._sticky) {
            return 2 * this.maxInactiveInterval;
        }
        long timeIdleInMillis = System.currentTimeMillis() - this.getThisAccessedTimeInternal();
        int timeIdle = Math.round((float)timeIdleInMillis / 1000.0f);
        int expirationTime = this.getMaxInactiveInterval() - timeIdle;
        return expirationTime;
    }

    int getMemcachedExpirationTime() {
        if (!this._sticky) {
            throw new IllegalStateException("The memcached expiration time cannot be determined in non-sticky mode.");
        }
        if (this._lastMemcachedExpirationTime == 0) {
            return 0;
        }
        long timeIdleInMillis = this._lastBackupTime == 0L ? 0L : System.currentTimeMillis() - this._lastBackupTime;
        int timeIdle = Math.round((float)timeIdleInMillis / 1000.0f);
        int expirationTime = this._lastMemcachedExpirationTime - timeIdle;
        return expirationTime;
    }

    void setLastBackupTime(long lastBackupTime) {
        this._previousLastBackupTime = this._lastBackupTime;
        this._lastBackupTime = lastBackupTime;
    }

    long getLastBackupTime() {
        return this._lastBackupTime;
    }

    int getSecondsSinceLastBackup() {
        long timeNotUpdatedInMemcachedInMillis = System.currentTimeMillis() - this._lastBackupTime;
        return Math.round((float)timeNotUpdatedInMemcachedInMillis / 1000.0f);
    }

    int getLastMemcachedExpirationTime() {
        return this._lastMemcachedExpirationTime;
    }

    void setLastMemcachedExpirationTime(int lastMemcachedExpirationTime) {
        this._lastMemcachedExpirationTime = lastMemcachedExpirationTime;
    }

    boolean wasAccessedSinceLastBackup() {
        return this.thisAccessedTime > this._lastBackupTime;
    }

    @Deprecated
    void storeThisAccessedTimeFromLastBackupCheck() {
        this._thisAccessedTimeFromLastBackupCheck = this.thisAccessedTime;
    }

    @Deprecated
    boolean wasAccessedSinceLastBackupCheck() {
        return this._thisAccessedTimeFromLastBackupCheck != this.thisAccessedTime;
    }

    boolean attributesAccessedSinceLastBackup() {
        return this._attributesAccessed;
    }

    boolean isExpirationUpdateRunning() {
        return this._expirationUpdateRunning;
    }

    void setExpirationUpdateRunning(boolean expirationUpdateRunning) {
        this._expirationUpdateRunning = expirationUpdateRunning;
    }

    boolean isBackupRunning() {
        return this._backupRunning;
    }

    void setBackupRunning(boolean backupRunning) {
        this._backupRunning = backupRunning;
    }

    protected void setIdForRelocate(String id) {
        if (this.id == null) {
            throw new IllegalStateException("There's no session id set.");
        }
        if (this.manager == null) {
            throw new IllegalStateException("There's no manager set.");
        }
        this.setNote("node.failure", Boolean.TRUE);
        this.manager.remove((Session)this);
        this.removeNote("node.failure");
        this.id = id;
        this.manager.add((Session)this);
    }

    public void doAfterDeserialization() {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (this.notes == null) {
            this.notes = new ConcurrentHashMap();
        }
    }

    int getDataHashCode() {
        return this._dataHashCode;
    }

    void setDataHashCode(int attributesDataHashCode) {
        this._dataHashCode = attributesDataHashCode;
    }

    public long getCreationTimeInternal() {
        return this.creationTime;
    }

    void setCreationTimeInternal(long creationTime) {
        this.creationTime = creationTime;
    }

    boolean isNewInternal() {
        return this.isNew;
    }

    void setIsNewInternal(boolean isNew) {
        this.isNew = isNew;
    }

    public boolean isValidInternal() {
        return this.isValid;
    }

    void setIsValidInternal(boolean isValid) {
        this.isValid = isValid;
    }

    public long getThisAccessedTimeInternal() {
        return this.thisAccessedTime;
    }

    void setThisAccessedTimeInternal(long thisAccessedTime) {
        this.thisAccessedTime = thisAccessedTime;
    }

    void setLastAccessedTimeInternal(long lastAccessedTime) {
        this.lastAccessedTime = lastAccessedTime;
    }

    void setIdInternal(String id) {
        this.id = id;
    }

    boolean isExpiring() {
        return this.expiring;
    }

    public Map<String, Object> getAttributesInternal() {
        return this.attributes;
    }

    public Map<String, Object> getAttributesFiltered() {
        if (this.manager == null) {
            throw new IllegalStateException("There's no manager set.");
        }
        Pattern pattern = ((MemcachedSessionService.SessionManager)this.manager).getMemcachedSessionService().getSessionAttributePattern();
        if (pattern == null) {
            return this.attributes;
        }
        ConcurrentHashMap<String, Object> result = new ConcurrentHashMap<String, Object>(this.attributes.size());
        for (Map.Entry entry : this.attributes.entrySet()) {
            if (!pattern.matcher((CharSequence)entry.getKey()).matches()) continue;
            result.put((String)entry.getKey(), entry.getValue());
        }
        return result;
    }

    void setAttributesInternal(Map<String, Object> attributes) {
        this.attributes = attributes;
    }

    public void removeAttributeInternal(String name, boolean notify) {
        super.removeAttributeInternal(name, notify);
    }

    protected boolean exclude(String name) {
        return super.exclude(name);
    }

    boolean authenticationChanged() {
        return this._authenticationChanged;
    }

    public void setAuthType(String authType) {
        if (!MemcachedBackupSession.equals(authType, this.authType)) {
            this._authenticationChanged = true;
        }
        super.setAuthType(authType);
    }

    public void setAuthTypeInternal(String authType) {
        super.setAuthType(authType);
    }

    public void setPrincipal(Principal principal) {
        if (!MemcachedBackupSession.equals(principal, this.principal)) {
            this._authenticationChanged = true;
        }
        super.setPrincipal(principal);
    }

    public void setPrincipalInternal(Principal principal) {
        super.setPrincipal(principal);
    }

    private static boolean equals(Object one, Object another) {
        return one == null && another == null || one != null && one.equals(another);
    }

    public void backupFinished() {
        this._authenticationChanged = false;
        this._attributesAccessed = false;
        this._sessionIdChanged = false;
    }

    public boolean isSessionIdChanged() {
        return this._sessionIdChanged;
    }

    public void setSessionIdChanged(boolean sessionIdChanged) {
        this._sessionIdChanged = sessionIdChanged;
    }

    public void backupFailed() {
        this._lastBackupTime = this._previousLastBackupTime;
    }

    public void setSticky(boolean sticky) {
        this._sticky = sticky;
    }

    public boolean isSticky() {
        return this._sticky;
    }

    public MemcachedSessionService.LockStatus getLockStatus() {
        return this._lockStatus;
    }

    public void setLockStatus(MemcachedSessionService.LockStatus locked) {
        this._lockStatus = locked;
    }

    public synchronized boolean isLocked() {
        return this._lockStatus == MemcachedSessionService.LockStatus.LOCKED;
    }

    public void releaseLock() {
        this._lockStatus = null;
    }
}

