/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.LockingStrategy;
import de.javakaffee.web.msm.MemcachedBackupSession;
import de.javakaffee.web.msm.MemcachedSessionService;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.storage.StorageClient;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.lang.reflect.Method;
import java.security.Principal;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.catalina.Container;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.Realm;
import org.apache.catalina.Session;
import org.apache.catalina.connector.Response;
import org.apache.catalina.deploy.LoginConfig;
import org.apache.catalina.deploy.SecurityConstraint;
import org.apache.catalina.ha.session.SerializablePrincipal;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.catalina.session.ManagerBase;
import org.apache.catalina.session.StandardSession;
import org.apache.catalina.util.LifecycleSupport;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class MemcachedBackupSessionManager
extends ManagerBase
implements Lifecycle,
PropertyChangeListener,
MemcachedSessionService.SessionManager {
    protected static final String NAME = MemcachedBackupSessionManager.class.getSimpleName();
    private static final String INFO = NAME + "/1.0";
    protected final Log _log = LogFactory.getLog(this.getClass());
    private final LifecycleSupport _lifecycle = new LifecycleSupport((Lifecycle)this);
    private Integer _maxInactiveInterval;
    private int _maxActiveSessions = -1;
    private int _rejectedSessions;
    protected boolean _started = false;
    protected MemcachedSessionService _msm = new MemcachedSessionService((MemcachedSessionService.SessionManager)this);
    private Boolean _contextHasFormBasedSecurityConstraint;

    public String getInfo() {
        return INFO;
    }

    public String getName() {
        return NAME;
    }

    @Nonnull
    public Context getContext() {
        return (Context)this.getContainer();
    }

    protected void startInternal(StorageClient storageClient) throws LifecycleException {
        this._msm.setStorageClient(storageClient);
        this._msm.startInternal();
    }

    public void setContainer(Container container) {
        if (this.container != null && this.container instanceof Context) {
            ((Context)this.container).removePropertyChangeListener((PropertyChangeListener)this);
        }
        super.setContainer(container);
        if (this.container != null && this.container instanceof Context) {
            this.setMaxInactiveInterval(((Context)this.container).getSessionTimeout() * 60);
            ((Context)this.container).addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public String generateSessionId() {
        return this._msm.newSessionId(super.generateSessionId());
    }

    public void expireSession(String sessionId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("expireSession invoked: " + sessionId));
        }
        super.expireSession(sessionId);
        this._msm.deleteFromMemcached(sessionId);
    }

    public void remove(Session session) {
        this.remove(session, session.getNote("node.failure") != Boolean.TRUE);
    }

    public void removeInternal(Session session, boolean update) {
        super.remove(session);
    }

    private void remove(Session session, boolean removeFromMemcached) {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("remove invoked, removeFromMemcached: " + removeFromMemcached + ", id: " + session.getId()));
        }
        if (removeFromMemcached) {
            this._msm.deleteFromMemcached(session.getId());
        }
        super.remove(session);
        this._msm.sessionRemoved((MemcachedBackupSession)session);
    }

    public Session findSession(String id) throws IOException {
        return this._msm.findSession(id);
    }

    public MemcachedBackupSession createSession(String sessionId) {
        return this._msm.createSession(sessionId);
    }

    public MemcachedBackupSession createEmptySession() {
        return this._msm.createEmptySession();
    }

    public MemcachedBackupSession newMemcachedBackupSession() {
        return new MemcachedBackupSession((MemcachedSessionService.SessionManager)this);
    }

    public void changeSessionId(Session session) {
        super.changeSessionId(session);
        ((MemcachedBackupSession)session).setSessionIdChanged(true);
    }

    public boolean isMaxInactiveIntervalSet() {
        return this._maxInactiveInterval != null;
    }

    public int getMaxInactiveInterval() {
        return this._maxInactiveInterval;
    }

    public void setMaxInactiveInterval(int interval) {
        Integer oldMaxInactiveInterval = this._maxInactiveInterval;
        this._maxInactiveInterval = interval;
        this.support.firePropertyChange("maxInactiveInterval", oldMaxInactiveInterval, this._maxInactiveInterval);
    }

    public void setMaxActiveSessions(int max) {
        int oldMaxActiveSessions = this._maxActiveSessions;
        this._maxActiveSessions = max;
        this.support.firePropertyChange("maxActiveSessions", (Object)oldMaxActiveSessions, (Object)this._maxActiveSessions);
    }

    public int getMaxActiveSessions() {
        return this._maxActiveSessions;
    }

    public void setRejectedSessions(int rejectedSessions) {
        this._rejectedSessions = rejectedSessions;
    }

    public int getRejectedSessions() {
        return this._rejectedSessions;
    }

    public void load() throws ClassNotFoundException, IOException {
    }

    public void unload() throws IOException {
    }

    public void setMemcachedNodes(String memcachedNodes) {
        this._msm.setMemcachedNodes(memcachedNodes);
    }

    public String getMemcachedNodes() {
        return this._msm.getMemcachedNodes();
    }

    public void setFailoverNodes(String failoverNodes) {
        this._msm.setFailoverNodes(failoverNodes);
    }

    public String getFailoverNodes() {
        return this._msm.getFailoverNodes();
    }

    public void setRequestUriIgnorePattern(String requestUriIgnorePattern) {
        this._msm.setRequestUriIgnorePattern(requestUriIgnorePattern);
    }

    @CheckForNull
    Pattern getSessionAttributePattern() {
        return this._msm.getSessionAttributePattern();
    }

    @CheckForNull
    public String getSessionAttributeFilter() {
        return this._msm.getSessionAttributeFilter();
    }

    public void setSessionAttributeFilter(@Nullable String sessionAttributeFilter) {
        this._msm.setSessionAttributeFilter(sessionAttributeFilter);
    }

    public void setTranscoderFactoryClass(String transcoderFactoryClassName) {
        this._msm.setTranscoderFactoryClass(transcoderFactoryClassName);
    }

    public void setCopyCollectionsForSerialization(boolean copyCollectionsForSerialization) {
        this._msm.setCopyCollectionsForSerialization(copyCollectionsForSerialization);
    }

    public void setCustomConverter(String customConverterClassNames) {
        this._msm.setCustomConverter(customConverterClassNames);
    }

    public void setEnableStatistics(boolean enableStatistics) {
        this._msm.setEnableStatistics(enableStatistics);
    }

    public void setBackupThreadCount(int backupThreadCount) {
        this._msm.setBackupThreadCount(backupThreadCount);
    }

    public int getBackupThreadCount() {
        return this._msm.getBackupThreadCount();
    }

    public void setMemcachedProtocol(String memcachedProtocol) {
        this._msm.setMemcachedProtocol(memcachedProtocol);
    }

    public void setEnabled(boolean enabled) throws IllegalStateException {
        this._msm.setEnabled(enabled);
    }

    public boolean isEnabled() {
        return this._msm.isEnabled();
    }

    public void setSticky(boolean sticky) {
        this._msm.setSticky(sticky);
    }

    public boolean isSticky() {
        return this._msm.isSticky();
    }

    public void setOperationTimeout(long operationTimeout) {
        this._msm.setOperationTimeout(operationTimeout);
    }

    public long getOperationTimeout() {
        return this._msm.getOperationTimeout();
    }

    public void setLockExpiration(int lockExpiration) {
        this._msm.setLockExpiration(lockExpiration);
    }

    public void setLockingMode(@Nullable String lockingMode) {
        this._msm.setLockingMode(lockingMode);
    }

    public void setLockingMode(@Nullable LockingStrategy.LockingMode lockingMode, @Nullable Pattern uriPattern, boolean storeSecondaryBackup) {
        this._msm.setLockingMode(lockingMode, uriPattern, storeSecondaryBackup);
    }

    public void setUsername(String username) {
        this._msm.setUsername(username);
    }

    public void setPassword(String password) {
        this._msm.setPassword(password);
    }

    public void setStorageKeyPrefix(String storageKeyPrefix) {
        this._msm.setStorageKeyPrefix(storageKeyPrefix);
    }

    public void addLifecycleListener(LifecycleListener arg0) {
        this._lifecycle.addLifecycleListener(arg0);
    }

    public LifecycleListener[] findLifecycleListeners() {
        return this._lifecycle.findLifecycleListeners();
    }

    public void removeLifecycleListener(LifecycleListener arg0) {
        this._lifecycle.removeLifecycleListener(arg0);
    }

    public void start() throws LifecycleException {
        if (!this.initialized) {
            this.init();
        }
        if (this._started) {
            return;
        }
        this._lifecycle.fireLifecycleEvent("start", null);
        this._started = true;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization starting");
        }
        super.generateSessionId();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Force random number initialization completed");
        }
        this.startInternal(null);
    }

    public void stop() throws LifecycleException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)"Stopping");
        }
        if (!this._started) {
            throw new LifecycleException(sm.getString("standardManager.notStarted"));
        }
        this._lifecycle.fireLifecycleEvent("stop", null);
        this._started = false;
        this.random = null;
        if (this.initialized) {
            if (this._msm.isSticky()) {
                this._log.info((Object)"Removing sessions from local session map.");
                for (Session session : this.sessions.values()) {
                    this.swapOut((StandardSession)session);
                }
            }
            this._msm.shutdown();
            this.destroy();
        }
    }

    private void swapOut(@Nonnull StandardSession session) {
        if (!session.isValid()) {
            return;
        }
        session.passivate();
        this.remove((Session)session, false);
        session.recycle();
    }

    public void backgroundProcess() {
        this._msm.updateExpirationInMemcached();
        super.backgroundProcess();
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (!(event.getSource() instanceof Context)) {
            return;
        }
        if (event.getPropertyName().equals("sessionTimeout")) {
            try {
                this.setMaxInactiveInterval((Integer)event.getNewValue() * 60);
            }
            catch (NumberFormatException e) {
                this._log.warn((Object)("standardManager.sessionTimeout: " + event.getNewValue().toString()));
            }
        }
    }

    public void setSessionBackupAsync(boolean sessionBackupAsync) {
        this._msm.setSessionBackupAsync(sessionBackupAsync);
    }

    public boolean isSessionBackupAsync() {
        return this._msm.isSessionBackupAsync();
    }

    public void setSessionBackupTimeout(int sessionBackupTimeout) {
        this._msm.setSessionBackupTimeout(sessionBackupTimeout);
    }

    public long getSessionBackupTimeout() {
        return this._msm.getSessionBackupTimeout();
    }

    public long getMsmStatNumBackupFailures() {
        return this._msm.getStatistics().getRequestsWithBackupFailure();
    }

    public long getMsmStatNumTomcatFailover() {
        return this._msm.getStatistics().getRequestsWithTomcatFailover();
    }

    public long getMsmStatNumMemcachedFailover() {
        return this._msm.getStatistics().getRequestsWithMemcachedFailover();
    }

    public long getMsmStatNumRequestsWithoutSession() {
        return this._msm.getStatistics().getRequestsWithoutSession();
    }

    public long getMsmStatNumNoSessionAccess() {
        return this._msm.getStatistics().getRequestsWithoutSessionAccess();
    }

    public long getMsmStatNumNoAttributesAccess() {
        return this._msm.getStatistics().getRequestsWithoutAttributesAccess();
    }

    public long getMsmStatNumNoSessionModification() {
        return this._msm.getStatistics().getRequestsWithoutSessionModification();
    }

    public long getMsmStatNumRequestsWithSession() {
        return this._msm.getStatistics().getRequestsWithSession();
    }

    public long getMsmStatNumNonStickySessionsPingFailed() {
        return this._msm.getStatistics().getNonStickySessionsPingFailed();
    }

    public long getMsmStatNumNonStickySessionsReadOnlyRequest() {
        return this._msm.getStatistics().getNonStickySessionsReadOnlyRequest();
    }

    public String[] getMsmStatAttributesSerializationInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ATTRIBUTES_SERIALIZATION).getInfo();
    }

    public String[] getMsmStatEffectiveBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.EFFECTIVE_BACKUP).getInfo();
    }

    public String[] getMsmStatBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.BACKUP).getInfo();
    }

    public String[] getMsmStatSessionsLoadedFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.LOAD_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatSessionsDeletedFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.DELETE_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatSessionDeserializationInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.SESSION_DESERIALIZATION).getInfo();
    }

    public String[] getMsmStatCachedDataSizeInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.CACHED_DATA_SIZE).getInfo();
    }

    public String[] getMsmStatMemcachedUpdateInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.MEMCACHED_UPDATE).getInfo();
    }

    public String[] getMsmStatNonStickyAcquireLockInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ACQUIRE_LOCK).getInfo();
    }

    public String[] getMsmStatNonStickyAcquireLockFailureInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.ACQUIRE_LOCK_FAILURE).getInfo();
    }

    public String[] getMsmStatNonStickyReleaseLockInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.RELEASE_LOCK).getInfo();
    }

    public String[] getMsmStatNonStickyOnBackupWithoutLoadedSessionInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_ON_BACKUP_WITHOUT_LOADED_SESSION).getInfo();
    }

    public String[] getMsmStatNonStickyAfterBackupInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_BACKUP).getInfo();
    }

    public String[] getMsmStatNonStickyAfterLoadFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_LOAD_FROM_MEMCACHED).getInfo();
    }

    public String[] getMsmStatNonStickyAfterDeleteFromMemcachedInfo() {
        return this._msm.getStatistics().getProbe(Statistics.StatsType.NON_STICKY_AFTER_DELETE_FROM_MEMCACHED).getInfo();
    }

    public String getSessionCookieName() {
        String result = this.getSessionCookieNameFromContext((Context)this.getContainer());
        if (result == null) {
            result = Globals.SESSION_COOKIE_NAME;
            this._log.debug((Object)("Using session cookie name from context: " + result));
        }
        return result;
    }

    @CheckForNull
    private String getSessionCookieNameFromContext(Context context) {
        try {
            Method getSessionCookieName = Context.class.getDeclaredMethod("getSessionCookieName", new Class[0]);
            String result = (String)getSessionCookieName.invoke((Object)context, new Object[0]);
            if (result != null) {
                this._log.debug((Object)("Using session cookie name from context: " + result));
            }
            return result;
        }
        catch (NoSuchMethodException getSessionCookieName) {
        }
        catch (Exception e) {
            throw new RuntimeException("Could not read session cookie name from context.", e);
        }
        return null;
    }

    public MemcachedBackupSession getSessionInternal(String sessionId) {
        return (MemcachedBackupSession)this.sessions.get(sessionId);
    }

    public Map<String, Session> getSessionsInternal() {
        return this.sessions;
    }

    public String getString(String key) {
        return sm.getString(key);
    }

    public void incrementSessionCounter() {
        ++this.sessionCounter;
    }

    public void incrementRejectedSessions() {
        ++this._rejectedSessions;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public String getString(String key, Object ... args) {
        return sm.getString(key, args);
    }

    public ClassLoader getContainerClassLoader() {
        return this.getContainer().getLoader().getClassLoader();
    }

    public void writePrincipal(@Nonnull Principal principal, @Nonnull ObjectOutputStream oos) throws IOException {
        SerializablePrincipal.writePrincipal((GenericPrincipal)((GenericPrincipal)principal), (ObjectOutput)oos);
    }

    public Principal readPrincipal(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        return SerializablePrincipal.readPrincipal((ObjectInput)ois, (Realm)this.getContainer().getRealm());
    }

    public boolean contextHasFormBasedSecurityConstraint() {
        if (this._contextHasFormBasedSecurityConstraint != null) {
            return this._contextHasFormBasedSecurityConstraint;
        }
        Context context = this.getContext();
        SecurityConstraint[] constraints = context.findConstraints();
        LoginConfig loginConfig = context.getLoginConfig();
        this._contextHasFormBasedSecurityConstraint = constraints != null && constraints.length > 0 && loginConfig != null && "FORM".equals(loginConfig.getAuthMethod());
        return this._contextHasFormBasedSecurityConstraint;
    }

    public MemcachedSessionService getMemcachedSessionService() {
        return this._msm;
    }

    public String[] getSetCookieHeaders(Response response) {
        return response.getHeaderValues("Set-Cookie");
    }
}

