/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io;

import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfReader;
import de.javagl.jgltf.model.io.GltfReferenceResolver;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.JsonError;
import de.javagl.jgltf.model.io.RawGltfData;
import de.javagl.jgltf.model.io.RawGltfDataReader;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.function.Consumer;

public final class GltfAssetReader {
    private Consumer<? super JsonError> jsonErrorConsumer;

    public void setJsonErrorConsumer(Consumer<? super JsonError> jsonErrorConsumer) {
        this.jsonErrorConsumer = jsonErrorConsumer;
    }

    public GltfAsset read(URI uri) throws IOException {
        try (InputStream inputStream = uri.toURL().openStream();){
            GltfAsset gltfAsset = this.readWithoutReferences(inputStream);
            URI baseUri = IO.getParent(uri);
            GltfReferenceResolver.resolveAll(gltfAsset.getReferences(), baseUri);
            GltfAsset gltfAsset2 = gltfAsset;
            return gltfAsset2;
        }
    }

    public GltfAsset read(Path path) throws IOException {
        try (InputStream inputStream = path.toUri().toURL().openStream();){
            GltfAsset gltfAsset = this.readWithoutReferences(inputStream);
            Path basePath = IO.getParent(path);
            GltfReferenceResolver.resolveAll(gltfAsset.getReferences(), basePath);
            GltfAsset gltfAsset2 = gltfAsset;
            return gltfAsset2;
        }
    }

    public GltfAsset readWithoutReferences(URI uri) throws IOException {
        try (InputStream inputStream = uri.toURL().openStream();){
            GltfAsset gltfAsset = this.readWithoutReferences(inputStream);
            return gltfAsset;
        }
    }

    public GltfAsset readWithoutReferences(InputStream inputStream) throws IOException {
        RawGltfData rawGltfData = RawGltfDataReader.read(inputStream);
        return this.read(rawGltfData);
    }

    GltfAsset read(RawGltfData rawGltfData) throws IOException {
        GltfReader gltfReader = new GltfReader();
        gltfReader.setJsonErrorConsumer(this.jsonErrorConsumer);
        ByteBuffer jsonData = rawGltfData.getJsonData();
        Throwable throwable = null;
        try (InputStream jsonInputStream = Buffers.createByteBufferInputStream(jsonData);){
            gltfReader.read(jsonInputStream);
            int majorVersion = gltfReader.getMajorVersion();
            if (majorVersion == 1) {
                de.javagl.jgltf.impl.v1.GlTF gltfV1 = gltfReader.getAsGltfV1();
                GltfAssetV1 gltfAssetV1 = new GltfAssetV1(gltfV1, rawGltfData.getBinaryData());
                return gltfAssetV1;
            }
            if (majorVersion == 2) {
                GlTF gltfV2 = gltfReader.getAsGltfV2();
                GltfAssetV2 gltfAssetV2 = new GltfAssetV2(gltfV2, rawGltfData.getBinaryData());
                return gltfAssetV2;
            }
            try {
                throw new IOException("Unsupported major version: " + majorVersion);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

