/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.LernaExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.Utils;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class LernaExecutor {
    private final ProcessExecutor executor;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public LernaExecutor(LernaExecutorConfig config, List<String> arguments, Map<String, String> additionalEnvironment) {
        String lerna = config.getLernaLocalInstallDirectoryPath() + "/lerna";
        String lerna2 = config.getLernaLocalInstallDirectoryPathAlt() + "/lerna";
        ArrayList<String> localPaths = new ArrayList<String>();
        localPaths.add(config.getYarnPath().getParent());
        localPaths.add(config.getNodePath().getParent());
        localPaths.add(config.getLernaLocalInstallDirectoryPath());
        localPaths.add(config.getLernaLocalInstallDirectoryPathAlt());
        for (String p : localPaths) {
            this.logger.info("add {} to PATH", (Object)p);
        }
        File f = new File(lerna);
        File f2 = new File(lerna2);
        this.executor = f.exists() ? new ProcessExecutor(config.getWorkingDirectory(), localPaths, Utils.prepend(lerna, arguments), config.getPlatform(), additionalEnvironment) : (f2.exists() ? new ProcessExecutor(config.getWorkingDirectory(), localPaths, Utils.prepend(lerna2, arguments), config.getPlatform(), additionalEnvironment) : new ProcessExecutor(config.getWorkingDirectory(), localPaths, Utils.prepend("lerna", arguments), config.getPlatform(), additionalEnvironment));
    }

    public String executeAndGetResult(Logger logger) throws ProcessExecutionException {
        return this.executor.executeAndGetResult(logger);
    }

    public int executeAndRedirectOutput(Logger logger) throws ProcessExecutionException {
        return this.executor.executeAndRedirectOutput(logger);
    }
}

