/*
 * Decompiled with CFR 0.152.
 */
package com.github.eirslett.maven.plugins.frontend.lib;

import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractionException;
import com.github.eirslett.maven.plugins.frontend.lib.ArchiveExtractor;
import com.github.eirslett.maven.plugins.frontend.lib.CacheDescriptor;
import com.github.eirslett.maven.plugins.frontend.lib.DownloadException;
import com.github.eirslett.maven.plugins.frontend.lib.FileDownloader;
import com.github.eirslett.maven.plugins.frontend.lib.InstallConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallLernaExecutorConfig;
import com.github.eirslett.maven.plugins.frontend.lib.InstallationException;
import com.github.eirslett.maven.plugins.frontend.lib.LernaExecutor;
import com.github.eirslett.maven.plugins.frontend.lib.ProcessExecutionException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LernaInstaller {
    public static final String INSTALL_PATH = "/node/lerna";
    public static final String DEFAULT_LERNA_DOWNLOAD_ROOT = "https://github.com/lerna/lerna/releases/download/";
    private static final Object LOCK = new Object();
    private static final String LERNA_ROOT_DIRECTORY = "dist";
    private String lernaVersion;
    private String lernaDownloadRoot;
    private String userName;
    private String password;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final InstallConfig config;
    private final ArchiveExtractor archiveExtractor;
    private final FileDownloader fileDownloader;

    LernaInstaller(InstallConfig config, ArchiveExtractor archiveExtractor, FileDownloader fileDownloader) {
        this.config = config;
        this.archiveExtractor = archiveExtractor;
        this.fileDownloader = fileDownloader;
    }

    public LernaInstaller setLernaVersion(String lernaVersion) {
        this.lernaVersion = lernaVersion;
        return this;
    }

    public LernaInstaller setLernaDownloadRoot(String lernaDownloadRoot) {
        this.lernaDownloadRoot = lernaDownloadRoot;
        return this;
    }

    public LernaInstaller setUserName(String userName) {
        this.userName = userName;
        return this;
    }

    public LernaInstaller setPassword(String password) {
        this.password = password;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void install() throws InstallationException {
        Object object = LOCK;
        synchronized (object) {
            if (this.lernaDownloadRoot == null || this.lernaDownloadRoot.isEmpty()) {
                this.lernaDownloadRoot = DEFAULT_LERNA_DOWNLOAD_ROOT;
            }
            if (!this.lernaIsAlreadyInstalled()) {
                if (!this.lernaVersion.startsWith("v")) {
                    throw new InstallationException("Lerna version has to start with prefix 'v'.");
                }
                this.installLerna();
            }
        }
    }

    private boolean lernaIsAlreadyInstalled() {
        try {
            InstallLernaExecutorConfig executorConfig = new InstallLernaExecutorConfig(this.config);
            File nodeFile = executorConfig.getLernaPath();
            if (nodeFile.exists()) {
                String version = new LernaExecutor(executorConfig, Arrays.asList("--version"), null).executeAndGetResult(this.logger).trim();
                if (version.equals(this.lernaVersion.replaceFirst("^v", ""))) {
                    this.logger.info("Lerna {} is already installed.", (Object)version);
                    return true;
                }
                this.logger.info("Lerna {} was installed, but we need version {}", (Object)version, (Object)this.lernaVersion);
                return false;
            }
            return false;
        }
        catch (ProcessExecutionException e) {
            return false;
        }
    }

    private void installLerna() throws InstallationException {
        try {
            this.logger.info("Installing Lerna version {}", (Object)this.lernaVersion);
            String downloadUrl = this.lernaDownloadRoot + this.lernaVersion;
            String extension = "tar.gz";
            String fileending = "/lerna-" + this.lernaVersion + "." + extension;
            downloadUrl = downloadUrl + fileending;
            CacheDescriptor cacheDescriptor = new CacheDescriptor("lerna", this.lernaVersion, extension);
            File archive = this.config.getCacheResolver().resolve(cacheDescriptor);
            this.downloadFileIfMissing(downloadUrl, archive, this.userName, this.password);
            File installDirectory = this.getInstallDirectory();
            try {
                if (installDirectory.isDirectory()) {
                    FileUtils.deleteDirectory((File)installDirectory);
                }
            }
            catch (IOException e) {
                this.logger.warn("Failed to delete existing Lerna installation.");
            }
            this.extractFile(archive, installDirectory);
            this.ensureCorrectLernaRootDirectory(installDirectory, this.lernaVersion);
            this.logger.info("Installed Lerna locally.");
        }
        catch (DownloadException e) {
            throw new InstallationException("Could not download Lerna", e);
        }
        catch (ArchiveExtractionException | IOException e) {
            throw new InstallationException("Could not extract the Lerna archive", e);
        }
    }

    private File getInstallDirectory() {
        File installDirectory = new File(this.config.getInstallDirectory(), INSTALL_PATH);
        if (!installDirectory.exists()) {
            this.logger.debug("Creating install directory {}", (Object)installDirectory);
            installDirectory.mkdirs();
        }
        return installDirectory;
    }

    private void extractFile(File archive, File destinationDirectory) throws ArchiveExtractionException {
        this.logger.info("Unpacking {} into {}", (Object)archive, (Object)destinationDirectory);
        this.archiveExtractor.extract(archive.getPath(), destinationDirectory.getPath());
    }

    private void ensureCorrectLernaRootDirectory(File installDirectory, String lernaVersion) throws IOException {
        File lernaRootDirectory = new File(installDirectory, LERNA_ROOT_DIRECTORY);
        if (!lernaRootDirectory.exists()) {
            this.logger.debug("Lerna root directory not found, checking for lerna-{}", (Object)lernaVersion);
            File lernaOneXDirectory = new File(installDirectory, "lerna-" + lernaVersion);
            if (lernaOneXDirectory.isDirectory()) {
                if (!lernaOneXDirectory.renameTo(lernaRootDirectory)) {
                    throw new IOException("Could not rename versioned lerna root directory to dist");
                }
            } else {
                throw new FileNotFoundException("Could not find lerna distribution directory during extract");
            }
        }
    }

    private void downloadFileIfMissing(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        if (!destination.exists()) {
            this.downloadFile(downloadUrl, destination, userName, password);
        }
    }

    private void downloadFile(String downloadUrl, File destination, String userName, String password) throws DownloadException {
        this.logger.info("Downloading {} to {}", (Object)downloadUrl, (Object)destination);
        this.fileDownloader.download(downloadUrl, destination.getPath(), userName, password);
    }
}

