/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.converter;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import org.openscience.cdk.AtomContainer;
import org.openscience.cdk.interfaces.IAtomContainer;
import org.openscience.cdk.interfaces.IChemObject;
import org.openscience.cdk.io.MDLV3000Reader;
import org.openscience.cdk.io.MDLV3000Writer;

@FacesConverter(value="molecularfaces.MDLV3000Converter")
public class MDLV3000Converter
implements Converter {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IAtomContainer getAsObject(FacesContext context, UIComponent component, String value) throws ConverterException {
        if (value == null) return null;
        if (value.isEmpty()) {
            return null;
        }
        try (MDLV3000Reader reader = new MDLV3000Reader((Reader)new StringReader(value));){
            IAtomContainer iAtomContainer = (IAtomContainer)reader.read((IChemObject)new AtomContainer());
            return iAtomContainer;
        }
        catch (Exception e) {
            throw new ConverterException(new FacesMessage(e.getMessage()), (Throwable)e);
        }
    }

    public String getAsString(FacesContext context, UIComponent component, Object value) throws ConverterException {
        if (value == null || !(value instanceof IAtomContainer)) {
            return "";
        }
        IAtomContainer mol = (IAtomContainer)value;
        StringWriter writer = new StringWriter();
        try (MDLV3000Writer molWriter = new MDLV3000Writer((Writer)writer);){
            molWriter.write((IChemObject)mol);
        }
        catch (Exception e) {
            throw new ConverterException(new FacesMessage(e.getMessage()), (Throwable)e);
        }
        return writer.toString();
    }
}

