/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces;

import de.ipb_halle.molecularfaces.MolPluginCore;
import java.io.IOException;
import java.util.Formatter;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;

@FacesRenderer(rendererType="molecularfaces.OpenChemLibJSRenderer", componentFamily="molecularfaces.MolPluginFamily")
public class OpenChemLibJSRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "molecularfaces.OpenChemLibJSRenderer";
    private String loaderJSVar = "molecularfaces.openChemLibJSLoaderInstance";

    public void decode(FacesContext context, UIComponent component) {
        Map requestMap = context.getExternalContext().getRequestParameterMap();
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isReadonly()) {
            String clientId = plugin.getClientId(context);
            String value = (String)requestMap.get(clientId);
            plugin.setSubmittedValue(value);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)plugin.getClientId(), null);
        if (plugin.isReadonly()) {
            this.encodeViewer(writer, plugin);
        } else {
            this.encodeEditor(writer, plugin);
        }
        writer.endElement("div");
    }

    private void encodeViewer(ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String divId = plugin.getClientId() + "_OpenChemLibJSViewer";
        this.encodeViewerHTML(writer, plugin, divId);
        this.encodeViewerJS(writer, plugin, divId);
    }

    private void encodeViewerHTML(ResponseWriter writer, MolPluginCore plugin, String divId) throws IOException {
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)divId, null);
        writer.writeAttribute("style", (Object)this.generateDivStyle(plugin), null);
        writer.endElement("div");
    }

    private void encodeViewerJS(ResponseWriter writer, MolPluginCore plugin, String divId) throws IOException {
        String escapedMolecule = this.escape((String)plugin.getValue());
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuilder sb = new StringBuilder(512 + escapedMolecule.length());
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.OpenChemLibJSViewer.newViewer(\"%s\", \"%s\", %d, %d);", divId, escapedMolecule, plugin.getHeight(), plugin.getWidth());
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }

    private void encodeEditor(ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String divId = clientId + "_OpenChemLibJSEditor";
        this.encodeEditorHTML(writer, plugin, divId, hiddenInputId);
        this.encodeEditorJS(writer, plugin, divId, hiddenInputId);
    }

    private void encodeEditorHTML(ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)divId, null);
        writer.writeAttribute("style", (Object)this.generateDivStyle(plugin), null);
        writer.endElement("div");
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        writer.writeAttribute("name", (Object)plugin.getClientId(), null);
        writer.writeAttribute("value", plugin.getValue(), "value");
        writer.endElement("input");
    }

    private void encodeEditorJS(ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        StringBuilder sb = new StringBuilder(512);
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.OpenChemLibJSEditor.newEditor(\"%s\", document.getElementById(\"%s\").getAttribute(\"value\"))", divId, hiddenInputId);
        fmt.format(".then((editor) => editor.addChangeListener((mol) => { document.getElementById(\"%s\").setAttribute(\"value\", mol); }));", hiddenInputId);
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }

    private String generateDivStyle(MolPluginCore plugin) {
        StringBuilder sb = new StringBuilder(128);
        sb.append("width:").append(plugin.getWidth()).append("px;");
        sb.append("height:").append(plugin.getHeight()).append("px;");
        if (plugin.isBorder()) {
            sb.append("border:solid;border-width:1px;");
        }
        return sb.toString();
    }

    private String escape(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "");
    }
}

