/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.pd;

import de.intarsys.pdf.cos.COSBasedObject;
import de.intarsys.pdf.cos.COSDictionary;
import de.intarsys.pdf.cos.COSObject;
import de.intarsys.pdf.cos.COSStream;
import de.intarsys.pdf.encoding.PDFDocEncoding;
import de.intarsys.pdf.pd.PDFunction;
import de.intarsys.pdf.postscript.Handler;
import de.intarsys.pdf.postscript.ParseException;
import de.intarsys.pdf.postscript.Parser;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;

public class PDPostScriptFunction
extends PDFunction {
    public static final MetaClass META = new MetaClass(MetaClass.class.getDeclaringClass());
    private String code;

    protected PDPostScriptFunction(COSObject cOSObject) {
        super(cOSObject);
    }

    @Override
    public COSDictionary cosGetDict() {
        return this.cosGetStream().getDict();
    }

    @Override
    public float[] evaluate(float[] fArray) {
        Handler handler = new Handler();
        ArrayList<Double> arrayList = new ArrayList<Double>(fArray.length);
        int n = 0;
        while (n < fArray.length) {
            arrayList.add(new Double(fArray[n]));
            ++n;
        }
        handler.pushArgs(arrayList);
        try {
            new Parser(new StringReader(this.getCode())).parse(handler);
        }
        catch (ParseException parseException) {
            return this.dummyResult();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            return this.dummyResult();
        }
        List list = handler.popResult();
        float[] fArray2 = new float[this.getOutputSize()];
        n = 0;
        while (n < fArray2.length) {
            fArray2[n] = ((Number)list.get(n)).floatValue();
            ++n;
        }
        return fArray2;
    }

    public String getCode() {
        if (this.code == null) {
            byte[] byArray = this.cosGetStream().getDecodedBytes();
            String string = PDFDocEncoding.UNIQUE.decode(byArray);
            int n = string.indexOf(123);
            int n2 = string.lastIndexOf(125);
            this.code = n != -1 && n2 != -1 ? string.substring(n + 1, n2) : string;
        }
        return this.code;
    }

    @Override
    public int getOutputSize() {
        return this.getRange().size() / 2;
    }

    public static class MetaClass
    extends PDFunction.MetaClass {
        protected MetaClass(Class clazz) {
            super(clazz);
        }

        @Override
        protected COSBasedObject doCreateCOSBasedObject(COSObject cOSObject) {
            return new PDPostScriptFunction(cOSObject);
        }

        @Override
        protected COSObject doCreateCOSObject() {
            return COSStream.create(null);
        }
    }
}

