/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.pdf.content;

import de.intarsys.pdf.content.CSOperator;
import de.intarsys.pdf.content.CSOperators;
import de.intarsys.pdf.cos.COSName;
import de.intarsys.pdf.cos.COSObject;
import java.util.Arrays;
import java.util.Iterator;

public class CSOperation {
    public static final COSName OPERAND_Tx = COSName.constant("Tx");
    private byte[] operatorToken;
    private COSObject[] operands;
    private Object cache;

    public CSOperation(byte[] byArray, COSObject[] cOSObjectArray) {
        this.operatorToken = byArray;
        this.operands = cOSObjectArray;
    }

    public CSOperation(CSOperator cSOperator) {
        this(cSOperator, new COSObject[0]);
    }

    public CSOperation(CSOperator cSOperator, COSObject[] cOSObjectArray) {
        this.operatorToken = cSOperator.getToken();
        this.operands = cOSObjectArray;
    }

    public void addOperand(COSObject cOSObject) {
        COSObject[] cOSObjectArray = new COSObject[this.operands.length + 1];
        System.arraycopy(this.operands, 0, cOSObjectArray, 0, this.operands.length);
        cOSObjectArray[cOSObjectArray.length - 1] = cOSObject;
        this.operands = cOSObjectArray;
    }

    public Object getCache() {
        return this.cache;
    }

    public COSObject getOperand(int n) {
        return this.operands[n];
    }

    public Iterator getOperands() {
        return Arrays.asList(this.operands).iterator();
    }

    public CSOperator getOperator() {
        return new CSOperator(this.operatorToken);
    }

    public byte[] getOperatorToken() {
        return this.operatorToken;
    }

    public boolean hasOperator() {
        return this.operatorToken != null;
    }

    public boolean isOpBeginMarkedContent(COSName cOSName) {
        if (this.matchesOperator(CSOperators.CSO_BMC)) {
            if (cOSName == null || this.operandSize() == 0) {
                return true;
            }
            COSObject cOSObject = this.getOperand(0);
            if (cOSObject instanceof COSName && ((COSName)cOSObject).equals(cOSName)) {
                return true;
            }
        }
        return false;
    }

    public boolean isOpEndMarkedContent() {
        return this.matchesOperator(CSOperators.CSO_EMC);
    }

    public boolean matchesOperator(CSOperator cSOperator) {
        return Arrays.equals(this.operatorToken, cSOperator.getToken());
    }

    public int operandSize() {
        return this.operands.length;
    }

    public void setCache(Object object) {
        this.cache = object;
    }

    public COSObject setOperand(int n, COSObject cOSObject) {
        COSObject cOSObject2 = this.operands[n];
        this.operands[n] = cOSObject;
        return cOSObject2;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.getOperands();
        while (iterator.hasNext()) {
            COSObject cOSObject = (COSObject)iterator.next();
            stringBuilder.append(cOSObject.toString());
            stringBuilder.append(" ");
        }
        stringBuilder.append(new String(this.operatorToken));
        return stringBuilder.toString();
    }
}

