/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.stream;

import de.intarsys.tools.file.FileTools;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class TempFileOutputStream
extends OutputStream {
    private File destination;
    private File tempFile;
    private FileOutputStream tempOutput;

    public TempFileOutputStream(File destination) throws IOException {
        this(destination, "tmp", "tmp");
    }

    public TempFileOutputStream(File destination, String prefix, String suffix) throws IOException {
        this.destination = destination;
        this.tempFile = File.createTempFile(prefix, suffix, destination.getParentFile());
        this.tempOutput = new FileOutputStream(this.tempFile);
    }

    public void close() throws IOException {
        super.close();
        try {
            this.tempOutput.close();
            FileTools.copyBinaryFile(this.tempFile, this.destination);
        }
        finally {
            this.tempFile.delete();
        }
    }

    public void flush() throws IOException {
        this.tempOutput.flush();
    }

    public void write(byte[] b) throws IOException {
        this.tempOutput.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        this.tempOutput.write(b, off, len);
    }

    public void write(int b) throws IOException {
        this.tempOutput.write(b);
    }
}

