/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.tools.locator;

import de.intarsys.tools.file.FileTools;
import de.intarsys.tools.locator.FileLocator;
import de.intarsys.tools.locator.ILocator;
import de.intarsys.tools.locator.ILocatorFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class FileLocatorFactory
implements ILocatorFactory {
    public static final String PATH_SEPARATOR = ";";
    private String searchPathDefinition;
    private List searchPaths;
    private boolean synchSynchronous = true;

    public FileLocatorFactory() {
        this.setSearchPathDefinition("./");
    }

    public ILocator createLocator(String path) {
        FileLocator result = null;
        Iterator it = this.getSearchPaths().iterator();
        while (it.hasNext()) {
            String searchPath = (String)it.next();
            File parent = new File(searchPath);
            File absolutePath = FileTools.resolvePath(parent, path);
            result = new FileLocator(absolutePath);
            if (!it.hasNext() || result.exists()) break;
        }
        if (result != null) {
            result.setSynchSynchronous(this.isSynchSynchronous());
        }
        return result;
    }

    public String getSearchPathDefinition() {
        return this.searchPathDefinition;
    }

    public List getSearchPaths() {
        return this.searchPaths;
    }

    public boolean isSynchSynchronous() {
        return this.synchSynchronous;
    }

    public void setSearchPathDefinition(String searchPath) {
        this.searchPathDefinition = searchPath;
        this.searchPaths = new ArrayList();
        StringTokenizer e = new StringTokenizer(this.searchPathDefinition, PATH_SEPARATOR);
        while (e.hasMoreElements()) {
            String path = (String)e.nextElement();
            if (path == null || path.trim().length() <= 0 || this.searchPaths.contains(path)) continue;
            this.searchPaths.add(path);
        }
    }

    public void setSearchPaths(List searchPaths) {
        this.searchPaths = searchPaths;
    }

    public void setSynchSynchronous(boolean synchSynchronous) {
        this.synchSynchronous = synchSynchronous;
    }
}

