/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.nativec.api;

import de.intarsys.nativec.api.INativeHandle;
import de.intarsys.nativec.api.NativeInterface;
import de.intarsys.nativec.type.NativeArray;
import de.intarsys.nativec.type.NativeArrayType;
import de.intarsys.nativec.type.NativeBuffer;
import de.intarsys.nativec.type.NativeBufferType;
import de.intarsys.nativec.type.NativeInt;
import de.intarsys.nativec.type.NativeLong;
import de.intarsys.tools.valueholder.IValueHolder;
import de.intarsys.tools.valueholder.ObjectValueHolder;

public class NativeTools {
    public static byte[] fromNativeByteArray(long l, int n) {
        if (l == 0L) {
            return null;
        }
        INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
        NativeBufferType nativeBufferType = NativeBufferType.create(n);
        NativeBuffer nativeBuffer = (NativeBuffer)nativeBufferType.createNative(iNativeHandle);
        return nativeBuffer.getBytes();
    }

    public static long fromNativeCLong(long l) {
        INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
        NativeLong nativeLong = (NativeLong)NativeLong.META.createNative(iNativeHandle);
        return nativeLong.intValue();
    }

    public static IValueHolder<Number> fromNativeCLongHolder(long l) {
        return new ObjectValueHolder((Object)NativeTools.fromNativeCLong(l));
    }

    public static int fromNativeInt(long l) {
        INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
        NativeInt nativeInt = (NativeInt)NativeInt.META.createNative(iNativeHandle);
        return nativeInt.intValue();
    }

    public static int[] fromNativeIntArray(INativeHandle iNativeHandle, int n) {
        int[] nArray = new int[n];
        int n2 = NativeInt.META.getByteCount();
        int n3 = 0;
        while (n3 < n) {
            nArray[n3] = iNativeHandle.getInt(n3 * n2);
            ++n3;
        }
        return nArray;
    }

    public static int[] fromNativeIntArray(long l, int n) {
        INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
        return NativeTools.fromNativeIntArray(iNativeHandle, n);
    }

    public static IValueHolder<Integer> fromNativeIntHolder(long l) {
        return new ObjectValueHolder((Object)NativeTools.fromNativeInt(l));
    }

    public static String fromNativeString(long l, int n) {
        return null;
    }

    public static INativeHandle toHandle(long l) {
        return NativeInterface.get().createHandle(l);
    }

    public static void toNativeByteArray(long l, byte[] byArray) {
        if (byArray != null) {
            INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
            NativeBufferType nativeBufferType = NativeBufferType.create(byArray.length);
            NativeBuffer nativeBuffer = (NativeBuffer)nativeBufferType.createNative(iNativeHandle);
            nativeBuffer.setValue(byArray);
        }
    }

    public static void toNativeCLong(long l, IValueHolder<Number> iValueHolder) {
        NativeTools.toNativeCLong(l, ((Number)iValueHolder.get()).longValue());
    }

    public static void toNativeCLong(long l, long l2) {
        INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
        NativeLong nativeLong = (NativeLong)NativeLong.META.createNative(iNativeHandle);
        nativeLong.setValue(l2);
    }

    public static void toNativeCLong(long l, int[] nArray) {
        if (nArray != null) {
            INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
            NativeArrayType nativeArrayType = NativeArrayType.create(NativeLong.META, nArray.length);
            NativeArray nativeArray = (NativeArray)nativeArrayType.createNative(iNativeHandle);
            int n = 0;
            while (n < nArray.length) {
                nativeArray.setValue(n, nArray[n]);
                ++n;
            }
        }
    }

    public static void toNativeCLong(long l, long[] lArray) {
        if (lArray != null) {
            INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
            NativeArrayType nativeArrayType = NativeArrayType.create(NativeLong.META, lArray.length);
            NativeArray nativeArray = (NativeArray)nativeArrayType.createNative(iNativeHandle);
            int n = 0;
            while (n < lArray.length) {
                nativeArray.setValue(n, lArray[n]);
                ++n;
            }
        }
    }

    public static void toNativeInt(long l, int n) {
        INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
        iNativeHandle.setSize(NativeInt.META.getByteCount());
        iNativeHandle.setInt(0, n);
    }

    public static void toNativeInt(long l, int[] nArray) {
        if (nArray != null) {
            INativeHandle iNativeHandle = NativeInterface.get().createHandle(l);
            NativeArrayType nativeArrayType = NativeArrayType.create(NativeInt.META, nArray.length);
            NativeArray nativeArray = (NativeArray)nativeArrayType.createNative(iNativeHandle);
            int n = 0;
            while (n < nArray.length) {
                nativeArray.setValue(n, nArray[n]);
                ++n;
            }
        }
    }

    public static void toNativeInt(long l, IValueHolder<Integer> iValueHolder) {
        NativeTools.toNativeInt(l, (Integer)iValueHolder.get());
    }

    public static void toNativePointer(long l, INativeHandle iNativeHandle) {
        INativeHandle iNativeHandle2 = NativeInterface.get().createHandle(l);
        iNativeHandle2.setNativeHandle(0, iNativeHandle);
    }
}

