/*
 * Decompiled with CFR 0.152.
 */
package de.intarsys.cwt.font.truetype;

import de.intarsys.cwt.font.truetype.TTFont;
import de.intarsys.cwt.font.truetype.TTFontParser;
import de.intarsys.cwt.font.truetype.TTFontSerializer;
import de.intarsys.cwt.font.truetype.TTTable;
import de.intarsys.cwt.font.truetype.TrueTypeException;
import de.intarsys.tools.randomaccess.IRandomAccess;
import de.intarsys.tools.randomaccess.RandomAccessByteArray;
import de.intarsys.tools.stream.StreamTools;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class CreateSubset {
    public static byte[][] SubsetTables = new byte[][]{TTFont.TABLE_CMAP, TTFont.TABLE_CVT, TTFont.TABLE_FGPM, TTFont.TABLE_GLYF, TTFont.TABLE_HEAD, TTFont.TABLE_HHEA, TTFont.TABLE_HMTX, TTFont.TABLE_LOCA, TTFont.TABLE_MAXP, TTFont.TABLE_NAME, TTFont.TABLE_OS2, TTFont.TABLE_PREP};
    private final TTFont font;
    private final Set glyphIndices;
    private TTFont result;

    public CreateSubset(TTFont tTFont, Set set) {
        this.font = tTFont;
        this.glyphIndices = set;
    }

    protected Set addCompositeGlyphs(IRandomAccess iRandomAccess, int[] nArray, Set set) throws IOException, TrueTypeException {
        HashSet hashSet = new HashSet();
        hashSet.addAll(set);
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            this.addCompositeGlyphs(iRandomAccess, nArray, hashSet, n);
        }
        return hashSet;
    }

    protected void addCompositeGlyphs(IRandomAccess iRandomAccess, int[] nArray, Set set, int n) throws IOException, TrueTypeException {
        if (nArray[n] == nArray[n + 1]) {
            return;
        }
        iRandomAccess.seek((long)nArray[n]);
        TTFontParser tTFontParser = new TTFontParser();
        short s = tTFontParser.readShort(iRandomAccess);
        if (s >= 0) {
            return;
        }
        iRandomAccess.seekBy(8L);
        while (true) {
            int n2 = tTFontParser.readUShort(iRandomAccess);
            int n3 = tTFontParser.readUShort(iRandomAccess);
            set.add(new Integer(n3));
            if ((n2 & 0x20) == 0) {
                return;
            }
            int n4 = (n2 & 1) != 0 ? 4 : 2;
            if ((n2 & 8) != 0) {
                n4 += 2;
            } else if ((n2 & 0x40) != 0) {
                n4 += 4;
            }
            if ((n2 & 0x80) != 0) {
                n4 += 8;
            }
            iRandomAccess.seekBy((long)n4);
        }
    }

    public TTFont compute() throws IOException, TrueTypeException {
        TTTable tTTable = this.getFont().getTable(TTFont.TABLE_LOCA);
        int[] nArray = new TTFontParser().parseTable_loca(tTTable, this.getFont().getFontHeader().isShortLocationFormat());
        TTTable tTTable2 = this.getFont().getTable(TTFont.TABLE_GLYF);
        IRandomAccess iRandomAccess = tTTable2.getRandomAccess();
        try {
            this.result = this.copySubset();
            this.getGlyphIndices().add(new Integer(0));
            Set set = this.addCompositeGlyphs(iRandomAccess, nArray, this.getGlyphIndices());
            this.createGlyphTable(tTTable, tTTable2, iRandomAccess, nArray, set, this.getFont().getFontHeader().isShortLocationFormat());
            TTFont tTFont = this.result;
            return tTFont;
        }
        finally {
            StreamTools.close((IRandomAccess)iRandomAccess);
        }
    }

    protected TTFont copySubset() {
        TTFont tTFont = new TTFont();
        ArrayList<TTTable> arrayList = new ArrayList<TTTable>();
        int n = 0;
        while (n < SubsetTables.length) {
            TTTable tTTable = this.getFont().getTable(SubsetTables[n]);
            if (tTTable != null) {
                arrayList.add(tTTable);
            }
            ++n;
        }
        tTFont.setTables(arrayList.toArray(new TTTable[0]));
        return tTFont;
    }

    protected void createGlyphTable(TTTable tTTable, TTTable tTTable2, IRandomAccess iRandomAccess, int[] nArray, Set set, boolean bl) throws IOException, TrueTypeException {
        int n = 0;
        Object object = set.iterator();
        while (object.hasNext()) {
            int n2 = (Integer)object.next();
            if (n2 + 1 >= nArray.length) continue;
            n += nArray[n2 + 1] - nArray[n2];
        }
        n = TTFont.align(n);
        object = new int[nArray.length];
        byte[] byArray = new byte[n];
        int n3 = 0;
        int n4 = 0;
        while (n4 < nArray.length) {
            int n5;
            int n6;
            object[n4] = n3;
            if (set.contains(new Integer(n4)) && (n6 = nArray[n4 + 1] - (n5 = nArray[n4])) > 0) {
                iRandomAccess.seek((long)n5);
                iRandomAccess.read(byArray, n3, n6);
                n3 += n6;
            }
            ++n4;
        }
        RandomAccessByteArray randomAccessByteArray = new RandomAccessByteArray(null);
        TTFontSerializer tTFontSerializer = new TTFontSerializer();
        tTFontSerializer.write_loca((IRandomAccess)randomAccessByteArray, (int[])object, bl);
        tTTable.setBytes(randomAccessByteArray.toByteArray());
        tTTable2.setBytes(byArray);
    }

    public TTFont getFont() {
        return this.font;
    }

    public Set getGlyphIndices() {
        return this.glyphIndices;
    }

    public TTFont getResult() {
        return this.result;
    }
}

