/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.JavaScriptExpression;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.Operation;
import com.inet.lib.less.SelectorUtils;
import java.text.ParsePosition;
import java.util.ArrayList;

class ValueExpression
extends Expression {
    private int type;
    private double value;
    private String unit;
    private Operation op;

    ValueExpression(LessObject obj, String value) {
        super(obj, value);
    }

    ValueExpression(LessObject obj, String value, int type) {
        super(obj, value);
        this.type = type;
        this.unit = "";
    }

    ValueExpression(JavaScriptExpression expr, Object value) {
        super(expr, String.valueOf(value));
        if (value instanceof Number) {
            this.type = 2;
            this.value = ((Number)value).doubleValue();
            this.unit = "";
        }
    }

    public static ValueExpression eval(CssFormatter formatter, Expression expr) {
        if ((expr = expr.unpack(formatter)).getClass() == ValueExpression.class) {
            return (ValueExpression)expr;
        }
        ValueExpression valueEx = new ValueExpression(expr, expr.stringValue(formatter));
        valueEx.type = expr.getDataType(formatter);
        valueEx.unit = expr.unit(formatter);
        switch (valueEx.type) {
            case 1: 
            case 6: {
                break;
            }
            case 7: {
                Operation op = valueEx.op = new Operation((LessObject)expr, ' ');
                ArrayList<Expression> operants = expr.listValue(formatter).getOperands();
                for (int j = 0; j < operants.size(); ++j) {
                    op.addOperand(ValueExpression.eval(formatter, operants.get(j)));
                }
                break;
            }
            default: {
                valueEx.value = expr.doubleValue(formatter);
            }
        }
        return valueEx;
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        if (this.type == 0) {
            this.eval(formatter);
        }
        switch (this.type) {
            case 5: {
                formatter.appendColor(this.value, this.toString());
                break;
            }
            case 6: {
                SelectorUtils.appendToWithPlaceHolder(formatter, this.toString(), 0, this);
                break;
            }
            default: {
                super.appendTo(formatter);
            }
        }
    }

    @Override
    public int getDataType(CssFormatter formatter) {
        if (this.type == 0) {
            this.eval(formatter);
        }
        return this.type;
    }

    @Override
    public double doubleValue(CssFormatter formatter) {
        if (this.type == 0) {
            this.eval(formatter);
        }
        if (this.type == 6) {
            throw this.createException("Invalid Number: " + this.toString());
        }
        return this.value;
    }

    @Override
    public String unit(CssFormatter formatter) {
        if (this.type == 0) {
            this.eval(formatter);
        }
        return this.unit;
    }

    @Override
    public boolean booleanValue(CssFormatter formatter) {
        return Boolean.parseBoolean(this.toString());
    }

    @Override
    public Operation listValue(CssFormatter formatter) {
        if (this.type == 7) {
            return this.op;
        }
        return super.listValue(formatter);
    }

    private void eval(CssFormatter formatter) {
        try {
            long rgb;
            block20: {
                String str;
                block19: {
                    str = this.toString();
                    if (str.endsWith("%")) {
                        this.value = Double.parseDouble(str.substring(0, str.length() - 1));
                        this.unit = "%";
                        this.type = 3;
                        return;
                    }
                    this.unit = "";
                    if (!str.startsWith("#")) break block19;
                    str = str.substring(1);
                    switch (str.length()) {
                        case 3: {
                            rgb = 0L;
                            for (int i = 0; i < 3; ++i) {
                                char ch = str.charAt(i);
                                int digit = Character.digit(ch, 16);
                                if (digit < 0) {
                                    this.type = 6;
                                    return;
                                }
                                rgb *= 256L;
                                rgb += (long)(digit * 17);
                                rgb *= 256L;
                            }
                            break block20;
                        }
                        case 6: {
                            rgb = 0L;
                            for (int i = 0; i < 6; ++i) {
                                char ch;
                                int digit;
                                if ((digit = Character.digit(ch = str.charAt(i++), 16)) < 0) {
                                    this.type = 6;
                                    return;
                                }
                                rgb *= 16L;
                                rgb += (long)digit;
                                ch = str.charAt(i);
                                digit = Character.digit(ch, 16);
                                if (digit < 0) {
                                    this.type = 6;
                                    return;
                                }
                                rgb *= 16L;
                                rgb += (long)digit;
                                rgb *= 256L;
                            }
                            break block20;
                        }
                        default: {
                            throw this.createException("Invalid Color: " + this.toString());
                        }
                    }
                }
                rgb = ValueExpression.getRgbFromColorConst(str = str.toLowerCase());
                if (rgb == -1L) {
                    if (str.equals("transparent")) {
                        this.value = 0.0;
                        this.type = 4;
                        return;
                    }
                    ParsePosition pos = new ParsePosition(0);
                    Number number = formatter.getFormat().parse(str, pos);
                    if (number == null) {
                        if (str.startsWith("+")) {
                            pos.setIndex(1);
                            number = formatter.getFormat().parse(str, pos);
                            if (number == null) {
                                this.type = 6;
                                return;
                            }
                        } else {
                            this.type = 6;
                            return;
                        }
                    }
                    this.value = number.doubleValue();
                    if (pos.getIndex() != str.length()) {
                        this.unit = str.substring(pos.getIndex());
                    }
                    this.type = 2;
                    return;
                }
            }
            this.value = Double.longBitsToDouble(0xFFFF000000000000L | rgb);
            this.type = 5;
        }
        catch (NumberFormatException e) {
            this.type = 6;
        }
    }

    private static long getRgbFromColorConst(String str) {
        long rgb;
        switch (str) {
            case "aliceblue": {
                rgb = 0xF000F800FF00L;
                break;
            }
            case "antiquewhite": {
                rgb = 274881849644800L;
                break;
            }
            case "aqua": {
                rgb = 0xFF00FF00L;
                break;
            }
            case "aquamarine": {
                rgb = 139642254971904L;
                break;
            }
            case "azure": {
                rgb = 0xF000FF00FF00L;
                break;
            }
            case "beige": {
                rgb = 269384459279360L;
                break;
            }
            case "bisque": {
                rgb = 280379290338304L;
                break;
            }
            case "black": {
                rgb = 0L;
                break;
            }
            case "blanchedalmond": {
                rgb = 280379407781120L;
                break;
            }
            case "blue": {
                rgb = 65280L;
                break;
            }
            case "blueviolet": {
                rgb = 151733326111232L;
                break;
            }
            case "brown": {
                rgb = 181420123236864L;
                break;
            }
            case "burlywood": {
                rgb = 244094668408576L;
                break;
            }
            case "cadetblue": {
                rgb = 104456255479808L;
                break;
            }
            case "chartreuse": {
                rgb = 0x7F00FF000000L;
                break;
            }
            case "chocolate": {
                rgb = 230899203448320L;
                break;
            }
            case "coral": {
                rgb = 280377595809792L;
                break;
            }
            case "cornflowerblue": {
                rgb = 109953662643456L;
                break;
            }
            case "cornsilk": {
                rgb = 280379625888768L;
                break;
            }
            case "crimson": {
                rgb = 241892893670400L;
                break;
            }
            case "cyan": {
                rgb = 0xFF00FF00L;
                break;
            }
            case "darkblue": {
                rgb = 35584L;
                break;
            }
            case "darkcyan": {
                rgb = 0x8B008B00L;
                break;
            }
            case "darkgoldenrod": {
                rgb = 202312387660544L;
                break;
            }
            case "darkgray": 
            case "darkgrey": {
                rgb = 0xA900A900A900L;
                break;
            }
            case "darkgreen": {
                rgb = 0x64000000L;
                break;
            }
            case "darkkhaki": {
                rgb = 207810767907584L;
                break;
            }
            case "darkmagenta": {
                rgb = 0x8B0000008B00L;
                break;
            }
            case "darkolivegreen": {
                rgb = 93460283535104L;
                break;
            }
            case "darkorange": {
                rgb = 280377813893120L;
                break;
            }
            case "darkorchid": {
                rgb = 168226117962752L;
                break;
            }
            case "darkred": {
                rgb = 0x8B0000000000L;
                break;
            }
            case "darksalmon": {
                rgb = 256188725885440L;
                break;
            }
            case "darkseagreen": {
                rgb = 157233316925184L;
                break;
            }
            case "darkslateblue": {
                rgb = 79165860645632L;
                break;
            }
            case "darkslategray": 
            case "darkslategrey": {
                rgb = 51678371925760L;
                break;
            }
            case "darkturquoise": {
                rgb = 3456160000L;
                break;
            }
            case "darkviolet": {
                rgb = 162727720964864L;
                break;
            }
            case "deeppink": {
                rgb = 280375800664832L;
                break;
            }
            case "deepskyblue": {
                rgb = 0xBF00FF00L;
                break;
            }
            case "dimgray": 
            case "dimgrey": {
                rgb = 0x690069006900L;
                break;
            }
            case "dodgerblue": {
                rgb = 32987764817664L;
                break;
            }
            case "firebrick": {
                rgb = 0xB20022002200L;
                break;
            }
            case "floralwhite": {
                rgb = 0xFF00FA00F000L;
                break;
            }
            case "forestgreen": {
                rgb = 37385727386112L;
                break;
            }
            case "fuchsia": {
                rgb = 0xFF000000FF00L;
                break;
            }
            case "gainsboro": {
                rgb = 0xDC00DC00DC00L;
                break;
            }
            case "ghostwhite": {
                rgb = 0xF800F800FF00L;
                break;
            }
            case "gold": {
                rgb = 280379072184320L;
                break;
            }
            case "goldenrod": {
                rgb = 239696303104000L;
                break;
            }
            case "gray": 
            case "grey": {
                rgb = 0x800080008000L;
                break;
            }
            case "green": {
                rgb = 0x80000000L;
                break;
            }
            case "greenyellow": {
                rgb = 190219789807360L;
                break;
            }
            case "honeydew": {
                rgb = 0xF000FF00F000L;
                break;
            }
            case "hotpink": {
                rgb = 280377226736640L;
                break;
            }
            case "indianred": {
                rgb = 225401427221504L;
                break;
            }
            case "indigo": {
                rgb = 82463372116480L;
                break;
            }
            case "ivory": {
                rgb = 0xFF00FF00F000L;
                break;
            }
            case "khaki": {
                rgb = 263886649461760L;
                break;
            }
            case "lavender": {
                rgb = 252891533212160L;
                break;
            }
            case "lavenderblush": {
                rgb = 0xFF00F000F500L;
                break;
            }
            case "lawngreen": {
                rgb = 136343669702656L;
                break;
            }
            case "lemonchiffon": {
                rgb = 280379659439360L;
                break;
            }
            case "lightblue": {
                rgb = 190219135542784L;
                break;
            }
            case "lightcoral": {
                rgb = 0xF00080008000L;
                break;
            }
            case "lightcyan": {
                rgb = 0xE000FF00FF00L;
                break;
            }
            case "lightgoldenrodyellow": {
                rgb = 274882101301760L;
                break;
            }
            case "lightgray": 
            case "lightgrey": {
                rgb = 0xD300D300D300L;
                break;
            }
            case "lightgreen": {
                rgb = 0x9000EE009000L;
                break;
            }
            case "lightpink": {
                rgb = 280378518585600L;
                break;
            }
            case "lightsalmon": {
                rgb = 280378149468672L;
                break;
            }
            case "lightseagreen": {
                rgb = 35187358476800L;
                break;
            }
            case "lightskyblue": {
                rgb = 148437525920256L;
                break;
            }
            case "lightslategray": 
            case "lightslategrey": {
                rgb = 130844165445888L;
                break;
            }
            case "lightsteelblue": {
                rgb = 193517334879744L;
                break;
            }
            case "lightyellow": {
                rgb = 0xFF00FF00E000L;
                break;
            }
            case "lime": {
                rgb = 0xFF000000L;
                break;
            }
            case "limegreen": {
                rgb = 54979020730880L;
                break;
            }
            case "linen": {
                rgb = 274881933534720L;
                break;
            }
            case "magenta": {
                rgb = 0xFF000000FF00L;
                break;
            }
            case "maroon": {
                rgb = 0x800000000000L;
                break;
            }
            case "mediumaquamarine": {
                rgb = 112153625405952L;
                break;
            }
            case "mediumblue": {
                rgb = 52480L;
                break;
            }
            case "mediumorchid": {
                rgb = 204510588883712L;
                break;
            }
            case "mediumpurple": {
                rgb = 161630088386560L;
                break;
            }
            case "mediumseagreen": {
                rgb = 65973700817152L;
                break;
            }
            case "mediumslateblue": {
                rgb = 135241675107840L;
                break;
            }
            case "mediumspringgreen": {
                rgb = 4194343424L;
                break;
            }
            case "mediumturquoise": {
                rgb = 79168343690240L;
                break;
            }
            case "mediumvioletred": {
                rgb = 218803166283008L;
                break;
            }
            case "midnightblue": {
                rgb = 27488210153472L;
                break;
            }
            case "mintcream": {
                rgb = 269384627059200L;
                break;
            }
            case "mistyrose": {
                rgb = 280379290345728L;
                break;
            }
            case "moccasin": {
                rgb = 280379290334464L;
                break;
            }
            case "navajowhite": {
                rgb = 280379189669120L;
                break;
            }
            case "navy": {
                rgb = 32768L;
                break;
            }
            case "oldlace": {
                rgb = 278180552304128L;
                break;
            }
            case "olive": {
                rgb = 0x800080000000L;
                break;
            }
            case "olivedrab": {
                rgb = 117650126545664L;
                break;
            }
            case "orange": {
                rgb = 280378233323520L;
                break;
            }
            case "orangered": {
                rgb = 280376622710784L;
                break;
            }
            case "orchid": {
                rgb = 239695413958144L;
                break;
            }
            case "palegoldenrod": {
                rgb = 261687659768320L;
                break;
            }
            case "palegreen": {
                rgb = 167129978542080L;
                break;
            }
            case "paleturquoise": {
                rgb = 192418527899136L;
                break;
            }
            case "palevioletred": {
                rgb = 237496390685440L;
                break;
            }
            case "papayawhip": {
                rgb = 280379474892032L;
                break;
            }
            case "peachpuff": {
                rgb = 280379122563328L;
                break;
            }
            case "peru": {
                rgb = 225402115079936L;
                break;
            }
            case "pink": {
                rgb = 280378686360320L;
                break;
            }
            case "plum": {
                rgb = 0xDD00A000DD00L;
                break;
            }
            case "powderblue": {
                rgb = 193517804643840L;
                break;
            }
            case "purple": {
                rgb = 0x800000008000L;
                break;
            }
            case "red": {
                rgb = 0xFF0000000000L;
                break;
            }
            case "rosybrown": {
                rgb = 206710585200384L;
                break;
            }
            case "royalblue": {
                rgb = 71470017470720L;
                break;
            }
            case "saddlebrown": {
                rgb = 152833273893632L;
                break;
            }
            case "salmon": {
                rgb = 274880054456832L;
                break;
            }
            case "sandybrown": {
                rgb = 268283588665344L;
                break;
            }
            case "seagreen": {
                rgb = 50579866932992L;
                break;
            }
            case "seashell": {
                rgb = 280379575561728L;
                break;
            }
            case "sienna": {
                rgb = 175923236187392L;
                break;
            }
            case "silver": {
                rgb = 0xC000C000C000L;
                break;
            }
            case "skyblue": {
                rgb = 148437525916416L;
                break;
            }
            case "slateblue": {
                rgb = 116549742546176L;
                break;
            }
            case "slategray": 
            case "slategrey": {
                rgb = 123147449831424L;
                break;
            }
            case "snow": {
                rgb = 0xFF00FA00FA00L;
                break;
            }
            case "springgreen": {
                rgb = 0xFF007F00L;
                break;
            }
            case "steelblue": {
                rgb = 76967995028480L;
                break;
            }
            case "tan": {
                rgb = 230900461767680L;
                break;
            }
            case "teal": {
                rgb = 0x80008000L;
                break;
            }
            case "thistle": {
                rgb = 237497716103168L;
                break;
            }
            case "tomato": {
                rgb = 280377126045440L;
                break;
            }
            case "turquoise": {
                rgb = 70372502327296L;
                break;
            }
            case "violet": {
                rgb = 261685948509696L;
                break;
            }
            case "wheat": {
                rgb = 269384073392896L;
                break;
            }
            case "white": {
                rgb = 0xFF00FF00FF00L;
                break;
            }
            case "whitesmoke": {
                rgb = 0xF500F500F500L;
                break;
            }
            case "yellow": {
                rgb = 0xFF00FF000000L;
                break;
            }
            case "yellowgreen": {
                rgb = 169328230019584L;
                break;
            }
            default: {
                rgb = -1L;
            }
        }
        return rgb;
    }
}

