/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.CustomFunctions;
import com.inet.lib.less.Expression;
import com.inet.lib.less.HSL;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.Operation;
import com.inet.lib.less.ParameterOutOfBoundsException;
import com.inet.lib.less.RegExp;
import com.inet.lib.less.UrlUtils;
import com.inet.lib.less.ValueExpression;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

class FunctionExpression
extends Expression {
    private final List<Expression> parameters;
    private int type;
    private double doubleValue;
    private boolean booleanValue;

    FunctionExpression(LessObject obj, @Nonnull String name, @Nonnull Operation parameters) {
        super(obj, name);
        this.parameters = parameters.getOperands();
    }

    @Override
    public int getDataType(CssFormatter formatter) {
        if (this.type == 0) {
            this.eval(formatter);
        }
        return this.type;
    }

    @Override
    public double doubleValue(CssFormatter formatter) {
        this.eval(formatter);
        return this.doubleValue;
    }

    @Override
    public boolean booleanValue(CssFormatter formatter) {
        this.eval(formatter);
        return this.booleanValue;
    }

    @Override
    public String unit(CssFormatter formatter) {
        switch (super.toString()) {
            case "unit": {
                if (this.parameters.size() <= 1) {
                    return "";
                }
                return this.get(1).stringValue(formatter);
            }
            case "convert": {
                return this.get(1).stringValue(formatter);
            }
            case "sin": 
            case "cos": 
            case "tan": 
            case "length": {
                return "";
            }
            case "acos": 
            case "asin": 
            case "atan": {
                return "rad";
            }
            case "pow": {
                return this.get(0).unit(formatter);
            }
            case "alpha": 
            case "red": 
            case "green": 
            case "blue": 
            case "rgba": 
            case "rgb": 
            case "argb": 
            case "saturate": 
            case "desaturate": 
            case "greyscale": 
            case "hsl": 
            case "hsla": 
            case "hue": 
            case "spin": 
            case "lighten": 
            case "darken": 
            case "fadein": 
            case "fadeout": 
            case "fade": 
            case "hsv": 
            case "hsva": 
            case "hsvhue": 
            case "contrast": {
                return "";
            }
            case "saturation": 
            case "lightness": 
            case "hsvsaturation": 
            case "hsvvalue": 
            case "luma": 
            case "luminance": {
                return "%";
            }
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            String unit = this.parameters.get(i).unit(formatter);
            if (unit.isEmpty()) continue;
            return unit;
        }
        return "";
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        try {
            switch (super.toString()) {
                case "%": {
                    this.format(formatter);
                    return;
                }
                case "escape": {
                    this.escape(formatter);
                    return;
                }
                case "argb": {
                    double color = this.getDouble(0, formatter);
                    int argb = ColorUtils.argb(color);
                    formatter.append('#');
                    formatter.appendHex(argb, 8);
                    return;
                }
                case "svg-gradient": {
                    UrlUtils.svgGradient(formatter, this.parameters);
                    return;
                }
                case "colorize-image": {
                    CustomFunctions.colorizeImage(formatter, this.parameters);
                    return;
                }
                case "replace": {
                    String str = this.get(0).stringValue(formatter);
                    formatter.setInlineMode(true);
                    String pattern = this.get(1).stringValue(formatter);
                    String replacement = this.get(2).stringValue(formatter);
                    String flags = this.parameters.size() > 3 ? this.get(3).stringValue(formatter) : "";
                    formatter.setInlineMode(false);
                    if (str.length() > 1) {
                        char ch = str.charAt(0);
                        boolean quote = false;
                        if ((ch == '\'' || ch == '\"') && str.charAt(str.length() - 1) == ch) {
                            str = str.substring(1, str.length() - 1);
                            quote = true;
                        }
                        str = new RegExp(pattern, flags).replace(str, replacement);
                        if (quote) {
                            str = ch + str + ch;
                        }
                    }
                    formatter.append(str);
                    return;
                }
                case "get-unit": {
                    formatter.append(this.unit(formatter));
                    return;
                }
                case "url": {
                    String url = this.get(1).stringValue(formatter);
                    formatter.append("url(");
                    formatter.append(url);
                    formatter.append(")");
                    return;
                }
                case "data-uri": {
                    String url;
                    String type;
                    String baseUrl = this.get(0).stringValue(formatter);
                    if (this.parameters.size() >= 3) {
                        type = this.get(1).stringValue(formatter);
                        url = this.get(2).stringValue(formatter);
                    } else {
                        type = null;
                        url = this.get(1).stringValue(formatter);
                    }
                    UrlUtils.dataUri(formatter, baseUrl, url, type);
                    return;
                }
                case "extract": {
                    Expression expr = this.extract(formatter);
                    if (expr == null) break;
                    expr.appendTo(formatter);
                    return;
                }
            }
            if (this.type == 0) {
                this.eval(formatter);
            }
            if (this.type == 6) {
                if (super.toString().equals("")) {
                    this.get(0).appendTo(formatter);
                } else {
                    this.appendToCssFunction(formatter);
                }
                return;
            }
            super.appendTo(formatter);
        }
        catch (Throwable th) {
            throw this.createException(th);
        }
    }

    private void appendToCssFunction(CssFormatter formatter) {
        formatter.append(super.toString()).append('(');
        for (int i = 0; i < this.parameters.size(); ++i) {
            if (i > 0) {
                formatter.append(',').space();
            }
            this.parameters.get(i).appendTo(formatter);
        }
        formatter.append(')');
    }

    private void eval(CssFormatter formatter) {
        try {
            switch (super.toString().toLowerCase()) {
                case "": {
                    if (this.parameters.size() > 1) {
                        throw this.get(0).createException("Unrecognized input");
                    }
                    this.type = this.get(0).getDataType(formatter);
                    if (this.type != 6) {
                        this.doubleValue = this.getDouble(0, formatter);
                    }
                    return;
                }
                case "percentage": {
                    this.type = 3;
                    this.doubleValue = this.getDouble(0, formatter) * 100.0;
                    return;
                }
                case "convert": {
                    this.type = 2;
                    String unit = this.get(1).stringValue(formatter);
                    Expression param = this.get(0);
                    this.doubleValue = param.doubleValue(formatter) * Operation.unitFactor(param.unit(formatter), unit, false);
                    return;
                }
                case "abs": {
                    this.type = this.getNumberDataType(formatter);
                    this.doubleValue = Math.abs(this.getDouble(0, formatter));
                    return;
                }
                case "ceil": {
                    this.type = this.getNumberDataType(formatter);
                    this.doubleValue = Math.ceil(this.getDouble(0, formatter));
                    return;
                }
                case "floor": {
                    this.type = this.getNumberDataType(formatter);
                    this.doubleValue = Math.floor(this.getDouble(0, formatter));
                    return;
                }
                case "mod": {
                    this.type = 2;
                    this.doubleValue = this.getDouble(0, formatter) % this.getDouble(1, formatter);
                    return;
                }
                case "pi": {
                    this.type = 2;
                    this.doubleValue = Math.PI;
                    return;
                }
                case "round": {
                    int i;
                    this.type = this.getNumberDataType(formatter);
                    int decimalPlaces = this.getInt(1, 0, formatter);
                    this.doubleValue = this.getDouble(0, formatter);
                    for (i = 0; i < decimalPlaces; ++i) {
                        this.doubleValue *= 10.0;
                    }
                    this.doubleValue = Math.round(this.doubleValue);
                    for (i = 0; i < decimalPlaces; ++i) {
                        this.doubleValue /= 10.0;
                    }
                    return;
                }
                case "min": {
                    this.type = 2;
                    this.doubleValue = this.get(0).doubleValue(formatter);
                    String unit = this.unit(formatter);
                    for (int i = 1; i < this.parameters.size(); ++i) {
                        Expression param = this.parameters.get(i);
                        this.doubleValue = Math.min(this.doubleValue, param.doubleValue(formatter) / Operation.unitFactor(unit, param.unit(formatter), true));
                    }
                    return;
                }
                case "max": {
                    this.type = 2;
                    this.doubleValue = this.get(0).doubleValue(formatter);
                    String unit = this.unit(formatter);
                    for (int i = 1; i < this.parameters.size(); ++i) {
                        Expression param = this.parameters.get(i);
                        this.doubleValue = Math.max(this.doubleValue, param.doubleValue(formatter) / Operation.unitFactor(unit, param.unit(formatter), true));
                    }
                    return;
                }
                case "sqrt": {
                    this.type = 2;
                    this.doubleValue = Math.sqrt(this.getDouble(0, formatter));
                    return;
                }
                case "pow": {
                    this.type = 2;
                    this.doubleValue = Math.pow(this.getDouble(0, formatter), this.getDouble(1, formatter));
                    return;
                }
                case "sin": {
                    this.type = 2;
                    this.doubleValue = Math.sin(this.getRadians(formatter));
                    return;
                }
                case "cos": {
                    this.type = 2;
                    this.doubleValue = Math.cos(this.getRadians(formatter));
                    return;
                }
                case "tan": {
                    this.type = 2;
                    this.doubleValue = Math.tan(this.getRadians(formatter));
                    return;
                }
                case "acos": {
                    this.type = 2;
                    this.doubleValue = Math.acos(this.getRadians(formatter));
                    return;
                }
                case "asin": {
                    this.type = 2;
                    this.doubleValue = Math.asin(this.getRadians(formatter));
                    return;
                }
                case "atan": {
                    this.type = 2;
                    this.doubleValue = Math.atan(this.getRadians(formatter));
                    return;
                }
                case "increment": {
                    this.type = 2;
                    this.doubleValue = this.getDouble(0, formatter) + 1.0;
                    return;
                }
                case "add": {
                    this.type = 2;
                    this.doubleValue = this.getDouble(0, formatter) + this.getDouble(1, formatter);
                    return;
                }
                case "length": {
                    this.type = 2;
                    this.doubleValue = this.getParamList(formatter).size();
                    return;
                }
                case "extract": {
                    this.extract(formatter);
                    return;
                }
                case "alpha": {
                    this.type = 2;
                    switch (this.get(0).getDataType(formatter)) {
                        case 4: {
                            this.doubleValue = ColorUtils.alpha(this.getDouble(0, formatter));
                            break;
                        }
                        case 5: {
                            this.doubleValue = 1.0;
                            break;
                        }
                        default: {
                            this.type = 6;
                        }
                    }
                    return;
                }
                case "red": {
                    this.type = 2;
                    this.doubleValue = ColorUtils.red(this.getDouble(0, formatter));
                    return;
                }
                case "green": {
                    this.type = 2;
                    this.doubleValue = ColorUtils.green(this.getDouble(0, formatter));
                    return;
                }
                case "blue": {
                    this.type = 2;
                    this.doubleValue = ColorUtils.blue(this.getDouble(0, formatter));
                    return;
                }
                case "rgba": {
                    this.type = 4;
                    int r = this.getColorDigit(0, formatter);
                    int g = this.getColorDigit(1, formatter);
                    int b = this.getColorDigit(2, formatter);
                    double a = this.getPercent(3, formatter);
                    this.doubleValue = ColorUtils.rgba(r, g, b, a);
                    return;
                }
                case "rgb": {
                    this.type = 5;
                    int r = this.getColorDigit(0, formatter);
                    int g = this.getColorDigit(1, formatter);
                    int b = this.getColorDigit(2, formatter);
                    this.doubleValue = ColorUtils.rgb(r, g, b);
                    return;
                }
                case "color": {
                    Expression param = this.get(0);
                    String str = UrlUtils.removeQuote(param.stringValue(formatter));
                    this.doubleValue = this.getColor(new ValueExpression(param, str), formatter);
                    return;
                }
                case "argb": {
                    this.type = 6;
                    return;
                }
                case "saturate": {
                    this.type = 5;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.s += this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "desaturate": {
                    this.type = 5;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.s -= this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "greyscale": {
                    this.type = 5;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.s = 0.0;
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "mix": {
                    double c1 = this.getColor(0, formatter);
                    double c2 = this.getColor(1, formatter);
                    double weight = this.getPercent(2, 0.5, formatter);
                    this.doubleValue = ColorUtils.mix(c1, c2, weight);
                    return;
                }
                case "tint": {
                    double c1 = this.getColor(0, formatter);
                    double weight = this.getPercent(1, 0.5, formatter);
                    this.doubleValue = ColorUtils.mix(WHITE, c1, weight);
                    return;
                }
                case "shade": {
                    double c1 = this.getColor(0, formatter);
                    double weight = this.getPercent(1, 0.5, formatter);
                    this.doubleValue = ColorUtils.mix(BLACK, c1, weight);
                    return;
                }
                case "saturation": {
                    this.type = 3;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    this.doubleValue = hsl.s * 100.0;
                    return;
                }
                case "hsl": {
                    this.type = 5;
                    this.doubleValue = ColorUtils.hsla(this.getDouble(0, formatter), this.getPercent(1, formatter), this.getPercent(2, formatter), 1.0);
                    return;
                }
                case "hsla": {
                    this.type = 4;
                    this.doubleValue = ColorUtils.hsla(this.getDouble(0, formatter), this.getPercent(1, formatter), this.getPercent(2, formatter), this.getPercent(3, formatter));
                    return;
                }
                case "hue": {
                    this.type = 2;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    this.doubleValue = hsl.h;
                    return;
                }
                case "lightness": {
                    this.type = 3;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    this.doubleValue = hsl.l * 100.0;
                    return;
                }
                case "spin": {
                    this.type = 5;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.h += this.getDouble(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "lighten": {
                    HSL hsl = ColorUtils.toHSL(this.getColor(0, formatter));
                    hsl.l += this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "darken": {
                    HSL hsl = ColorUtils.toHSL(this.getColor(0, formatter));
                    hsl.l -= this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "fadein": {
                    this.type = 4;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.a += this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "fadeout": {
                    this.type = 4;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.a -= this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "fade": {
                    this.type = 4;
                    HSL hsl = ColorUtils.toHSL(this.getDouble(0, formatter));
                    hsl.a = this.getPercent(1, formatter);
                    this.doubleValue = ColorUtils.hsla(hsl);
                    return;
                }
                case "hsv": {
                    this.type = 5;
                    this.doubleValue = ColorUtils.hsva(this.getDouble(0, formatter), this.getPercent(1, formatter), this.getPercent(2, formatter), 1.0);
                    return;
                }
                case "hsva": {
                    this.type = 4;
                    this.doubleValue = ColorUtils.hsva(this.getDouble(0, formatter), this.getPercent(1, formatter), this.getPercent(2, formatter), this.getPercent(3, formatter));
                    return;
                }
                case "hsvhue": {
                    this.doubleValue = ColorUtils.toHSV((double)this.getColor((int)0, (CssFormatter)formatter)).h;
                    this.type = 2;
                    return;
                }
                case "hsvsaturation": {
                    this.doubleValue = ColorUtils.toHSV((double)this.getColor((int)0, (CssFormatter)formatter)).s * 100.0;
                    this.type = 3;
                    return;
                }
                case "hsvvalue": {
                    this.doubleValue = ColorUtils.toHSV((double)this.getColor((int)0, (CssFormatter)formatter)).v * 100.0;
                    this.type = 3;
                    return;
                }
                case "contrast": {
                    double color = this.getColor(0, formatter);
                    double dark = this.getDouble(1, BLACK, formatter);
                    double light = this.getDouble(2, WHITE, formatter);
                    double threshold = this.getPercent(3, 0.43, formatter);
                    this.doubleValue = ColorUtils.contrast(color, dark, light, threshold);
                    return;
                }
                case "luma": {
                    double color = this.getColor(0, formatter);
                    this.type = 3;
                    this.doubleValue = ColorUtils.luma(color) * 100.0;
                    return;
                }
                case "luminance": {
                    double color = this.getColor(0, formatter);
                    this.type = 3;
                    this.doubleValue = ColorUtils.luminance(color) * 100.0;
                    return;
                }
                case "multiply": {
                    this.doubleValue = ColorUtils.multiply(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "screen": {
                    this.doubleValue = ColorUtils.screen(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "overlay": {
                    this.doubleValue = ColorUtils.overlay(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "softlight": {
                    this.doubleValue = ColorUtils.softlight(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "hardlight": {
                    this.doubleValue = ColorUtils.hardlight(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "difference": {
                    this.doubleValue = ColorUtils.difference(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "exclusion": {
                    this.doubleValue = ColorUtils.exclusion(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "average": {
                    this.doubleValue = ColorUtils.average(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "negation": {
                    this.doubleValue = ColorUtils.negation(this.getColor(0, formatter), this.getColor(1, formatter));
                    return;
                }
                case "unit": {
                    this.type = 2;
                    this.doubleValue = this.getDouble(0, formatter);
                    return;
                }
                case "iscolor": {
                    this.type = 1;
                    int type0 = this.get(0).getDataType(formatter);
                    this.booleanValue = type0 == 5 || type0 == 4;
                    return;
                }
                case "isnumber": {
                    this.type = 1;
                    int type0 = this.get(0).getDataType(formatter);
                    this.booleanValue = type0 == 2 || type0 == 3;
                    return;
                }
                case "isstring": {
                    this.type = 1;
                    this.booleanValue = this.get(0).getDataType(formatter) == 6;
                    return;
                }
                case "iskeyword": {
                    String str;
                    this.type = 1;
                    Expression param = this.get(0);
                    this.booleanValue = param.getDataType(formatter) == 6 ? (str = param.stringValue(formatter)) == UrlUtils.removeQuote(str) : false;
                    return;
                }
                case "ispixel": {
                    this.type = 1;
                    Expression param = this.get(0);
                    this.booleanValue = param.unit(formatter).equals("px");
                    return;
                }
                case "isem": {
                    this.type = 1;
                    Expression param = this.get(0);
                    this.booleanValue = param.unit(formatter).equals("em");
                    return;
                }
                case "ispercentage": {
                    this.type = 1;
                    Expression param = this.get(0);
                    this.booleanValue = param.unit(formatter).equals("%");
                    return;
                }
                case "isunit": {
                    this.type = 1;
                    String unit = this.get(1).stringValue(formatter);
                    Expression param = this.get(0);
                    this.booleanValue = param.unit(formatter).equals(unit);
                    return;
                }
                case "default": {
                    if (!formatter.isGuard()) break;
                    this.type = 1;
                    this.booleanValue = formatter.getGuardDefault();
                    return;
                }
                case "-": {
                    this.type = this.get(0).getDataType(formatter);
                    this.doubleValue = -this.getDouble(0, formatter);
                    return;
                }
                case "%": 
                case "escape": {
                    this.type = 6;
                    return;
                }
            }
            if (super.toString().startsWith("-")) {
                this.type = 6;
                return;
            }
        }
        catch (ParameterOutOfBoundsException ex) {
        }
        catch (RuntimeException ex) {
            throw this.createException(ex);
        }
        this.type = 6;
    }

    private void format(CssFormatter formatter) {
        String fmt = this.get(0).stringValue(formatter);
        int idx = 1;
        for (int i = 0; i < fmt.length(); ++i) {
            char ch = fmt.charAt(i);
            if (ch == '%') {
                ch = fmt.charAt(++i);
                switch (ch) {
                    case '%': {
                        formatter.append(ch);
                        break;
                    }
                    case 'a': 
                    case 'd': {
                        this.get(idx++).appendTo(formatter);
                        break;
                    }
                    case 'A': 
                    case 'D': {
                        String str = this.get(idx++).stringValue(formatter);
                        try {
                            str = new URI(null, null, str, null).getRawPath();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        formatter.append(str);
                        break;
                    }
                    case 's': {
                        formatter.setInlineMode(true);
                        this.get(idx++).appendTo(formatter);
                        formatter.setInlineMode(false);
                        break;
                    }
                    case 'S': {
                        formatter.setInlineMode(true);
                        String str = this.get(idx++).stringValue(formatter);
                        try {
                            str = new URI(null, null, str, null).getRawPath();
                        }
                        catch (URISyntaxException e) {
                            e.printStackTrace();
                        }
                        formatter.append(str);
                        formatter.setInlineMode(false);
                        break;
                    }
                    default: {
                        formatter.append(ch);
                        break;
                    }
                }
                continue;
            }
            formatter.append(ch);
        }
    }

    private void escape(CssFormatter formatter) {
        String url = this.get(0).stringValue(formatter);
        url = UrlUtils.removeQuote(url);
        block3: for (int i = 0; i < url.length(); ++i) {
            char ch = url.charAt(i);
            if (ch < '\u0080') {
                if (ch > ' ') {
                    switch (ch) {
                        case '#': 
                        case '(': 
                        case ')': 
                        case ':': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case ']': 
                        case '^': 
                        case '{': 
                        case '|': 
                        case '}': {
                            break;
                        }
                        default: {
                            formatter.append(ch);
                            continue block3;
                        }
                    }
                }
                formatter.append('%');
                formatter.appendHex(ch, 2);
                continue;
            }
            byte[] bytes = String.valueOf(ch).getBytes(StandardCharsets.UTF_8);
            for (int j = 0; j < bytes.length; ++j) {
                formatter.append('%');
                formatter.appendHex(bytes[j], 2);
            }
        }
    }

    private int getNumberDataType(CssFormatter formatter) {
        if (this.get(0).getDataType(formatter) == 3) {
            return 3;
        }
        return 2;
    }

    Expression get(int idx) {
        if (this.parameters.size() <= idx) {
            throw new ParameterOutOfBoundsException();
        }
        return this.parameters.get(idx);
    }

    private int getColorDigit(int idx, CssFormatter formatter) {
        Expression expression = this.get(idx);
        double d = expression.doubleValue(formatter);
        if (expression.getDataType(formatter) == 3) {
            d *= 2.55;
        }
        return ColorUtils.colorDigit(d);
    }

    private int getInt(int idx, CssFormatter formatter) {
        return (int)this.get(idx).doubleValue(formatter);
    }

    private int getInt(int idx, int defaultValue, CssFormatter formatter) {
        if (this.parameters.size() <= idx) {
            return defaultValue;
        }
        return (int)this.parameters.get(idx).doubleValue(formatter);
    }

    private double getPercent(int idx, CssFormatter formatter) {
        return ColorUtils.getPercent(this.get(idx), formatter);
    }

    private double getPercent(int idx, double defaultValue, CssFormatter formatter) {
        if (this.parameters.size() <= idx) {
            return defaultValue;
        }
        return ColorUtils.getPercent(this.get(idx), formatter);
    }

    private double getColor(int idx, CssFormatter formatter) {
        return this.getColor(this.get(idx), formatter);
    }

    private double getColor(Expression exp, CssFormatter formatter) {
        this.type = exp.getDataType(formatter);
        switch (this.type) {
            case 4: 
            case 5: {
                return exp.doubleValue(formatter);
            }
        }
        throw new ParameterOutOfBoundsException();
    }

    double getRadians(CssFormatter formatter) {
        Expression exp = this.get(0);
        String unit = exp.unit(formatter);
        return exp.doubleValue(formatter) * Operation.unitFactor(unit, "rad", false);
    }

    private double getDouble(int idx, CssFormatter formatter) {
        return this.get(idx).doubleValue(formatter);
    }

    private double getDouble(int idx, double defaultValue, CssFormatter formatter) {
        if (this.parameters.size() <= idx) {
            return defaultValue;
        }
        return this.parameters.get(idx).doubleValue(formatter);
    }

    @Override
    public Operation listValue(CssFormatter formatter) {
        switch (super.toString().toLowerCase()) {
            case "extract": {
                return this.extract(formatter).listValue(formatter);
            }
        }
        return super.listValue(formatter);
    }

    private List<Expression> getParamList(CssFormatter formatter) {
        Expression ex0 = this.get(0).unpack(formatter);
        if (ex0.getDataType(formatter) == 7) {
            Expression ex0_0;
            Operation op = ex0.listValue(formatter);
            ArrayList<Expression> operants = op.getOperands();
            if (operants.size() == 1 && (ex0_0 = (Expression)operants.get(0)).getDataType(formatter) == 7) {
                return ex0_0.listValue(formatter).getOperands();
            }
            return operants;
        }
        ArrayList<Expression> result = new ArrayList<Expression>();
        result.add(ex0);
        return result;
    }

    private Expression extract(CssFormatter formatter) {
        List<Expression> exList = this.getParamList(formatter);
        int idx = this.getInt(1, formatter);
        if (idx <= 0 || exList.size() < idx) {
            this.type = 6;
            return null;
        }
        Expression ex = exList.get(idx - 1);
        this.type = ex.getDataType(formatter);
        switch (this.type) {
            case 6: 
            case 7: {
                break;
            }
            default: {
                this.doubleValue = ex.doubleValue(formatter);
            }
        }
        return ex;
    }
}

