/*
 * Decompiled with CFR 0.152.
 */
package de.hanbei.httpserver.response;

import de.hanbei.httpserver.common.Content;
import de.hanbei.httpserver.common.HTTPVersion;
import de.hanbei.httpserver.common.Header;
import de.hanbei.httpserver.common.Status;
import de.hanbei.httpserver.response.ResponseBuilder;

public final class Response {
    private HTTPVersion httpVersion = HTTPVersion.VERSION1_1;
    private Status status;
    private Header header;
    private Content content;

    private Response() {
    }

    private Response(Status status) {
        this.status = status;
        this.header = new Header();
        this.content = new Content();
    }

    public Status getStatus() {
        return this.status;
    }

    void setStatus(Status status) {
        this.status = status;
    }

    public HTTPVersion getHttpVersion() {
        return this.httpVersion;
    }

    void setHttpVersion(HTTPVersion httpVersion) {
        this.httpVersion = httpVersion;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HTTP/");
        builder.append((Object)this.httpVersion);
        builder.append(" ");
        builder.append(this.status);
        builder.append("\n");
        builder.append(this.header);
        builder.append(this.content);
        return builder.toString();
    }

    public Header getHeader() {
        return this.header;
    }

    public Content getContent() {
        return this.content;
    }

    public static ResponseBuilder notFound() {
        return Response.status(Status.NOT_FOUND);
    }

    public static ResponseBuilder ok() {
        return Response.status(Status.OK);
    }

    public static ResponseBuilder created() {
        return Response.status(Status.CREATED);
    }

    public static ResponseBuilder status(Status status) {
        return new ResponseBuilder(new Response(status));
    }
}

