/*
 * Decompiled with CFR 0.152.
 */
package de.hamm.pinnedsectionlistview;

import android.content.Context;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;
import de.hamm.pinnedsectionlistview.R;
import org.jetbrains.annotations.NotNull;

public class PinnedSectionListView
extends ListView {
    private final Rect touchRect = new Rect();
    private final PointF touchPoint = new PointF();
    private final DataSetObserver dataSetObserver = new DataSetObserver(){

        public void onChanged() {
            PinnedSectionListView.this.recreatePinnedShadow();
        }

        public void onInvalidated() {
            PinnedSectionListView.this.recreatePinnedShadow();
        }
    };
    AbsListView.OnScrollListener delegateOnScrollListener;
    private final AbsListView.OnScrollListener onScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (PinnedSectionListView.this.delegateOnScrollListener != null) {
                PinnedSectionListView.this.delegateOnScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            ListAdapter adapter;
            if (PinnedSectionListView.this.delegateOnScrollListener != null) {
                PinnedSectionListView.this.delegateOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            if ((adapter = PinnedSectionListView.this.getAdapter()) == null || visibleItemCount == 0) {
                return;
            }
            boolean isFirstVisibleItemSection = PinnedSectionListView.isItemViewTypePinned(adapter, adapter.getItemViewType(firstVisibleItem));
            if (isFirstVisibleItemSection) {
                View sectionView = PinnedSectionListView.this.getChildAt(0);
                if (sectionView.getTop() == PinnedSectionListView.this.getPaddingTop()) {
                    PinnedSectionListView.this.destroyPinnedShadow();
                } else {
                    PinnedSectionListView.this.ensureShadowForPosition(firstVisibleItem, firstVisibleItem, visibleItemCount);
                }
            } else {
                int sectionPosition = PinnedSectionListView.this.findCurrentSectionPosition(firstVisibleItem);
                if (sectionPosition > -1) {
                    PinnedSectionListView.this.ensureShadowForPosition(sectionPosition, firstVisibleItem, visibleItemCount);
                } else {
                    PinnedSectionListView.this.destroyPinnedShadow();
                }
            }
        }
    };
    PinnedSection recycleSection;
    PinnedSection pinnedSection;
    int translateY;
    private int touchSlop;
    private View touchTarget;
    private MotionEvent downEvent;
    private Drawable shadowDrawable;
    private int shadowHeight;
    private int sectionsDistanceY;

    public PinnedSectionListView(Context context) {
        super(context);
        this.initView();
        this.shadowDrawable = context.getResources().getDrawable(R.drawable.default_shadow);
        if (!this.isInEditMode()) {
            this.shadowHeight = context.getResources().getDimensionPixelSize(R.dimen.default_shadow_height);
        }
    }

    public PinnedSectionListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initAttrs(context, attrs);
        this.initView();
    }

    public PinnedSectionListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initAttrs(context, attrs);
        this.initView();
    }

    private static boolean isItemViewTypePinned(ListAdapter adapter, int viewType) {
        if (adapter instanceof HeaderViewListAdapter) {
            adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        return ((PinnedSectionListAdapter)adapter).isItemViewTypePinned(viewType);
    }

    private void initAttrs(Context context, AttributeSet attrs) {
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.PinnedSectionListView);
        this.shadowDrawable = typedArray.hasValue(0) ? typedArray.getDrawable(0) : context.getResources().getDrawable(R.drawable.default_shadow);
        if (typedArray.hasValue(1)) {
            this.shadowHeight = typedArray.getDimensionPixelSize(1, 0);
        } else if (!this.isInEditMode()) {
            this.shadowHeight = context.getResources().getDimensionPixelSize(R.dimen.default_shadow_height);
        }
        typedArray.recycle();
    }

    private void initView() {
        this.setOnScrollListener(this.onScrollListener);
        this.touchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
    }

    void createPinnedShadow(int position) {
        int maxHeight;
        View pinnedView;
        AbsListView.LayoutParams layoutParams;
        PinnedSection pinnedShadow = this.recycleSection;
        this.recycleSection = null;
        if (pinnedShadow == null) {
            pinnedShadow = new PinnedSection();
        }
        if ((layoutParams = (AbsListView.LayoutParams)(pinnedView = this.getAdapter().getView(position, pinnedShadow.view, (ViewGroup)this)).getLayoutParams()) == null) {
            layoutParams = new AbsListView.LayoutParams(-1, -2);
        }
        int heightMode = View.MeasureSpec.getMode((int)layoutParams.height);
        int heightSize = View.MeasureSpec.getSize((int)layoutParams.height);
        if (heightMode == 0) {
            heightMode = 0x40000000;
        }
        if (heightSize > (maxHeight = this.getHeight() - this.getListPaddingTop() - this.getListPaddingBottom())) {
            heightSize = maxHeight;
        }
        int ws = View.MeasureSpec.makeMeasureSpec((int)(this.getWidth() - this.getListPaddingLeft() - this.getListPaddingRight()), (int)0x40000000);
        int hs = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        pinnedView.measure(ws, hs);
        pinnedView.layout(0, 0, pinnedView.getMeasuredWidth(), pinnedView.getMeasuredHeight());
        this.translateY = 0;
        pinnedShadow.view = pinnedView;
        pinnedShadow.position = position;
        pinnedShadow.id = this.getAdapter().getItemId(position);
        this.pinnedSection = pinnedShadow;
    }

    void destroyPinnedShadow() {
        if (this.pinnedSection != null) {
            this.recycleSection = this.pinnedSection;
            this.pinnedSection = null;
        }
    }

    void ensureShadowForPosition(int sectionPosition, int firstVisibleItem, int visibleItemCount) {
        int nextPosition;
        if (visibleItemCount < 2) {
            this.destroyPinnedShadow();
            return;
        }
        if (this.pinnedSection != null && this.pinnedSection.position != sectionPosition) {
            this.destroyPinnedShadow();
        }
        if (this.pinnedSection == null) {
            this.createPinnedShadow(sectionPosition);
        }
        if ((nextPosition = sectionPosition + 1) < this.getCount()) {
            int nextSectionPosition = this.findFirstVisibleSectionPosition(nextPosition, visibleItemCount - (nextPosition - firstVisibleItem));
            if (nextSectionPosition > -1) {
                View nextSectionView = this.getChildAt(nextSectionPosition - firstVisibleItem);
                int bottom = this.pinnedSection.view.getBottom() + this.getPaddingTop();
                this.sectionsDistanceY = nextSectionView.getTop() - bottom;
                this.translateY = this.sectionsDistanceY < 0 ? this.sectionsDistanceY : 0;
            } else {
                this.translateY = 0;
                this.sectionsDistanceY = Integer.MAX_VALUE;
            }
        }
    }

    int findFirstVisibleSectionPosition(int firstVisibleItem, int visibleItemCount) {
        ListAdapter adapter = this.getAdapter();
        for (int childIndex = 0; childIndex < visibleItemCount; ++childIndex) {
            int position = firstVisibleItem + childIndex;
            int viewType = adapter.getItemViewType(position);
            if (!PinnedSectionListView.isItemViewTypePinned(adapter, viewType)) continue;
            return position;
        }
        return -1;
    }

    int findCurrentSectionPosition(int fromPosition) {
        int sectionPosition;
        SectionIndexer indexer;
        int itemPosition;
        int typeView;
        ListAdapter adapter = this.getAdapter();
        if (adapter instanceof SectionIndexer && PinnedSectionListView.isItemViewTypePinned(adapter, typeView = adapter.getItemViewType(itemPosition = (indexer = (SectionIndexer)adapter).getPositionForSection(sectionPosition = indexer.getSectionForPosition(fromPosition))))) {
            return itemPosition;
        }
        for (int position = fromPosition; position >= 0; --position) {
            int viewType = adapter.getItemViewType(position);
            if (!PinnedSectionListView.isItemViewTypePinned(adapter, viewType)) continue;
            return position;
        }
        return -1;
    }

    void recreatePinnedShadow() {
        this.destroyPinnedShadow();
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && adapter.getCount() > 0) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int sectionPosition = this.findCurrentSectionPosition(firstVisiblePosition);
            if (sectionPosition == -1) {
                return;
            }
            this.ensureShadowForPosition(sectionPosition, firstVisiblePosition, this.getLastVisiblePosition() - firstVisiblePosition);
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        if (listener == this.onScrollListener) {
            super.setOnScrollListener(listener);
        } else {
            this.delegateOnScrollListener = listener;
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        this.post(new Runnable(){

            @Override
            public void run() {
                PinnedSectionListView.this.recreatePinnedShadow();
            }
        });
    }

    public void setAdapter(ListAdapter adapter) {
        ListAdapter oldAdapter = this.getAdapter();
        if (oldAdapter != null) {
            oldAdapter.unregisterDataSetObserver(this.dataSetObserver);
        }
        if (adapter != null) {
            adapter.registerDataSetObserver(this.dataSetObserver);
        }
        if (oldAdapter != adapter) {
            this.destroyPinnedShadow();
        }
        super.setAdapter(adapter);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int shadowWidth;
        int parentWidth;
        super.onLayout(changed, l, t, r, b);
        if (this.pinnedSection != null && (parentWidth = r - l - this.getPaddingLeft() - this.getPaddingRight()) != (shadowWidth = this.pinnedSection.view.getWidth())) {
            this.recreatePinnedShadow();
        }
    }

    protected void dispatchDraw(@NotNull Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.pinnedSection != null) {
            int pLeft = this.getListPaddingLeft();
            int pTop = this.getListPaddingTop();
            View view = this.pinnedSection.view;
            canvas.save();
            int clipHeight = view.getHeight() + (this.shadowDrawable == null ? 0 : Math.min(this.shadowHeight, this.sectionsDistanceY));
            canvas.clipRect(pLeft, pTop, pLeft + view.getWidth(), pTop + clipHeight);
            canvas.translate((float)pLeft, (float)(pTop + this.translateY));
            this.drawChild(canvas, this.pinnedSection.view, this.getDrawingTime());
            if (this.shadowDrawable != null && this.sectionsDistanceY > 0) {
                this.shadowDrawable.setBounds(this.pinnedSection.view.getLeft(), this.pinnedSection.view.getBottom(), this.pinnedSection.view.getRight(), this.pinnedSection.view.getBottom() + this.shadowHeight);
                this.shadowDrawable.draw(canvas);
            }
            canvas.restore();
        }
    }

    public boolean dispatchTouchEvent(@NotNull MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        int action = ev.getAction();
        if (action == 0 && this.touchTarget == null && this.pinnedSection != null && this.isPinnedViewTouched(this.pinnedSection.view, x, y)) {
            this.touchTarget = this.pinnedSection.view;
            this.touchPoint.x = x;
            this.touchPoint.y = y;
            this.downEvent = MotionEvent.obtain((MotionEvent)ev);
        }
        if (this.touchTarget != null) {
            if (this.isPinnedViewTouched(this.touchTarget, x, y)) {
                this.touchTarget.dispatchTouchEvent(ev);
            }
            if (action == 1) {
                super.dispatchTouchEvent(ev);
                this.performPinnedItemClick();
                this.clearTouchTarget();
            } else if (action == 3) {
                this.clearTouchTarget();
            } else if (action == 2 && Math.abs(y - this.touchPoint.y) > (float)this.touchSlop) {
                MotionEvent event = MotionEvent.obtain((MotionEvent)ev);
                event.setAction(3);
                this.touchTarget.dispatchTouchEvent(event);
                event.recycle();
                super.dispatchTouchEvent(this.downEvent);
                super.dispatchTouchEvent(ev);
                this.clearTouchTarget();
            }
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean isPinnedViewTouched(View view, float x, float y) {
        view.getHitRect(this.touchRect);
        this.touchRect.top += this.translateY;
        this.touchRect.bottom += this.translateY + this.getPaddingTop();
        this.touchRect.left += this.getPaddingLeft();
        this.touchRect.right -= this.getPaddingRight();
        return this.touchRect.contains((int)x, (int)y);
    }

    private void clearTouchTarget() {
        this.touchTarget = null;
        if (this.downEvent != null) {
            this.downEvent.recycle();
            this.downEvent = null;
        }
    }

    private boolean performPinnedItemClick() {
        if (this.pinnedSection == null) {
            return false;
        }
        AdapterView.OnItemClickListener listener = this.getOnItemClickListener();
        if (listener != null) {
            View view = this.pinnedSection.view;
            this.playSoundEffect(0);
            if (view != null) {
                view.sendAccessibilityEvent(1);
            }
            listener.onItemClick((AdapterView)this, view, this.pinnedSection.position, this.pinnedSection.id);
            return true;
        }
        return false;
    }

    static class PinnedSection {
        public View view;
        public int position;
        public long id;

        PinnedSection() {
        }
    }

    public static interface PinnedSectionListAdapter
    extends ListAdapter {
        public boolean isItemViewTypePinned(int var1);
    }
}

