/*
 * Decompiled with CFR 0.152.
 */
package de.hamm.pinnedsectionlistview;

import android.content.Context;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.drawable.GradientDrawable;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.AdapterView;
import android.widget.HeaderViewListAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.SectionIndexer;

public class PinnedSectionListView
extends ListView {
    private final Rect mTouchRect = new Rect();
    private final PointF mTouchPoint = new PointF();
    private final DataSetObserver mDataSetObserver = new DataSetObserver(){

        public void onChanged() {
            PinnedSectionListView.this.recreatePinnedShadow();
        }

        public void onInvalidated() {
            PinnedSectionListView.this.recreatePinnedShadow();
        }
    };
    AbsListView.OnScrollListener mDelegateOnScrollListener;
    private final AbsListView.OnScrollListener mOnScrollListener = new AbsListView.OnScrollListener(){

        public void onScrollStateChanged(AbsListView view, int scrollState) {
            if (PinnedSectionListView.this.mDelegateOnScrollListener != null) {
                PinnedSectionListView.this.mDelegateOnScrollListener.onScrollStateChanged(view, scrollState);
            }
        }

        public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            ListAdapter adapter;
            if (PinnedSectionListView.this.mDelegateOnScrollListener != null) {
                PinnedSectionListView.this.mDelegateOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
            }
            if ((adapter = PinnedSectionListView.this.getAdapter()) == null || visibleItemCount == 0) {
                return;
            }
            boolean isFirstVisibleItemSection = PinnedSectionListView.isItemViewTypePinned(adapter, adapter.getItemViewType(firstVisibleItem));
            if (isFirstVisibleItemSection) {
                View sectionView = PinnedSectionListView.this.getChildAt(0);
                if (sectionView.getTop() == PinnedSectionListView.this.getPaddingTop()) {
                    PinnedSectionListView.this.destroyPinnedShadow();
                } else {
                    PinnedSectionListView.this.ensureShadowForPosition(firstVisibleItem, firstVisibleItem, visibleItemCount);
                }
            } else {
                int sectionPosition = PinnedSectionListView.this.findCurrentSectionPosition(firstVisibleItem);
                if (sectionPosition > -1) {
                    PinnedSectionListView.this.ensureShadowForPosition(sectionPosition, firstVisibleItem, visibleItemCount);
                } else {
                    PinnedSectionListView.this.destroyPinnedShadow();
                }
            }
        }
    };
    PinnedSection mRecycleSection;
    PinnedSection mPinnedSection;
    int mTranslateY;
    private int mTouchSlop;
    private View mTouchTarget;
    private MotionEvent mDownEvent;
    private GradientDrawable mShadowDrawable;
    private int mSectionsDistanceY;
    private int mShadowHeight;

    public PinnedSectionListView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public PinnedSectionListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initView();
    }

    public static boolean isItemViewTypePinned(ListAdapter adapter, int viewType) {
        if (adapter instanceof HeaderViewListAdapter) {
            adapter = ((HeaderViewListAdapter)adapter).getWrappedAdapter();
        }
        return ((PinnedSectionListAdapter)adapter).isItemViewTypePinned(viewType);
    }

    private void initView() {
        this.setOnScrollListener(this.mOnScrollListener);
        this.mTouchSlop = ViewConfiguration.get((Context)this.getContext()).getScaledTouchSlop();
        this.initShadow(true);
    }

    public void setShadowVisible(boolean visible) {
        this.initShadow(visible);
        if (this.mPinnedSection != null) {
            View v = this.mPinnedSection.view;
            this.invalidate(v.getLeft(), v.getTop(), v.getRight(), v.getBottom() + this.mShadowHeight);
        }
    }

    public void initShadow(boolean visible) {
        if (visible) {
            if (this.mShadowDrawable == null) {
                this.mShadowDrawable = new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{Color.parseColor((String)"#ffa0a0a0"), Color.parseColor((String)"#50a0a0a0"), Color.parseColor((String)"#00a0a0a0")});
                this.mShadowHeight = (int)(8.0f * this.getResources().getDisplayMetrics().density);
            }
        } else if (this.mShadowDrawable != null) {
            this.mShadowDrawable = null;
            this.mShadowHeight = 0;
        }
    }

    void createPinnedShadow(int position) {
        int maxHeight;
        View pinnedView;
        AbsListView.LayoutParams layoutParams;
        PinnedSection pinnedShadow = this.mRecycleSection;
        this.mRecycleSection = null;
        if (pinnedShadow == null) {
            pinnedShadow = new PinnedSection();
        }
        if ((layoutParams = (AbsListView.LayoutParams)(pinnedView = this.getAdapter().getView(position, pinnedShadow.view, (ViewGroup)this)).getLayoutParams()) == null) {
            layoutParams = new AbsListView.LayoutParams(-1, -2);
        }
        int heightMode = View.MeasureSpec.getMode((int)layoutParams.height);
        int heightSize = View.MeasureSpec.getSize((int)layoutParams.height);
        if (heightMode == 0) {
            heightMode = 0x40000000;
        }
        if (heightSize > (maxHeight = this.getHeight() - this.getListPaddingTop() - this.getListPaddingBottom())) {
            heightSize = maxHeight;
        }
        int ws = View.MeasureSpec.makeMeasureSpec((int)(this.getWidth() - this.getListPaddingLeft() - this.getListPaddingRight()), (int)0x40000000);
        int hs = View.MeasureSpec.makeMeasureSpec((int)heightSize, (int)heightMode);
        pinnedView.measure(ws, hs);
        pinnedView.layout(0, 0, pinnedView.getMeasuredWidth(), pinnedView.getMeasuredHeight());
        this.mTranslateY = 0;
        pinnedShadow.view = pinnedView;
        pinnedShadow.position = position;
        pinnedShadow.id = this.getAdapter().getItemId(position);
        this.mPinnedSection = pinnedShadow;
    }

    void destroyPinnedShadow() {
        if (this.mPinnedSection != null) {
            this.mRecycleSection = this.mPinnedSection;
            this.mPinnedSection = null;
        }
    }

    void ensureShadowForPosition(int sectionPosition, int firstVisibleItem, int visibleItemCount) {
        int nextPosition;
        if (visibleItemCount < 2) {
            this.destroyPinnedShadow();
            return;
        }
        if (this.mPinnedSection != null && this.mPinnedSection.position != sectionPosition) {
            this.destroyPinnedShadow();
        }
        if (this.mPinnedSection == null) {
            this.createPinnedShadow(sectionPosition);
        }
        if ((nextPosition = sectionPosition + 1) < this.getCount()) {
            int nextSectionPosition = this.findFirstVisibleSectionPosition(nextPosition, visibleItemCount - (nextPosition - firstVisibleItem));
            if (nextSectionPosition > -1) {
                View nextSectionView = this.getChildAt(nextSectionPosition - firstVisibleItem);
                int bottom = this.mPinnedSection.view.getBottom() + this.getPaddingTop();
                this.mSectionsDistanceY = nextSectionView.getTop() - bottom;
                this.mTranslateY = this.mSectionsDistanceY < 0 ? this.mSectionsDistanceY : 0;
            } else {
                this.mTranslateY = 0;
                this.mSectionsDistanceY = Integer.MAX_VALUE;
            }
        }
    }

    int findFirstVisibleSectionPosition(int firstVisibleItem, int visibleItemCount) {
        ListAdapter adapter = this.getAdapter();
        for (int childIndex = 0; childIndex < visibleItemCount; ++childIndex) {
            int position = firstVisibleItem + childIndex;
            int viewType = adapter.getItemViewType(position);
            if (!PinnedSectionListView.isItemViewTypePinned(adapter, viewType)) continue;
            return position;
        }
        return -1;
    }

    int findCurrentSectionPosition(int fromPosition) {
        int sectionPosition;
        SectionIndexer indexer;
        int itemPosition;
        int typeView;
        ListAdapter adapter = this.getAdapter();
        if (adapter instanceof SectionIndexer && PinnedSectionListView.isItemViewTypePinned(adapter, typeView = adapter.getItemViewType(itemPosition = (indexer = (SectionIndexer)adapter).getPositionForSection(sectionPosition = indexer.getSectionForPosition(fromPosition))))) {
            return itemPosition;
        }
        for (int position = fromPosition; position >= 0; --position) {
            int viewType = adapter.getItemViewType(position);
            if (!PinnedSectionListView.isItemViewTypePinned(adapter, viewType)) continue;
            return position;
        }
        return -1;
    }

    void recreatePinnedShadow() {
        this.destroyPinnedShadow();
        ListAdapter adapter = this.getAdapter();
        if (adapter != null && adapter.getCount() > 0) {
            int firstVisiblePosition = this.getFirstVisiblePosition();
            int sectionPosition = this.findCurrentSectionPosition(firstVisiblePosition);
            if (sectionPosition == -1) {
                return;
            }
            this.ensureShadowForPosition(sectionPosition, firstVisiblePosition, this.getLastVisiblePosition() - firstVisiblePosition);
        }
    }

    public void setOnScrollListener(AbsListView.OnScrollListener listener) {
        if (listener == this.mOnScrollListener) {
            super.setOnScrollListener(listener);
        } else {
            this.mDelegateOnScrollListener = listener;
        }
    }

    public void onRestoreInstanceState(Parcelable state) {
        super.onRestoreInstanceState(state);
        this.post(new Runnable(){

            @Override
            public void run() {
                PinnedSectionListView.this.recreatePinnedShadow();
            }
        });
    }

    public void setAdapter(ListAdapter adapter) {
        ListAdapter oldAdapter = this.getAdapter();
        if (oldAdapter != null) {
            oldAdapter.unregisterDataSetObserver(this.mDataSetObserver);
        }
        if (adapter != null) {
            adapter.registerDataSetObserver(this.mDataSetObserver);
        }
        if (oldAdapter != adapter) {
            this.destroyPinnedShadow();
        }
        super.setAdapter(adapter);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int shadowWidth;
        int parentWidth;
        super.onLayout(changed, l, t, r, b);
        if (this.mPinnedSection != null && (parentWidth = r - l - this.getPaddingLeft() - this.getPaddingRight()) != (shadowWidth = this.mPinnedSection.view.getWidth())) {
            this.recreatePinnedShadow();
        }
    }

    protected void dispatchDraw(Canvas canvas) {
        super.dispatchDraw(canvas);
        if (this.mPinnedSection != null) {
            int pLeft = this.getListPaddingLeft();
            int pTop = this.getListPaddingTop();
            View view = this.mPinnedSection.view;
            canvas.save();
            int clipHeight = view.getHeight() + (this.mShadowDrawable == null ? 0 : Math.min(this.mShadowHeight, this.mSectionsDistanceY));
            canvas.clipRect(pLeft, pTop, pLeft + view.getWidth(), pTop + clipHeight);
            canvas.translate((float)pLeft, (float)(pTop + this.mTranslateY));
            this.drawChild(canvas, this.mPinnedSection.view, this.getDrawingTime());
            if (this.mShadowDrawable != null && this.mSectionsDistanceY > 0) {
                this.mShadowDrawable.setBounds(this.mPinnedSection.view.getLeft(), this.mPinnedSection.view.getBottom(), this.mPinnedSection.view.getRight(), this.mPinnedSection.view.getBottom() + this.mShadowHeight);
                this.mShadowDrawable.draw(canvas);
            }
            canvas.restore();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        float x = ev.getX();
        float y = ev.getY();
        int action = ev.getAction();
        if (action == 0 && this.mTouchTarget == null && this.mPinnedSection != null && this.isPinnedViewTouched(this.mPinnedSection.view, x, y)) {
            this.mTouchTarget = this.mPinnedSection.view;
            this.mTouchPoint.x = x;
            this.mTouchPoint.y = y;
            this.mDownEvent = MotionEvent.obtain((MotionEvent)ev);
        }
        if (this.mTouchTarget != null) {
            if (this.isPinnedViewTouched(this.mTouchTarget, x, y)) {
                this.mTouchTarget.dispatchTouchEvent(ev);
            }
            if (action == 1) {
                super.dispatchTouchEvent(ev);
                this.performPinnedItemClick();
                this.clearTouchTarget();
            } else if (action == 3) {
                this.clearTouchTarget();
            } else if (action == 2 && Math.abs(y - this.mTouchPoint.y) > (float)this.mTouchSlop) {
                MotionEvent event = MotionEvent.obtain((MotionEvent)ev);
                event.setAction(3);
                this.mTouchTarget.dispatchTouchEvent(event);
                event.recycle();
                super.dispatchTouchEvent(this.mDownEvent);
                super.dispatchTouchEvent(ev);
                this.clearTouchTarget();
            }
            return true;
        }
        return super.dispatchTouchEvent(ev);
    }

    private boolean isPinnedViewTouched(View view, float x, float y) {
        view.getHitRect(this.mTouchRect);
        this.mTouchRect.top += this.mTranslateY;
        this.mTouchRect.bottom += this.mTranslateY + this.getPaddingTop();
        this.mTouchRect.left += this.getPaddingLeft();
        this.mTouchRect.right -= this.getPaddingRight();
        return this.mTouchRect.contains((int)x, (int)y);
    }

    private void clearTouchTarget() {
        this.mTouchTarget = null;
        if (this.mDownEvent != null) {
            this.mDownEvent.recycle();
            this.mDownEvent = null;
        }
    }

    private boolean performPinnedItemClick() {
        if (this.mPinnedSection == null) {
            return false;
        }
        AdapterView.OnItemClickListener listener = this.getOnItemClickListener();
        if (listener != null) {
            View view = this.mPinnedSection.view;
            this.playSoundEffect(0);
            if (view != null) {
                view.sendAccessibilityEvent(1);
            }
            listener.onItemClick((AdapterView)this, view, this.mPinnedSection.position, this.mPinnedSection.id);
            return true;
        }
        return false;
    }

    static class PinnedSection {
        public View view;
        public int position;
        public long id;

        PinnedSection() {
        }
    }

    public static interface PinnedSectionListAdapter
    extends ListAdapter {
        public boolean isItemViewTypePinned(int var1);
    }
}

