/*
 * Decompiled with CFR 0.152.
 */
package de.grobmeier.jjson.convert;

import de.grobmeier.jjson.JSONException;
import de.grobmeier.jjson.convert.JSON;
import de.grobmeier.jjson.convert.JSONReflectionUtils;
import de.grobmeier.jjson.shaded.org.apache.commons.lang3.StringEscapeUtils;
import de.grobmeier.jjson.shaded.org.apache.commons.lang3.reflect.FieldUtils;
import de.grobmeier.jjson.shaded.org.apache.commons.lang3.reflect.MethodUtils;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JSONAnnotationEncoder {
    private static final String QUOTE = "\"";
    private static final String PRIMITIVE_BOOLEAN = "boolean";
    private static final String ARRAY_RIGHT = "]";
    private static final String ARRAY_LEFT = "[";
    private static final String BRACKET_RIGHT = "}";
    private static final String COLON = ":";
    private static final String COMMA = ",";
    private static final String EMTPY_STRING = "";
    private static final String BRACKET_LEFT = "{";
    private final String CARRIAGE_RETURN = new String(new char[]{'\\', 'r'});
    private final String LINE_FEED = new String(new char[]{'\\', '\\', 'n'});
    private static final SimpleDateFormat DEFAULT_FORMAT = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss");
    private Map<String, SimpleDateFormat> formatterPool = new HashMap<String, SimpleDateFormat>();
    private static final String NULL = "null";

    public String encode(Object result) throws JSONException {
        StringBuilder builder = new StringBuilder();
        this.encode(result, builder, null);
        return builder.toString();
    }

    public void encode(Object result, StringBuilder builder, JSON annotation) throws JSONException {
        if (result == null) {
            builder.append(NULL);
        } else if (result.getClass().isAssignableFrom(String.class)) {
            this.encodeString((String)result, builder, annotation);
        } else if (result.getClass().isAssignableFrom(Integer.class)) {
            this.encodeInteger((Integer)result, builder);
        } else if (result.getClass().isAssignableFrom(Long.class)) {
            this.encodeLong((Long)result, builder);
        } else if (result.getClass().isAssignableFrom(Double.class)) {
            this.encodeDouble((Double)result, builder);
        } else if (result.getClass().isAssignableFrom(Float.class)) {
            this.encodeFloat((Float)result, builder);
        } else if (result.getClass().isAssignableFrom(Short.class)) {
            this.encodeShort((Short)result, builder);
        } else if (result.getClass().isAssignableFrom(Byte.class)) {
            this.encodeByte((Byte)result, builder);
        } else if (result.getClass().isAssignableFrom(Boolean.class)) {
            this.encodeBoolean((Boolean)result, builder);
        } else if (this.hasInterface(result, Collection.class)) {
            this.encodeCollection((Collection)result, builder);
        } else if (this.hasInterface(result, Map.class)) {
            this.encodeMap((Map)result, builder, annotation);
        } else if (result.getClass().isAssignableFrom(Date.class)) {
            this.encodeDate((Date)result, builder, annotation);
        } else if (result.getClass().isArray()) {
            this.encodeArray(result, builder);
        } else {
            this.encodeObject(result, builder);
        }
    }

    private void encodeArray(Object result, StringBuilder builder) throws JSONException {
        builder.append(ARRAY_LEFT);
        int length = Array.getLength(result);
        for (int i = 0; i < length; ++i) {
            if (i > 0) {
                builder.append(COMMA);
            }
            this.encode(Array.get(result, i), builder, null);
        }
        builder.append(ARRAY_RIGHT);
    }

    private void encodeDate(Date result, StringBuilder builder, JSON annotation) throws JSONException {
        String customFormat = annotation.dateFormat();
        if (customFormat != null && !EMTPY_STRING.equals(customFormat)) {
            SimpleDateFormat format = this.formatterPool.get(customFormat);
            if (format == null) {
                format = new SimpleDateFormat(customFormat);
                this.formatterPool.put(customFormat, format);
            }
            this.encodeString(format.format(result), builder, annotation);
        } else {
            this.encodeString(DEFAULT_FORMAT.format(result), builder, annotation);
        }
    }

    private void encodeMap(Map<Object, Object> result, StringBuilder builder, JSON annotation) throws JSONException {
        boolean first = true;
        builder.append(BRACKET_LEFT);
        Set<Map.Entry<Object, Object>> entries = result.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = entries.iterator();
        while (iterator.hasNext()) {
            if (!first) {
                builder.append(COMMA);
            } else {
                first = false;
            }
            Map.Entry<Object, Object> entry = iterator.next();
            this.encodeString(entry.getKey().toString(), builder, annotation);
            builder.append(COLON);
            this.encode(entry.getValue(), builder, null);
        }
        builder.append(BRACKET_RIGHT);
    }

    private void encodeCollection(Collection<Object> result, StringBuilder builder) throws JSONException {
        boolean first = true;
        builder.append(ARRAY_LEFT);
        Iterator<Object> iterator = result.iterator();
        while (iterator.hasNext()) {
            if (!first) {
                builder.append(COMMA);
            } else {
                first = false;
            }
            Object object = iterator.next();
            this.encode(object, builder, null);
        }
        builder.append(ARRAY_RIGHT);
    }

    private String encodeObject(Object c, StringBuilder builder) throws JSONException {
        if (c == null) {
            return NULL;
        }
        if (c.getClass().getAnnotation(JSON.class) == null) {
            return null;
        }
        builder.append(BRACKET_LEFT);
        int count = this.serializeFields(c, builder);
        this.serializeMethods(c, builder, count);
        builder.append(BRACKET_RIGHT);
        return builder.toString();
    }

    private int serializeFields(Object c, StringBuilder builder) throws JSONException {
        Field[] fields = FieldUtils.getFieldsWithAnnotation(c.getClass(), JSON.class);
        int count = 0;
        boolean first = true;
        for (Field field : fields) {
            JSON annotation = field.getAnnotation(JSON.class);
            if (!first) {
                builder.append(COMMA);
            } else {
                first = false;
            }
            String methodName = PRIMITIVE_BOOLEAN.equals(field.getType().toString()) ? JSONReflectionUtils.createGetter(field.getName(), JSONReflectionUtils.IS) : JSONReflectionUtils.createGetter(field.getName(), JSONReflectionUtils.GET);
            try {
                Method method = c.getClass().getMethod(methodName, null);
                Object result = method.invoke(c, (Object[])null);
                this.encodeString(field.getName(), builder, annotation);
                builder.append(COLON);
                this.encode(result, builder, annotation);
                ++count;
            }
            catch (SecurityException e) {
                throw new JSONException(e);
            }
            catch (NoSuchMethodException e) {
                throw new JSONException("No appropriate getter found: " + methodName, e);
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(e);
            }
            catch (IllegalAccessException e) {
                throw new JSONException(e);
            }
            catch (InvocationTargetException e) {
                throw new JSONException(e);
            }
        }
        return count;
    }

    private void serializeMethods(Object c, StringBuilder builder, int count) throws JSONException {
        Method[] methods;
        boolean first = count == 0;
        for (Method method : methods = MethodUtils.getMethodsWithAnnotation(c.getClass(), JSON.class)) {
            JSON annotation = method.getAnnotation(JSON.class);
            if (!first) {
                builder.append(COMMA);
            } else {
                first = false;
            }
            try {
                Object result = method.invoke(c, (Object[])null);
                String name = method.getName();
                if (name.startsWith("is")) {
                    name = name.replaceFirst("is", EMTPY_STRING);
                    name = name.substring(0, 1).toLowerCase() + name.substring(1);
                }
                if (name.startsWith("get")) {
                    name = name.replaceFirst("get", EMTPY_STRING);
                    name = name.substring(0, 1).toLowerCase() + name.substring(1);
                }
                this.encodeString(name, builder, annotation);
                builder.append(COLON);
                this.encode(result, builder, annotation);
            }
            catch (SecurityException e) {
                throw new JSONException(e);
            }
            catch (IllegalArgumentException e) {
                throw new JSONException(e);
            }
            catch (IllegalAccessException e) {
                throw new JSONException(e);
            }
            catch (InvocationTargetException e) {
                throw new JSONException(e);
            }
        }
    }

    private void encodeString(String string, StringBuilder result, JSON annotation) {
        if (string == null) {
            result.append(NULL);
        } else {
            result.append(QUOTE);
            result.append(StringEscapeUtils.escapeJava(string));
            result.append(QUOTE);
        }
    }

    private void encodeInteger(Integer integer, StringBuilder result) {
        if (integer == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(integer);
            result.append(EMTPY_STRING);
        }
    }

    private void encodeByte(Byte value, StringBuilder result) {
        if (value == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(value);
            result.append(EMTPY_STRING);
        }
    }

    private void encodeDouble(Double value, StringBuilder result) {
        if (value == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(value);
            result.append(EMTPY_STRING);
        }
    }

    private void encodeShort(Short value, StringBuilder result) {
        if (value == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(value);
            result.append(EMTPY_STRING);
        }
    }

    private void encodeFloat(Float value, StringBuilder result) {
        if (value == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(value);
            result.append(EMTPY_STRING);
        }
    }

    private void encodeLong(Long longValue, StringBuilder result) {
        if (longValue == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(longValue);
            result.append(EMTPY_STRING);
        }
    }

    private void encodeBoolean(Boolean b, StringBuilder result) {
        if (b == null) {
            result.append(NULL);
        } else {
            result.append(EMTPY_STRING);
            result.append(Boolean.toString(b));
            result.append(EMTPY_STRING);
        }
    }

    private boolean hasInterface(Object target, Class<?> interfaceClass) {
        return interfaceClass.isInstance(target);
    }
}

