/*
 * Decompiled with CFR 0.152.
 */
package de.grobmeier.jjson.convert;

import de.grobmeier.jjson.JSONArray;
import de.grobmeier.jjson.JSONBoolean;
import de.grobmeier.jjson.JSONException;
import de.grobmeier.jjson.JSONObject;
import de.grobmeier.jjson.JSONString;
import de.grobmeier.jjson.JSONValue;
import de.grobmeier.jjson.convert.JSONDecoder;
import de.grobmeier.jjson.convert.JSONReflectionUtils;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSONAnnotationDecoder {
    public <T> T decode(Class<T> t, String json) throws JSONException {
        JSONDecoder decoder = new JSONDecoder(json);
        JSONValue value = decoder.decode();
        JSONObject source = null;
        if (!(value instanceof JSONObject)) {
            throw new JSONException("Decoder expected JSON Object String");
        }
        source = (JSONObject)value;
        T result = null;
        try {
            result = t.newInstance();
        }
        catch (InstantiationException e) {
            throw new JSONException("Could not instantiate class: " + t, e);
        }
        catch (IllegalAccessException e) {
            throw new JSONException("Could not access class: " + t, e);
        }
        this.putObject(result, source);
        return result;
    }

    private void putObject(Object target, JSONObject source) throws JSONException {
        Map<String, JSONValue> values = source.getValue();
        Set<Map.Entry<String, JSONValue>> set = values.entrySet();
        for (Map.Entry<String, JSONValue> entry : set) {
            JSONValue v = entry.getValue();
            this.putValue(target, JSONReflectionUtils.createSetter(entry.getKey()), v);
        }
    }

    private void putValue(Object target, String methodName, JSONValue value) throws JSONException {
        try {
            if (value instanceof JSONString) {
                this.putStringValue(target, methodName, value);
            } else if (value instanceof JSONBoolean) {
                this.putBooleanValue(target, methodName, value);
            } else if (value instanceof JSONObject) {
                this.putObjectValue(target, methodName, value);
            } else if (value instanceof JSONArray) {
                this.putArrayValue(target, methodName, value);
            }
        }
        catch (SecurityException e) {
            throw new JSONException("Could not access POJO setter: " + methodName, e);
        }
        catch (NoSuchMethodException e) {
            throw new JSONException("Could not find POJO setter: " + methodName, e);
        }
        catch (IllegalArgumentException e) {
            throw new JSONException("Error putting arguments.", e);
        }
        catch (IllegalAccessException e) {
            throw new JSONException("Could not put argument at: " + methodName, e);
        }
        catch (InvocationTargetException e) {
            throw new JSONException("Could not work on object while accessing: " + methodName, e);
        }
        catch (ClassNotFoundException e) {
            throw new JSONException("Could not find class for: " + methodName, e);
        }
        catch (InstantiationException e) {
            throw new JSONException("Could not instantiate class for: " + methodName, e);
        }
    }

    private void putArrayValue(Object target, String methodName, JSONValue value) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Method[] methods;
        JSONArray array = (JSONArray)value;
        Method methodInvoke = null;
        for (Method method : methods = target.getClass().getMethods()) {
            List<JSONValue> values;
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) {
                throw new JSONException("Parameters do not follow POJO bean conventions");
            }
            Class<?> clazz = Class.forName(params[0].getName());
            Object put = null;
            if (List.class.getName().equals(clazz.getName())) {
                values = array.getValue();
                put = new ArrayList();
                for (JSONValue v : values) {
                    ((List)put).add(((JSONString)v).toString());
                }
            } else if (clazz.getComponentType() != null) {
                put = Array.newInstance(clazz.getComponentType(), array.getValue().size());
                values = array.getValue();
                int i = 0;
                for (JSONValue v : values) {
                    Array.set(put, i, ((JSONString)v).getValue().toString());
                    ++i;
                }
            }
            methodInvoke = target.getClass().getMethod(methodName, clazz);
            methodInvoke.invoke(target, put);
        }
    }

    private void putObjectValue(Object target, String methodName, JSONValue value) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException, ClassNotFoundException, InstantiationException {
        Method[] methods;
        Method methodInvoke = null;
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) {
                throw new JSONException("Parameters do not follow POJO bean conventions");
            }
            Class<?> clazz = Class.forName(params[0].getName());
            Object o = clazz.newInstance();
            this.putObject(o, (JSONObject)value);
            methodInvoke = target.getClass().getMethod(methodName, clazz);
            methodInvoke.invoke(target, o);
        }
    }

    private void putStringValue(Object target, String methodName, JSONValue value) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = target.getClass().getMethod(methodName, String.class);
        method.invoke(target, ((JSONString)value).getValue().toString());
    }

    private void putBooleanValue(Object target, String methodName, JSONValue value) throws JSONException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method[] methods;
        Method methodInvoke = null;
        for (Method method : methods = target.getClass().getMethods()) {
            if (!method.getName().equals(methodName)) continue;
            Class<?>[] params = method.getParameterTypes();
            if (params.length != 1) {
                throw new JSONException("Parameters do not follow POJO bean conventions");
            }
            methodInvoke = Boolean.TYPE.getName().equals(params[0].getName()) ? target.getClass().getMethod(methodName, Boolean.TYPE) : target.getClass().getMethod(methodName, Boolean.class);
        }
        methodInvoke.invoke(target, ((JSONBoolean)value).getValue());
    }
}

