/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.event;

import android.util.Log;
import de.greenrobot.event.EventBus;
import de.greenrobot.event.EventBusException;
import de.greenrobot.event.SubscriberMethod;
import de.greenrobot.event.ThreadMode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SubscriberMethodFinder {
    private static final String ON_EVENT_METHOD_NAME = "onEvent";
    private static final int BRIDGE = 64;
    private static final int SYNTHETIC = 4096;
    private static final int MODIFIERS_IGNORE = 5192;
    private static final Map<String, List<SubscriberMethod>> methodCache = new HashMap<String, List<SubscriberMethod>>();
    private final Map<Class<?>, Class<?>> skipMethodVerificationForClasses = new ConcurrentHashMap();

    SubscriberMethodFinder(List<Class<?>> skipMethodVerificationForClassesList) {
        if (skipMethodVerificationForClassesList != null) {
            for (Class<?> clazz : skipMethodVerificationForClassesList) {
                this.skipMethodVerificationForClasses.put(clazz, clazz);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<SubscriberMethod> findSubscriberMethods(Class<?> subscriberClass) {
        String name;
        List<SubscriberMethod> subscriberMethods;
        String key = subscriberClass.getName();
        Map<String, List<SubscriberMethod>> map = methodCache;
        synchronized (map) {
            subscriberMethods = methodCache.get(key);
        }
        if (subscriberMethods != null) {
            return subscriberMethods;
        }
        subscriberMethods = new ArrayList<SubscriberMethod>();
        HashMap<String, Class> eventTypesFound = new HashMap<String, Class>();
        StringBuilder methodKeyBuilder = new StringBuilder();
        for (Class<?> clazz = subscriberClass; !(clazz == null || (name = clazz.getName()).startsWith("java.") || name.startsWith("javax.") || name.startsWith("android.")); clazz = clazz.getSuperclass()) {
            try {
                Method[] methods = clazz.getDeclaredMethods();
                this.filterSubscriberMethods(subscriberMethods, eventTypesFound, methodKeyBuilder, methods);
                continue;
            }
            catch (Throwable th) {
                th.printStackTrace();
                Method[] methods = subscriberClass.getMethods();
                subscriberMethods.clear();
                eventTypesFound.clear();
                this.filterSubscriberMethods(subscriberMethods, eventTypesFound, methodKeyBuilder, methods);
                break;
            }
        }
        if (subscriberMethods.isEmpty()) {
            throw new EventBusException("Subscriber " + subscriberClass + " has no public methods called " + ON_EVENT_METHOD_NAME);
        }
        Map<String, List<SubscriberMethod>> map2 = methodCache;
        synchronized (map2) {
            methodCache.put(key, subscriberMethods);
        }
        return subscriberMethods;
    }

    private void filterSubscriberMethods(List<SubscriberMethod> subscriberMethods, HashMap<String, Class> eventTypesFound, StringBuilder methodKeyBuilder, Method[] methods) {
        for (Method method : methods) {
            String methodName = method.getName();
            if (!methodName.startsWith(ON_EVENT_METHOD_NAME)) continue;
            int modifiers = method.getModifiers();
            Class<?> methodClass = method.getDeclaringClass();
            if ((modifiers & 1) != 0 && (modifiers & 0x1448) == 0) {
                ThreadMode threadMode;
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (parameterTypes.length != 1 || (threadMode = this.getThreadMode(methodClass, method, methodName)) == null) continue;
                Class<?> eventType = parameterTypes[0];
                methodKeyBuilder.setLength(0);
                methodKeyBuilder.append(methodName);
                methodKeyBuilder.append('>').append(eventType.getName());
                String methodKey = methodKeyBuilder.toString();
                Class<?> methodClassOld = eventTypesFound.put(methodKey, methodClass);
                if (methodClassOld == null || methodClassOld.isAssignableFrom(methodClass)) {
                    subscriberMethods.add(new SubscriberMethod(method, threadMode, eventType));
                    continue;
                }
                eventTypesFound.put(methodKey, methodClassOld);
                continue;
            }
            if (this.skipMethodVerificationForClasses.containsKey(methodClass)) continue;
            Log.d((String)EventBus.TAG, (String)("Skipping method (not public, static or abstract): " + methodClass + "." + methodName));
        }
    }

    private ThreadMode getThreadMode(Class<?> clazz, Method method, String methodName) {
        ThreadMode threadMode;
        String modifierString = methodName.substring(ON_EVENT_METHOD_NAME.length());
        if (modifierString.length() == 0) {
            threadMode = ThreadMode.PostThread;
        } else if (modifierString.equals("MainThread")) {
            threadMode = ThreadMode.MainThread;
        } else if (modifierString.equals("BackgroundThread")) {
            threadMode = ThreadMode.BackgroundThread;
        } else if (modifierString.equals("Async")) {
            threadMode = ThreadMode.Async;
        } else {
            if (!this.skipMethodVerificationForClasses.containsKey(clazz)) {
                throw new EventBusException("Illegal onEvent method, check for typos: " + method);
            }
            threadMode = null;
        }
        return threadMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clearCaches() {
        Map<String, List<SubscriberMethod>> map = methodCache;
        synchronized (map) {
            methodCache.clear();
        }
    }
}

