/*
 * Decompiled with CFR 0.152.
 */
package de.greenrobot.event;

import android.os.Looper;
import android.util.Log;
import de.greenrobot.event.AsyncPoster;
import de.greenrobot.event.BackgroundPoster;
import de.greenrobot.event.EventBusException;
import de.greenrobot.event.HandlerPoster;
import de.greenrobot.event.NoSubscriberEvent;
import de.greenrobot.event.PendingPost;
import de.greenrobot.event.SubscriberExceptionEvent;
import de.greenrobot.event.SubscriberMethod;
import de.greenrobot.event.SubscriberMethodFinder;
import de.greenrobot.event.Subscription;
import de.greenrobot.event.ThreadMode;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class EventBus {
    static ExecutorService executorService = Executors.newCachedThreadPool();
    public static String TAG = "Event";
    private static volatile EventBus defaultInstance;
    private static final Map<Class<?>, List<Class<?>>> eventTypesCache;
    private final Map<Class<?>, CopyOnWriteArrayList<Subscription>> subscriptionsByEventType;
    private final Map<Object, List<Class<?>>> typesBySubscriber;
    private final Map<Class<?>, Object> stickyEvents;
    private final ThreadLocal<PostingThreadState> currentPostingThreadState = new ThreadLocal<PostingThreadState>(){

        @Override
        protected PostingThreadState initialValue() {
            return new PostingThreadState();
        }
    };
    private String defaultMethodName = "onEvent";
    private final HandlerPoster mainThreadPoster;
    private final BackgroundPoster backgroundPoster;
    private final AsyncPoster asyncPoster;
    private final SubscriberMethodFinder subscriberMethodFinder;
    private boolean subscribed;
    private boolean logSubscriberExceptions = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static EventBus getDefault() {
        if (defaultInstance != null) return defaultInstance;
        Class<EventBus> clazz = EventBus.class;
        synchronized (EventBus.class) {
            if (defaultInstance != null) return defaultInstance;
            defaultInstance = new EventBus();
            // ** MonitorExit[var0] (shouldn't be in output)
            return defaultInstance;
        }
    }

    public static void clearCaches() {
        SubscriberMethodFinder.clearCaches();
        eventTypesCache.clear();
    }

    public static void skipMethodVerificationFor(Class<?> clazz) {
        SubscriberMethodFinder.skipMethodVerificationFor(clazz);
    }

    public static void clearSkipMethodNameVerifications() {
        SubscriberMethodFinder.clearSkipMethodVerifications();
    }

    public EventBus() {
        this.subscriptionsByEventType = new HashMap();
        this.typesBySubscriber = new HashMap();
        this.stickyEvents = new ConcurrentHashMap();
        this.mainThreadPoster = new HandlerPoster(this, Looper.getMainLooper(), 10);
        this.backgroundPoster = new BackgroundPoster(this);
        this.asyncPoster = new AsyncPoster(this);
        this.subscriberMethodFinder = new SubscriberMethodFinder();
    }

    public void configureLogSubscriberExceptions(boolean logSubscriberExceptions) {
        if (this.subscribed) {
            throw new EventBusException("This method must be called before any registration");
        }
        this.logSubscriberExceptions = logSubscriberExceptions;
    }

    public void register(Object subscriber) {
        this.register(subscriber, this.defaultMethodName, false, 0);
    }

    public void register(Object subscriber, int priority) {
        this.register(subscriber, this.defaultMethodName, false, priority);
    }

    @Deprecated
    public void register(Object subscriber, String methodName) {
        this.register(subscriber, methodName, false, 0);
    }

    public void registerSticky(Object subscriber) {
        this.register(subscriber, this.defaultMethodName, true, 0);
    }

    public void registerSticky(Object subscriber, int priority) {
        this.register(subscriber, this.defaultMethodName, true, priority);
    }

    @Deprecated
    public void registerSticky(Object subscriber, String methodName) {
        this.register(subscriber, methodName, true, 0);
    }

    private synchronized void register(Object subscriber, String methodName, boolean sticky, int priority) {
        List<SubscriberMethod> subscriberMethods = this.subscriberMethodFinder.findSubscriberMethods(subscriber.getClass(), methodName);
        for (SubscriberMethod subscriberMethod : subscriberMethods) {
            this.subscribe(subscriber, subscriberMethod, sticky, priority);
        }
    }

    @Deprecated
    public void register(Object subscriber, Class<?> eventType, Class<?> ... moreEventTypes) {
        this.register(subscriber, this.defaultMethodName, false, eventType, moreEventTypes);
    }

    @Deprecated
    public void register(Object subscriber, String methodName, Class<?> eventType, Class<?> ... moreEventTypes) {
        this.register(subscriber, methodName, false, eventType, moreEventTypes);
    }

    @Deprecated
    public void registerSticky(Object subscriber, Class<?> eventType, Class<?> ... moreEventTypes) {
        this.register(subscriber, this.defaultMethodName, true, eventType, moreEventTypes);
    }

    @Deprecated
    public void registerSticky(Object subscriber, String methodName, Class<?> eventType, Class<?> ... moreEventTypes) {
        this.register(subscriber, methodName, true, eventType, moreEventTypes);
    }

    private synchronized void register(Object subscriber, String methodName, boolean sticky, Class<?> eventType, Class<?> ... moreEventTypes) {
        Class<?> subscriberClass = subscriber.getClass();
        List<SubscriberMethod> subscriberMethods = this.subscriberMethodFinder.findSubscriberMethods(subscriberClass, methodName);
        block0: for (SubscriberMethod subscriberMethod : subscriberMethods) {
            if (eventType == subscriberMethod.eventType) {
                this.subscribe(subscriber, subscriberMethod, sticky, 0);
                continue;
            }
            if (moreEventTypes == null) continue;
            for (Class<?> eventType2 : moreEventTypes) {
                if (eventType2 != subscriberMethod.eventType) continue;
                this.subscribe(subscriber, subscriberMethod, sticky, 0);
                continue block0;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe(Object subscriber, SubscriberMethod subscriberMethod, boolean sticky, int priority) {
        List<Class<?>> subscribedEvents;
        this.subscribed = true;
        Class<?> eventType = subscriberMethod.eventType;
        CopyOnWriteArrayList<Subscription> subscriptions = this.subscriptionsByEventType.get(eventType);
        Subscription newSubscription = new Subscription(subscriber, subscriberMethod, priority);
        if (subscriptions == null) {
            subscriptions = new CopyOnWriteArrayList();
            this.subscriptionsByEventType.put(eventType, subscriptions);
        } else {
            for (Subscription subscription : subscriptions) {
                if (!subscription.equals(newSubscription)) continue;
                throw new EventBusException("Subscriber " + subscriber.getClass() + " already registered to event " + eventType);
            }
        }
        int size = subscriptions.size();
        for (int i = 0; i <= size; ++i) {
            if (i != size && newSubscription.priority <= subscriptions.get((int)i).priority) continue;
            subscriptions.add(i, newSubscription);
            break;
        }
        if ((subscribedEvents = this.typesBySubscriber.get(subscriber)) == null) {
            subscribedEvents = new ArrayList();
            this.typesBySubscriber.put(subscriber, subscribedEvents);
        }
        subscribedEvents.add(eventType);
        if (sticky) {
            Object stickyEvent;
            Map<Class<?>, Object> map = this.stickyEvents;
            synchronized (map) {
                stickyEvent = this.stickyEvents.get(eventType);
            }
            if (stickyEvent != null) {
                this.postToSubscription(newSubscription, stickyEvent, Looper.getMainLooper() == Looper.myLooper());
            }
        }
    }

    public synchronized boolean isRegistered(Object subscriber) {
        return this.typesBySubscriber.containsKey(subscriber);
    }

    @Deprecated
    public synchronized void unregister(Object subscriber, Class<?> ... eventTypes) {
        if (eventTypes.length == 0) {
            throw new IllegalArgumentException("Provide at least one event class");
        }
        List<Class<?>> subscribedClasses = this.typesBySubscriber.get(subscriber);
        if (subscribedClasses != null) {
            for (Class<?> eventType : eventTypes) {
                this.unubscribeByEventType(subscriber, eventType);
                subscribedClasses.remove(eventType);
            }
            if (subscribedClasses.isEmpty()) {
                this.typesBySubscriber.remove(subscriber);
            }
        } else {
            Log.w((String)TAG, (String)("Subscriber to unregister was not registered before: " + subscriber.getClass()));
        }
    }

    private void unubscribeByEventType(Object subscriber, Class<?> eventType) {
        List subscriptions = this.subscriptionsByEventType.get(eventType);
        if (subscriptions != null) {
            int size = subscriptions.size();
            for (int i = 0; i < size; ++i) {
                Subscription subscription = (Subscription)subscriptions.get(i);
                if (subscription.subscriber != subscriber) continue;
                subscription.active = false;
                subscriptions.remove(i);
                --i;
                --size;
            }
        }
    }

    public synchronized void unregister(Object subscriber) {
        List<Class<?>> subscribedTypes = this.typesBySubscriber.get(subscriber);
        if (subscribedTypes != null) {
            for (Class<?> eventType : subscribedTypes) {
                this.unubscribeByEventType(subscriber, eventType);
            }
            this.typesBySubscriber.remove(subscriber);
        } else {
            Log.w((String)TAG, (String)("Subscriber to unregister was not registered before: " + subscriber.getClass()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post(Object event) {
        PostingThreadState postingState = this.currentPostingThreadState.get();
        List<Object> eventQueue = postingState.eventQueue;
        eventQueue.add(event);
        if (postingState.isPosting) {
            return;
        }
        postingState.isMainThread = Looper.getMainLooper() == Looper.myLooper();
        postingState.isPosting = true;
        if (postingState.canceled) {
            throw new EventBusException("Internal error. Abort state was not reset");
        }
        try {
            while (!eventQueue.isEmpty()) {
                this.postSingleEvent(eventQueue.remove(0), postingState);
            }
        }
        finally {
            postingState.isPosting = false;
            postingState.isMainThread = false;
        }
    }

    public void cancelEventDelivery(Object event) {
        PostingThreadState postingState = this.currentPostingThreadState.get();
        if (!postingState.isPosting) {
            throw new EventBusException("This method may only be called from inside event handling methods on the posting thread");
        }
        if (event == null) {
            throw new EventBusException("Event may not be null");
        }
        if (postingState.event != event) {
            throw new EventBusException("Only the currently handled event may be aborted");
        }
        if (postingState.subscription.subscriberMethod.threadMode != ThreadMode.PostThread) {
            throw new EventBusException(" event handlers may only abort the incoming event");
        }
        postingState.canceled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postSticky(Object event) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.put(event.getClass(), event);
        }
        this.post(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getStickyEvent(Class<T> eventType) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return eventType.cast(this.stickyEvents.get(eventType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T removeStickyEvent(Class<T> eventType) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            return eventType.cast(this.stickyEvents.remove(eventType));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeStickyEvent(Object event) {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            Class<?> eventType = event.getClass();
            Object existingEvent = this.stickyEvents.get(eventType);
            if (event.equals(existingEvent)) {
                this.stickyEvents.remove(eventType);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllStickyEvents() {
        Map<Class<?>, Object> map = this.stickyEvents;
        synchronized (map) {
            this.stickyEvents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postSingleEvent(Object event, PostingThreadState postingState) throws Error {
        Class<?> eventClass = event.getClass();
        List<Class<?>> eventTypes = this.findEventTypes(eventClass);
        boolean subscriptionFound = false;
        int countTypes = eventTypes.size();
        for (int h = 0; h < countTypes; ++h) {
            CopyOnWriteArrayList<Subscription> subscriptions;
            Class<?> clazz = eventTypes.get(h);
            EventBus eventBus = this;
            synchronized (eventBus) {
                subscriptions = this.subscriptionsByEventType.get(clazz);
            }
            if (subscriptions == null || subscriptions.isEmpty()) continue;
            for (Subscription subscription : subscriptions) {
                postingState.event = event;
                postingState.subscription = subscription;
                boolean aborted = false;
                try {
                    this.postToSubscription(subscription, event, postingState.isMainThread);
                    aborted = postingState.canceled;
                }
                finally {
                    postingState.event = null;
                    postingState.subscription = null;
                    postingState.canceled = false;
                }
                if (!aborted) continue;
                break;
            }
            subscriptionFound = true;
        }
        if (!subscriptionFound) {
            Log.d((String)TAG, (String)("No subscribers registered for event " + eventClass));
            if (eventClass != NoSubscriberEvent.class && eventClass != SubscriberExceptionEvent.class) {
                this.post(new NoSubscriberEvent(this, event));
            }
        }
    }

    private void postToSubscription(Subscription subscription, Object event, boolean isMainThread) {
        switch (subscription.subscriberMethod.threadMode) {
            case PostThread: {
                this.invokeSubscriber(subscription, event);
                break;
            }
            case MainThread: {
                if (isMainThread) {
                    this.invokeSubscriber(subscription, event);
                    break;
                }
                this.mainThreadPoster.enqueue(subscription, event);
                break;
            }
            case BackgroundThread: {
                if (isMainThread) {
                    this.backgroundPoster.enqueue(subscription, event);
                    break;
                }
                this.invokeSubscriber(subscription, event);
                break;
            }
            case Async: {
                this.asyncPoster.enqueue(subscription, event);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown thread mode: " + (Object)((Object)subscription.subscriberMethod.threadMode));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Class<?>> findEventTypes(Class<?> eventClass) {
        Map<Class<?>, List<Class<?>>> map = eventTypesCache;
        synchronized (map) {
            List<Class<?>> eventTypes = eventTypesCache.get(eventClass);
            if (eventTypes == null) {
                eventTypes = new ArrayList();
                for (Class<?> clazz = eventClass; clazz != null; clazz = clazz.getSuperclass()) {
                    eventTypes.add(clazz);
                    EventBus.addInterfaces(eventTypes, clazz.getInterfaces());
                }
                eventTypesCache.put(eventClass, eventTypes);
            }
            return eventTypes;
        }
    }

    static void addInterfaces(List<Class<?>> eventTypes, Class<?>[] interfaces) {
        for (Class<?> interfaceClass : interfaces) {
            if (eventTypes.contains(interfaceClass)) continue;
            eventTypes.add(interfaceClass);
            EventBus.addInterfaces(eventTypes, interfaceClass.getInterfaces());
        }
    }

    void invokeSubscriber(PendingPost pendingPost) {
        Object event = pendingPost.event;
        Subscription subscription = pendingPost.subscription;
        PendingPost.releasePendingPost(pendingPost);
        if (subscription.active) {
            this.invokeSubscriber(subscription, event);
        }
    }

    void invokeSubscriber(Subscription subscription, Object event) throws Error {
        try {
            subscription.subscriberMethod.method.invoke(subscription.subscriber, event);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (event instanceof SubscriberExceptionEvent) {
                Log.e((String)TAG, (String)("SubscriberExceptionEvent subscriber " + subscription.subscriber.getClass() + " threw an exception"), (Throwable)cause);
                SubscriberExceptionEvent exEvent = (SubscriberExceptionEvent)event;
                Log.e((String)TAG, (String)("Initial event " + exEvent.causingEvent + " caused exception in " + exEvent.causingSubscriber), (Throwable)exEvent.throwable);
            } else {
                if (this.logSubscriberExceptions) {
                    Log.e((String)TAG, (String)("Could not dispatch event: " + event.getClass() + " to subscribing class " + subscription.subscriber.getClass()), (Throwable)cause);
                }
                SubscriberExceptionEvent exEvent = new SubscriberExceptionEvent(this, cause, event, subscription.subscriber);
                this.post(exEvent);
            }
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("Unexpected exception", e);
        }
    }

    static {
        eventTypesCache = new HashMap();
    }

    static interface PostCallback {
        public void onPostCompleted(List<SubscriberExceptionEvent> var1);
    }

    static final class PostingThreadState {
        List<Object> eventQueue = new ArrayList<Object>();
        boolean isPosting;
        boolean isMainThread;
        Subscription subscription;
        Object event;
        boolean canceled;

        PostingThreadState() {
        }
    }
}

