/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.service;

import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.DatastreamDao;
import de.fraunhofer.iosb.ilt.sta.dao.FeatureOfInterestDao;
import de.fraunhofer.iosb.ilt.sta.dao.HistoricalLocationDao;
import de.fraunhofer.iosb.ilt.sta.dao.LocationDao;
import de.fraunhofer.iosb.ilt.sta.dao.MultiDatastreamDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservationDao;
import de.fraunhofer.iosb.ilt.sta.dao.ObservedPropertyDao;
import de.fraunhofer.iosb.ilt.sta.dao.SensorDao;
import de.fraunhofer.iosb.ilt.sta.dao.ThingDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.DataArrayDocument;
import de.fraunhofer.iosb.ilt.sta.service.TokenManager;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class SensorThingsService {
    private URI endpoint;
    private CloseableHttpClient client;
    private TokenManager tokenManager;

    public SensorThingsService() {
        this.client = HttpClients.createSystem();
    }

    public SensorThingsService(URL endpoint) throws URISyntaxException {
        this.endpoint = new URI(endpoint.toString() + "/").normalize();
        this.client = HttpClients.createSystem();
    }

    public void setEndpoint(URI endpoint) throws URISyntaxException {
        if (this.endpoint != null) {
            throw new IllegalStateException("endpoint URI already set.");
        }
        this.endpoint = new URI(endpoint.toString() + "/").normalize();
    }

    public URI getEndpoint() {
        if (this.endpoint == null) {
            throw new IllegalStateException("endpoint URI not set.");
        }
        return this.endpoint;
    }

    public String getPath(Entity<?> parent, EntityType relation) {
        if (parent == null) {
            return relation.getName();
        }
        if (!parent.getType().hasRelationTo(relation)) {
            throw new IllegalArgumentException("Entity of type " + (Object)((Object)parent.getType()) + " has no relation of type " + (Object)((Object)relation) + ".");
        }
        if (parent.getId() == null) {
            throw new IllegalArgumentException("Can not create a path with a parent without id.");
        }
        return String.format("%s(%s)/%s", EntityType.listForClass(parent.getClass()).getName(), parent.getId().getUrl(), relation.getName());
    }

    public URI getFullPath(Entity<?> parent, EntityType relation) {
        return this.getEndpoint().resolve(this.getPath(parent, relation));
    }

    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException {
        if (this.tokenManager != null) {
            this.tokenManager.addAuthHeader(request);
        }
        return this.client.execute(request);
    }

    public DatastreamDao datastreams() {
        return new DatastreamDao(this);
    }

    public MultiDatastreamDao multiDatastreams() {
        return new MultiDatastreamDao(this);
    }

    public FeatureOfInterestDao featuresOfInterest() {
        return new FeatureOfInterestDao(this);
    }

    public HistoricalLocationDao historicalLocations() {
        return new HistoricalLocationDao(this);
    }

    public LocationDao locations() {
        return new LocationDao(this);
    }

    public ObservationDao observations() {
        return new ObservationDao(this);
    }

    public ObservedPropertyDao observedProperties() {
        return new ObservedPropertyDao(this);
    }

    public SensorDao sensors() {
        return new SensorDao(this);
    }

    public ThingDao things() {
        return new ThingDao(this);
    }

    public List<String> create(DataArrayDocument dataArray) throws ServiceFailureException {
        return new ObservationDao(this).create(dataArray);
    }

    public <T extends Entity<T>> void create(T entity) throws ServiceFailureException {
        entity.getDao(this).create(entity);
    }

    public <T extends Entity<T>> void update(T entity) throws ServiceFailureException {
        entity.getDao(this).update(entity);
    }

    public <T extends Entity<T>> void delete(T entity) throws ServiceFailureException {
        entity.getDao(this).delete(entity);
    }

    public SensorThingsService setTokenManager(TokenManager tokenManager) {
        if (tokenManager != null && tokenManager.getHttpClient() == null) {
            tokenManager.setHttpClient(this.client);
        }
        this.tokenManager = tokenManager;
        return this;
    }

    public TokenManager getTokenManager() {
        return this.tokenManager;
    }

    public CloseableHttpClient getClient() {
        return this.client;
    }

    public void setClient(CloseableHttpClient client) {
        this.client = client;
    }
}

