/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.query;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.query.Expansion;
import de.fraunhofer.iosb.ilt.sta.query.QueryParameter;
import de.fraunhofer.iosb.ilt.sta.query.QueryRequest;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Query<T extends Entity<T>>
implements QueryRequest<T>,
QueryParameter<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Query.class);
    private final SensorThingsService service;
    private final EntityType plural;
    private final Class<T> entityClass;
    private final Entity<?> parent;
    private final List<NameValuePair> params = new ArrayList<NameValuePair>();

    public Query(SensorThingsService service, Class<T> entityClass) {
        this(service, entityClass, null);
    }

    public Query(SensorThingsService service, Class<T> entityClass, Entity<?> parent) {
        this.service = service;
        this.plural = EntityType.listForClass(entityClass);
        this.entityClass = entityClass;
        this.parent = parent;
    }

    public EntityType getEntityType() {
        return this.plural;
    }

    public Class<T> getEntityClass() {
        return this.entityClass;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    private void removeAllParams(String key) {
        Iterator<NameValuePair> it = this.params.iterator();
        while (it.hasNext()) {
            NameValuePair param = it.next();
            if (!param.getName().equals(key)) continue;
            it.remove();
            break;
        }
    }

    @Override
    public Query<T> filter(String options) {
        this.removeAllParams("$filter");
        if (options.isEmpty()) {
            return this;
        }
        this.params.add((NameValuePair)new BasicNameValuePair("$filter", options));
        return this;
    }

    @Override
    public Query<T> top(int n) {
        this.removeAllParams("$top");
        this.params.add((NameValuePair)new BasicNameValuePair("$top", Integer.toString(n)));
        return this;
    }

    @Override
    public Query<T> orderBy(String clause) {
        this.removeAllParams("$orderby");
        this.params.add((NameValuePair)new BasicNameValuePair("$orderby", clause));
        return this;
    }

    @Override
    public Query<T> skip(int n) {
        this.removeAllParams("$skip");
        this.params.add((NameValuePair)new BasicNameValuePair("$skip", Integer.toString(n)));
        return this;
    }

    @Override
    public Query<T> count() {
        this.removeAllParams("$count");
        this.params.add((NameValuePair)new BasicNameValuePair("$count", "true"));
        return this;
    }

    public Query<T> expand(Expansion expansion) {
        this.removeAllParams("$expand");
        this.params.add((NameValuePair)new BasicNameValuePair("$expand", expansion.toString()));
        return this;
    }

    public Query<T> expand(String expansion) {
        this.removeAllParams("$expand");
        this.params.add((NameValuePair)new BasicNameValuePair("$expand", expansion));
        return this;
    }

    public Query<T> select(String ... fields) {
        this.removeAllParams("$select");
        StringBuilder selectValue = new StringBuilder();
        for (String field : fields) {
            selectValue.append(field).append(",");
        }
        this.params.add((NameValuePair)new BasicNameValuePair("$select", selectValue.substring(0, selectValue.length() - 1)));
        return this;
    }

    @Override
    public T first() throws ServiceFailureException {
        this.top(1);
        List<T> asList = this.list().toList();
        if (asList.isEmpty()) {
            return null;
        }
        return (T)((Entity)asList.get(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityList<T> list() throws ServiceFailureException {
        EntityList list = new EntityList(this.plural);
        URIBuilder uriBuilder = new URIBuilder(this.service.getFullPath(this.parent, this.plural));
        uriBuilder.addParameters(this.params);
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(uriBuilder.build());
            LOGGER.debug("Fetching: {}", (Object)httpGet.getURI());
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            response = this.service.execute((HttpUriRequest)httpGet);
            int code = response.getStatusLine().getStatusCode();
            if (code < 200 || code >= 300) {
                LOGGER.error("Failed on query: {}", (Object)uriBuilder.build());
                throw new IllegalArgumentException(EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8));
            }
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            ObjectMapper mapper = ObjectMapperFactory.get();
            list = (EntityList)mapper.readValue(json, this.plural.getTypeReference());
        }
        catch (IOException | URISyntaxException ex) {
            LOGGER.error("Failed to fetch list.", (Throwable)ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
        list.setService(this.service, this.entityClass);
        return list;
    }
}

