/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.query;

import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.query.InvalidRelationException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class ExpandedEntity {
    private final List<EntityType> entities;

    private ExpandedEntity(EntityType ... entities) throws InvalidRelationException {
        this.entities = new ArrayList<EntityType>(entities.length);
        for (int i = 0; i < entities.length; ++i) {
            if (i > 0 && !entities[i].hasRelationTo(entities[i - 1])) {
                throw new InvalidRelationException(String.format("%s is not directly related to %s", entities[i].getName(), entities[i - 1].getName()));
            }
            this.entities.add(entities[i]);
        }
    }

    public static ExpandedEntity from(EntityType ... entities) throws InvalidRelationException {
        return new ExpandedEntity(entities);
    }

    public String toString() {
        return this.entities.stream().map(e -> e.getName()).collect(Collectors.joining("/"));
    }

    public EntityType getDirectSibling() {
        return this.entities.get(0);
    }
}

