/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.builder.api;

import com.fasterxml.jackson.annotation.JsonValue;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.AbstractDatastreamBuilder;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.EntityBuilder;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.geojson.Polygon;
import org.threeten.extra.Interval;

public abstract class AbstractMultiDatastreamBuilder<U extends AbstractMultiDatastreamBuilder<U>>
extends EntityBuilder<MultiDatastream, U> {
    @Override
    protected MultiDatastream newBuildingInstance() {
        return new MultiDatastream();
    }

    @Override
    public MultiDatastream build() {
        ((MultiDatastream)this.getBuildingInstance()).setObservationType(ValueCode.OM_ComplexObservation.getValue());
        return (MultiDatastream)super.build();
    }

    public U name(String name) {
        ((MultiDatastream)this.getBuildingInstance()).setName(name);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U description(String description) {
        ((MultiDatastream)this.getBuildingInstance()).setDescription(description);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U unitOfMeasurements(List<UnitOfMeasurement> unitOfMeasurements) {
        ((MultiDatastream)this.getBuildingInstance()).setUnitOfMeasurements(unitOfMeasurements);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U unitOfMeasurement(UnitOfMeasurement unitOfMeasurement) {
        if (((MultiDatastream)this.getBuildingInstance()).getUnitOfMeasurements() == null) {
            ((MultiDatastream)this.getBuildingInstance()).setUnitOfMeasurements(new ArrayList<UnitOfMeasurement>());
        }
        ((MultiDatastream)this.getBuildingInstance()).getUnitOfMeasurements().add(unitOfMeasurement);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U observedArea(Polygon observedArea) {
        ((MultiDatastream)this.getBuildingInstance()).setObservedArea(observedArea);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U phenomenonTime(Interval phenomenonTime) {
        ((MultiDatastream)this.getBuildingInstance()).setPhenomenonTime(phenomenonTime);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U resultTime(Interval resultTime) {
        ((MultiDatastream)this.getBuildingInstance()).setResultTime(resultTime);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U multiObservationDataTypes(List<AbstractDatastreamBuilder.ValueCode> valueCodes) {
        ((MultiDatastream)this.getBuildingInstance()).setMultiObservationDataTypes(valueCodes.stream().map(AbstractDatastreamBuilder.ValueCode::getValue).collect(Collectors.toList()));
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U multiObservationDataType(AbstractDatastreamBuilder.ValueCode valueCode) {
        if (((MultiDatastream)this.getBuildingInstance()).getMultiObservationDataTypes() == null) {
            ((MultiDatastream)this.getBuildingInstance()).setMultiObservationDataTypes(new ArrayList<String>());
        }
        ((MultiDatastream)this.getBuildingInstance()).getMultiObservationDataTypes().add(valueCode.getValue());
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U sensor(Sensor sensor) {
        ((MultiDatastream)this.getBuildingInstance()).setSensor(sensor);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U thing(Thing thing) {
        ((MultiDatastream)this.getBuildingInstance()).setThing(thing);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U observedProperties(List<ObservedProperty> observedProperties) {
        ((MultiDatastream)this.getBuildingInstance()).getObservedProperties().addAll((Collection<ObservedProperty>)observedProperties);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U observedProperty(ObservedProperty observedProperty) {
        ((MultiDatastream)this.getBuildingInstance()).getObservedProperties().add(observedProperty);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U observations(List<Observation> observations) {
        ((MultiDatastream)this.getBuildingInstance()).getObservations().addAll((Collection<Observation>)observations);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public U observation(Observation observation) {
        ((MultiDatastream)this.getBuildingInstance()).getObservations().add(observation);
        return (U)((AbstractMultiDatastreamBuilder)this.getSelf());
    }

    public static enum ValueCode {
        OM_ComplexObservation("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_ComplexObservation");

        private final String value;

        private ValueCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

