/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model.builder.api;

import com.fasterxml.jackson.annotation.JsonValue;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.builder.api.EntityBuilder;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import java.util.Collection;
import java.util.List;
import org.geojson.Polygon;
import org.threeten.extra.Interval;

public abstract class AbstractDatastreamBuilder<U extends AbstractDatastreamBuilder<U>>
extends EntityBuilder<Datastream, U> {
    @Override
    protected Datastream newBuildingInstance() {
        return new Datastream();
    }

    public U name(String name) {
        ((Datastream)this.getBuildingInstance()).setName(name);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U description(String description) {
        ((Datastream)this.getBuildingInstance()).setDescription(description);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U observationType(ValueCode observationType) {
        ((Datastream)this.getBuildingInstance()).setObservationType(observationType.getValue());
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U unitOfMeasurement(UnitOfMeasurement unitOfMeasurement) {
        ((Datastream)this.getBuildingInstance()).setUnitOfMeasurement(unitOfMeasurement);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U observedArea(Polygon observedArea) {
        ((Datastream)this.getBuildingInstance()).setObservedArea(observedArea);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U phenomenonTime(Interval phenomenonTime) {
        ((Datastream)this.getBuildingInstance()).setPhenomenonTime(phenomenonTime);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U resultTime(Interval resultTime) {
        ((Datastream)this.getBuildingInstance()).setResultTime(resultTime);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U sensor(Sensor sensor) {
        ((Datastream)this.getBuildingInstance()).setSensor(sensor);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U thing(Thing thing) {
        ((Datastream)this.getBuildingInstance()).setThing(thing);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U observedProperty(ObservedProperty observedProperty) {
        ((Datastream)this.getBuildingInstance()).setObservedProperty(observedProperty);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U observations(List<Observation> observations) {
        ((Datastream)this.getBuildingInstance()).getObservations().addAll((Collection<Observation>)observations);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public U observation(Observation observation) {
        ((Datastream)this.getBuildingInstance()).getObservations().add(observation);
        return (U)((AbstractDatastreamBuilder)this.getSelf());
    }

    public static enum ValueCode {
        OM_CategoryObservation("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CategoryObservation"),
        OM_CountObservation("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_CountObservation"),
        OM_Measurement("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Measurement"),
        OM_Observation("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_Observation"),
        OM_TruthObservation("http://www.opengis.net/def/observationType/OGC-OM/2.0/OM_TruthObservation");

        private final String value;

        private ValueCode(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }
    }
}

