/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.ThingDao;
import de.fraunhofer.iosb.ilt.sta.model.Datastream;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.HistoricalLocation;
import de.fraunhofer.iosb.ilt.sta.model.Location;
import de.fraunhofer.iosb.ilt.sta.model.MultiDatastream;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.Map;
import java.util.Objects;

public class Thing
extends Entity<Thing> {
    private String name;
    private String description;
    private Map<String, Object> properties;
    @JsonProperty(value="Locations")
    private EntityList<Location> locations = new EntityList(EntityType.LOCATIONS);
    @JsonProperty(value="HistoricalLocations")
    private EntityList<HistoricalLocation> historicalLocations = new EntityList(EntityType.HISTORICAL_LOCATIONS);
    @JsonProperty(value="Datastreams")
    private EntityList<Datastream> datastreams = new EntityList(EntityType.DATASTREAMS);
    @JsonProperty(value="MultiDatastreams")
    private EntityList<MultiDatastream> multiDatastreams = new EntityList(EntityType.MULTIDATASTREAMS);

    public Thing() {
        super(EntityType.THING);
    }

    public Thing(String name, String description) {
        this();
        this.name = name;
        this.description = description;
    }

    public Thing(String name, String description, Map<String, Object> properties) {
        this(name, description);
        this.properties = properties;
    }

    public Thing(String name, String description, Map<String, Object> properties, EntityList<Location> locations, EntityList<HistoricalLocation> historicalLocations, EntityList<Datastream> datastreams) {
        this(name, description, properties);
        this.locations = locations;
        this.historicalLocations = historicalLocations;
        this.datastreams = datastreams;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Thing other = (Thing)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 97 * hash + Objects.hashCode(this.name);
        hash = 97 * hash + Objects.hashCode(this.description);
        hash = 97 * hash + Objects.hashCode(this.properties);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public BaseDao<Location> locations() {
        return this.getService().locations().setParent(this);
    }

    public EntityList<Location> getLocations() {
        return this.locations;
    }

    public void setLocations(EntityList<Location> locations) {
        this.locations = locations;
    }

    public BaseDao<HistoricalLocation> historicalLocations() {
        return this.getService().historicalLocations().setParent(this);
    }

    public EntityList<HistoricalLocation> getHistoricalLocations() {
        return this.historicalLocations;
    }

    public void setHistoricalLocations(EntityList<HistoricalLocation> historicalLocations) {
        this.historicalLocations = historicalLocations;
    }

    public BaseDao<Datastream> datastreams() {
        return this.getService().datastreams().setParent(this);
    }

    public EntityList<Datastream> getDatastreams() {
        return this.datastreams;
    }

    public void setDatastreams(EntityList<Datastream> datastreams) {
        this.datastreams = datastreams;
    }

    public BaseDao<MultiDatastream> multiDatastreams() {
        return this.getService().multiDatastreams().setParent(this);
    }

    public EntityList<MultiDatastream> getMultiDatastreams() {
        return this.multiDatastreams;
    }

    public void setMultiDatastreams(EntityList<MultiDatastream> multiDatastreams) {
        this.multiDatastreams = multiDatastreams;
    }

    public ThingDao getDao(SensorThingsService service) {
        return new ThingDao(service);
    }

    @Override
    public Thing withOnlyId() {
        Thing copy = new Thing();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

