/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.net.URI;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class Entity<T extends Entity<T>> {
    @JsonProperty(value="@iot.id")
    protected Id id;
    @JsonProperty(value="@iot.selfLink", access=JsonProperty.Access.READ_ONLY)
    protected URI selfLink;
    @JsonIgnore
    private final EntityType type;
    @JsonIgnore
    private SensorThingsService service;

    public Entity(EntityType type) {
        this.type = type;
    }

    public Entity(EntityType type, Id id) {
        this.type = type;
        this.id = id;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Entity other = (Entity)obj;
        if (!Objects.equals(this.id, other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + Objects.hashCode(this.id);
        hash = 13 * hash + Objects.hashCode((Object)this.type);
        return hash;
    }

    public EntityType getType() {
        return this.type;
    }

    public Id getId() {
        return this.id;
    }

    public void setId(Id id) {
        this.id = id;
    }

    public URI getSelfLink() {
        return this.selfLink;
    }

    public void setSelfLink(URI selfLink) {
        this.selfLink = selfLink;
    }

    public void setService(SensorThingsService service) {
        this.service = service;
    }

    public SensorThingsService getService() {
        return this.service;
    }

    public abstract BaseDao<T> getDao(SensorThingsService var1);

    public abstract T withOnlyId();

    public String toString() {
        if (this.id == null) {
            return "no id";
        }
        return this.id.toString();
    }
}

