/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.BaseDao;
import de.fraunhofer.iosb.ilt.sta.dao.DatastreamDao;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Observation;
import de.fraunhofer.iosb.ilt.sta.model.ObservedProperty;
import de.fraunhofer.iosb.ilt.sta.model.Sensor;
import de.fraunhofer.iosb.ilt.sta.model.Thing;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import de.fraunhofer.iosb.ilt.sta.model.ext.UnitOfMeasurement;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.util.Map;
import java.util.Objects;
import org.geojson.Polygon;
import org.threeten.extra.Interval;

public class Datastream
extends Entity<Datastream> {
    private String name;
    private String description;
    private String observationType;
    private UnitOfMeasurement unitOfMeasurement;
    private Polygon observedArea;
    private Interval phenomenonTime;
    private Map<String, Object> properties;
    private Interval resultTime;
    @JsonProperty(value="Thing")
    private Thing thing;
    @JsonProperty(value="Sensor")
    private Sensor sensor;
    @JsonProperty(value="ObservedProperty")
    private ObservedProperty observedProperty;
    @JsonProperty(value="Observations")
    private EntityList<Observation> observations = new EntityList(EntityType.OBSERVATIONS);

    public Datastream() {
        super(EntityType.DATASTREAM);
    }

    public Datastream(String name, String description, String observationType, UnitOfMeasurement unitOfMeasurement) {
        this();
        this.name = name;
        this.description = description;
        this.observationType = observationType;
        this.unitOfMeasurement = unitOfMeasurement;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Datastream other = (Datastream)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.description, other.description)) {
            return false;
        }
        if (!Objects.equals(this.observationType, other.observationType)) {
            return false;
        }
        if (!Objects.equals(this.unitOfMeasurement, other.unitOfMeasurement)) {
            return false;
        }
        if (!Objects.equals(this.properties, other.properties)) {
            return false;
        }
        if (!Objects.equals(this.resultTime, other.resultTime)) {
            return false;
        }
        return super.equals(obj);
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 17 * hash + Objects.hashCode(this.name);
        hash = 17 * hash + Objects.hashCode(this.description);
        hash = 17 * hash + Objects.hashCode(this.observationType);
        hash = 17 * hash + Objects.hashCode(this.unitOfMeasurement);
        hash = 17 * hash + Objects.hashCode(this.properties);
        hash = 17 * hash + Objects.hashCode(this.resultTime);
        return hash;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getObservationType() {
        return this.observationType;
    }

    public void setObservationType(String observationType) {
        this.observationType = observationType;
    }

    public Map<String, Object> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, Object> properties) {
        this.properties = properties;
    }

    public UnitOfMeasurement getUnitOfMeasurement() {
        return this.unitOfMeasurement;
    }

    public void setUnitOfMeasurement(UnitOfMeasurement unitOfMeasurement) {
        this.unitOfMeasurement = unitOfMeasurement;
    }

    public Polygon getObservedArea() {
        return this.observedArea;
    }

    public void setObservedArea(Polygon observedArea) {
        this.observedArea = observedArea;
    }

    public Interval getPhenomenonTime() {
        return this.phenomenonTime;
    }

    public void setPhenomenonTime(Interval phenomenonTime) {
        this.phenomenonTime = phenomenonTime;
    }

    public Interval getResultTime() {
        return this.resultTime;
    }

    public void setResultTime(Interval resultTime) {
        this.resultTime = resultTime;
    }

    public Thing getThing() throws ServiceFailureException {
        if (this.thing == null && this.getService() != null) {
            this.thing = (Thing)this.getService().things().find(this);
        }
        return this.thing;
    }

    public void setThing(Thing thing) {
        this.thing = thing;
    }

    public Sensor getSensor() throws ServiceFailureException {
        if (this.sensor == null && this.getService() != null) {
            this.sensor = (Sensor)this.getService().sensors().find(this);
        }
        return this.sensor;
    }

    public void setSensor(Sensor sensor) {
        this.sensor = sensor;
    }

    public ObservedProperty getObservedProperty() throws ServiceFailureException {
        if (this.observedProperty == null && this.getService() != null) {
            this.observedProperty = (ObservedProperty)this.getService().observedProperties().find(this);
        }
        return this.observedProperty;
    }

    public void setObservedProperty(ObservedProperty observedProperty) {
        this.observedProperty = observedProperty;
    }

    public BaseDao<Observation> observations() {
        return this.getService().observations().setParent(this);
    }

    public EntityList<Observation> getObservations() {
        return this.observations;
    }

    public void setObservations(EntityList<Observation> observations) {
        this.observations = observations;
    }

    @Override
    public BaseDao<Datastream> getDao(SensorThingsService service) {
        return new DatastreamDao(service);
    }

    @Override
    public Datastream withOnlyId() {
        Datastream copy = new Datastream();
        copy.setId(this.id);
        return copy;
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getName();
    }
}

