/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.jackson;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import de.fraunhofer.iosb.ilt.sta.jackson.EntityListDeserializer;
import de.fraunhofer.iosb.ilt.sta.jackson.EntityModule;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;

public final class ObjectMapperFactory {
    private static ObjectMapper mapper;

    private ObjectMapperFactory() {
    }

    public static ObjectMapper get() {
        if (mapper == null) {
            mapper = new ObjectMapper();
            mapper.setSerializationInclusion(JsonInclude.Include.NON_EMPTY);
            mapper.disable(SerializationFeature.WRITE_NULL_MAP_VALUES);
            mapper.registerModule((Module)new JavaTimeModule());
            mapper.registerModule((Module)new EntityModule());
            mapper.disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
            SimpleModule m = new SimpleModule(new Version(0, 0, 1, null, null, null));
            m.addDeserializer(EntityList.class, new EntityListDeserializer());
            mapper.registerModule((Module)m);
        }
        return mapper;
    }
}

