/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import java.io.IOException;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntitySerializer
extends JsonSerializer<Entity> {
    private static final Logger logger = LoggerFactory.getLogger(EntitySerializer.class);

    public void serialize(Entity entity, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
        gen.writeStartObject();
        SerializationConfig config = serializers.getConfig();
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(serializers.constructType(entity.getClass()));
        for (BeanPropertyDefinition def : beanDesc.findProperties()) {
            Object rawValue = def.getAccessor().getValue((Object)entity);
            if (rawValue == null) continue;
            if (rawValue instanceof Entity) {
                Entity subEntity = (Entity)rawValue;
                if (subEntity.getId() != null) {
                    gen.writeFieldName(rawValue.getClass().getSimpleName());
                    gen.writeStartObject();
                    gen.writeFieldName("@iot.id");
                    ((Entity)rawValue).getId().writeTo(gen);
                    gen.writeEndObject();
                    continue;
                }
                gen.writeFieldName(rawValue.getClass().getSimpleName());
                this.serialize(subEntity, gen, serializers);
                continue;
            }
            if (rawValue instanceof EntityList) {
                EntityList entityList = (EntityList)rawValue;
                if (entityList.isEmpty()) continue;
                gen.writeFieldName(entityList.getType().getName());
                gen.writeStartArray();
                for (Object sub : entityList) {
                    if (!(sub instanceof Entity)) continue;
                    Entity subEntity = (Entity)sub;
                    if (subEntity.getId() == null) {
                        this.serialize(subEntity, gen, serializers);
                        continue;
                    }
                    gen.writeStartObject();
                    gen.writeFieldName("@iot.id");
                    subEntity.getId().writeTo(gen);
                    gen.writeEndObject();
                }
                gen.writeEndArray();
                continue;
            }
            TypeSerializer typeSerializer = serializers.findTypeSerializer(serializers.constructType((Type)def.getAccessor().getRawType()));
            BeanPropertyWriter writer = new BeanPropertyWriter(def, def.getAccessor(), beanDesc.getClassAnnotations(), def.getAccessor().getType(), null, typeSerializer, def.getAccessor().getType(), true, null);
            try {
                writer.serializeAsField((Object)entity, gen, serializers);
            }
            catch (Exception e) {
                logger.error("Failed to serialize entity.", (Throwable)e);
            }
        }
        gen.writeEndObject();
    }
}

