/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.ext.EntityList;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityListDeserializer<T extends Entity<T>>
extends StdDeserializer<EntityList<T>>
implements ContextualDeserializer {
    private static final long serialVersionUID = 8376494553925868647L;
    private static final Logger logger = LoggerFactory.getLogger(EntityListDeserializer.class);
    private Class<T> type;

    public EntityListDeserializer() {
        super(EntityList.class);
    }

    public EntityListDeserializer(Class<T> type) {
        super(EntityList.class);
        this.type = type;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, BeanProperty property) throws JsonMappingException {
        JavaType wrapperType = property == null ? ctxt.getContextualType() : property.getType();
        JavaType valueType = wrapperType.containedType(0);
        EntityListDeserializer<T> deserializer = new EntityListDeserializer<T>(valueType.getRawClass());
        return deserializer;
    }

    public EntityList<T> deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
        EntityList<Entity> entities = new EntityList<Entity>(EntityType.listForClass(this.type));
        JsonNode node = (JsonNode)parser.getCodec().readTree(parser);
        if (node.isArray()) {
            Iterator iter = node.elements();
            ObjectMapper mapper = (ObjectMapper)parser.getCodec();
            while (iter.hasNext()) {
                JsonNode entityNode = (JsonNode)iter.next();
                Entity entity = (Entity)mapper.readValue(entityNode.toString(), this.type);
                entities.add(entity);
            }
        } else {
            if (node.has("@iot.count")) {
                entities.setCount(node.get("@iot.count").asLong());
            }
            if (node.has("@iot.nextLink")) {
                try {
                    URI nextLink = new URI(node.get("@iot.nextLink").asText());
                    entities.setNextLink(nextLink);
                }
                catch (URISyntaxException e) {
                    logger.warn("@iot.nextLink field contains malformed URI", (Throwable)e);
                }
            }
            Iterator iter = node.get("value").elements();
            ObjectMapper mapper = (ObjectMapper)parser.getCodec();
            while (iter.hasNext()) {
                JsonNode entityNode = (JsonNode)iter.next();
                Entity entity = (Entity)mapper.readValue(entityNode.toString(), this.type);
                entities.add(entity);
            }
        }
        return entities;
    }
}

