/*
 * Decompiled with CFR 0.152.
 */
package de.fraunhofer.iosb.ilt.sta.dao;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.fraunhofer.iosb.ilt.sta.ServiceFailureException;
import de.fraunhofer.iosb.ilt.sta.dao.Dao;
import de.fraunhofer.iosb.ilt.sta.jackson.ObjectMapperFactory;
import de.fraunhofer.iosb.ilt.sta.model.Entity;
import de.fraunhofer.iosb.ilt.sta.model.EntityType;
import de.fraunhofer.iosb.ilt.sta.model.Id;
import de.fraunhofer.iosb.ilt.sta.model.IdLong;
import de.fraunhofer.iosb.ilt.sta.model.IdString;
import de.fraunhofer.iosb.ilt.sta.query.Expansion;
import de.fraunhofer.iosb.ilt.sta.query.Query;
import de.fraunhofer.iosb.ilt.sta.service.SensorThingsService;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.http.Consts;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.ParseException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDao<T extends Entity<T>>
implements Dao<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseDao.class);
    private final SensorThingsService service;
    private final EntityType plural;
    private final EntityType singular;
    private final Class<T> entityClass;
    private Entity<?> parent;

    public BaseDao(SensorThingsService service, Class<T> entityClass) {
        this.service = service;
        this.plural = EntityType.listForClass(entityClass);
        this.singular = EntityType.singleForClass(entityClass);
        this.entityClass = entityClass;
    }

    public BaseDao(SensorThingsService service, Class<T> entityClass, Entity<?> parent) {
        this(service, entityClass);
        this.parent = parent;
    }

    public BaseDao<T> setParent(Entity<?> parent) {
        this.parent = parent;
        return this;
    }

    @Override
    public void create(T entity) throws ServiceFailureException {
        if (this.parent != null && !this.parent.getType().hasRelationTo(this.plural)) {
            throw new IllegalArgumentException("Can not create entity, not a list");
        }
        CloseableHttpResponse response = null;
        URIBuilder uriBuilder = new URIBuilder(this.service.getFullPath(this.parent, this.plural));
        try {
            ObjectMapper mapper = ObjectMapperFactory.get();
            String json = mapper.writeValueAsString(entity);
            HttpPost httpPost = new HttpPost(uriBuilder.build());
            LOGGER.debug("Posting to: {}", (Object)httpPost.getURI());
            httpPost.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            response = this.service.execute((HttpUriRequest)httpPost);
            int code = response.getStatusLine().getStatusCode();
            if (code != 201) {
                if (code == 302 || code == 30 || code == 307) {
                    throw new ServiceFailureException("Server responded with a redirect to: " + Arrays.toString(response.getHeaders("Location")));
                }
                throw new ServiceFailureException(response.getStatusLine().getReasonPhrase() + " " + EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8));
            }
            Header locationHeader = response.getLastHeader("location");
            if (locationHeader == null) {
                throw new IllegalStateException("Server did not send a location header for the new entitiy.");
            }
            String newLocation = locationHeader.getValue();
            int pos1 = newLocation.indexOf(40) + 1;
            int pos2 = newLocation.indexOf(41, pos1);
            String stringId = newLocation.substring(pos1, pos2);
            ((Entity)entity).setId(Id.tryToParse(stringId));
            ((Entity)entity).setService(this.service);
        }
        catch (JsonProcessingException | URISyntaxException e) {
            throw new ServiceFailureException(e);
        }
        catch (IOException e) {
            throw new ServiceFailureException(e);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public T find(Entity<?> parent) throws ServiceFailureException {
        URI fullPath = this.service.getFullPath(parent, this.singular);
        return this.find(fullPath);
    }

    @Override
    public T find(Id id) throws ServiceFailureException {
        URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().resolve(this.entityPath(id)));
        try {
            return this.find(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    public T find(long id) throws ServiceFailureException {
        return this.find(new IdLong(id));
    }

    public T find(String id) throws ServiceFailureException {
        return this.find(new IdString(id));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T find(URI uri) throws ServiceFailureException {
        CloseableHttpResponse response = null;
        try {
            HttpGet httpGet = new HttpGet(uri);
            LOGGER.debug("Fetching: {}", (Object)uri);
            httpGet.addHeader("Accept", ContentType.APPLICATION_JSON.getMimeType());
            response = this.service.execute((HttpUriRequest)httpGet);
            String json = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)Consts.UTF_8);
            if (response.getStatusLine().getStatusCode() != 200) {
                LOGGER.info("{} not found; status {}; message: {}", new Object[]{uri, response.getStatusLine(), json});
                T t = null;
                return t;
            }
            ObjectMapper mapper = ObjectMapperFactory.get();
            Entity entity = (Entity)mapper.readValue(json, this.entityClass);
            entity.setService(this.service);
            Entity entity2 = entity;
            return (T)entity2;
        }
        catch (IOException | ParseException ex) {
            throw new ServiceFailureException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public T find(Id id, Expansion expansion) throws ServiceFailureException {
        URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().resolve(this.entityPath(id)));
        uriBuilder.addParameter("$expand", expansion.toString());
        try {
            return this.find(uriBuilder.build());
        }
        catch (URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
    }

    @Override
    public void update(T entity) throws ServiceFailureException {
        URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().resolve(this.entityPath(((Entity)entity).getId())));
        CloseableHttpResponse response = null;
        try {
            ObjectMapper mapper = ObjectMapperFactory.get();
            String json = mapper.writeValueAsString(entity);
            HttpPatch httpPatch = new HttpPatch(uriBuilder.build());
            LOGGER.debug("Patching: {}", (Object)httpPatch.getURI());
            httpPatch.setEntity((HttpEntity)new StringEntity(json, ContentType.APPLICATION_JSON));
            response = this.service.execute((HttpUriRequest)httpPatch);
            if (response.getStatusLine().getStatusCode() != 200) {
                throw new ServiceFailureException(response.getStatusLine().getReasonPhrase());
            }
        }
        catch (JsonProcessingException | URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
        catch (IOException ex) {
            throw new ServiceFailureException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public void delete(T entity) throws ServiceFailureException {
        CloseableHttpResponse response = null;
        URIBuilder uriBuilder = new URIBuilder(this.service.getEndpoint().resolve(this.entityPath(((Entity)entity).getId())));
        try {
            HttpDelete httpDelete = new HttpDelete(uriBuilder.build());
            LOGGER.debug("Deleting: {}", (Object)httpDelete.getURI());
            response = this.service.execute((HttpUriRequest)httpDelete);
        }
        catch (IOException | URISyntaxException ex) {
            throw new ServiceFailureException(ex);
        }
        finally {
            try {
                if (response != null) {
                    response.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Query<T> query() {
        return new Query<T>(this.service, this.entityClass, this.parent);
    }

    private String entityPath(Id id) {
        return String.format("%s(%s)", this.plural.getName(), id.getUrl());
    }

    protected SensorThingsService getService() {
        return this.service;
    }
}

